/**
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.kpavlov.aimocks.openai.model.responses

import kotlinx.serialization.Required
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Represents a message input resource in the OpenAI API.
 *
 * @property role The role of the message input. One of `user`, `system`, or `developer`.
 * @property content A list of one or many input items to the model, containing different content types.
 * @property id The unique ID of the message input.
 * @property type The type of the message input. Always set to `message`.
 * @property status The status of item.
 * One of `in_progress`, `completed`, or `incomplete`. Populated when items are returned via API.
 * @author Konstantin Pavlov
 */
@Serializable
public data class InputMessageResource(
    @SerialName(value = "role") @Required val role: InputMessageResource.Role,
    @SerialName(value = "content") @Required val content: List<InputContent>,
    @SerialName(value = "id") val id: String? = null,
    @SerialName(value = "type") val type: InputMessageResource.Type? = null,
    @SerialName(value = "status") val status: InputMessageResource.Status? = null,
) {
    /**
     * The role of the message input. One of `user`, `system`, or `developer`.
     */
    @Serializable
    public enum class Role(
        public val value: String,
    ) {
        @SerialName(value = "user")
        USER("user"),

        @SerialName(value = "system")
        SYSTEM("system"),

        @SerialName(value = "developer")
        DEVELOPER("developer"),
    }

    /**
     * The type of the message input. Always set to `message`.
     */
    @Serializable
    public enum class Type(
        public val value: String,
    ) {
        @SerialName(value = "message")
        MESSAGE("message"),
    }

    /**
     * The status of item. One of `in_progress`, `completed`, or `incomplete`. Populated when items are returned via API.
     */
    @Serializable
    public enum class Status(
        public val value: String,
    ) {
        @SerialName(value = "in_progress")
        IN_PROGRESS("in_progress"),

        @SerialName(value = "completed")
        COMPLETED("completed"),

        @SerialName(value = "incomplete")
        INCOMPLETE("incomplete"),
    }
}
