/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.kpavlov.aimocks.openai.model

import kotlinx.serialization.Required
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * An output message from the model.
 *
 * @param id The unique ID of the output message.
 * @param type The type of the output message. Always `message`.
 * @param role The role of the output message. Always `assistant`.
 * @param content The content of the output message.
 * @param status The status of the message input. One of `in_progress`, `completed`, or `incomplete`. Populated when input items are returned via API.
 */
@Serializable
public data class OutputMessage(
    // The unique ID of the output message.
    @SerialName(value = "id") @Required val id: kotlin.String,
    // The type of the output message. Always `message`.
    @SerialName(value = "type") @Required val type: OutputMessage.Type,
    // The role of the output message. Always `assistant`.
    @SerialName(value = "role") @Required val role: OutputMessage.Role,
    // The content of the output message.
    @SerialName(value = "content") @Required val content: kotlin.collections.List<OutputContent>,
    // The status of the message input. One of `in_progress`, `completed`, or `incomplete`. Populated when input items are returned via API.
    @SerialName(value = "status") @Required val status: OutputMessage.Status,
) {
    /**
     * The type of the output message. Always `message`.
     *
     * Values: MESSAGE
     */
    @Serializable
    public enum class Type(
        public val value: kotlin.String,
    ) {
        @SerialName(value = "message")
        MESSAGE("message"),
    }

    /**
     * The role of the output message. Always `assistant`.
     *
     * Values: ASSISTANT
     */
    @Serializable
    public enum class Role(
        public val value: kotlin.String,
    ) {
        @SerialName(value = "assistant")
        ASSISTANT("assistant"),
    }

    /**
     * The status of the message input. One of `in_progress`, `completed`, or `incomplete`. Populated when input items are returned via API.
     *
     * Values: IN_PROGRESS,COMPLETED,INCOMPLETE
     */
    @Serializable
    public enum class Status(
        public val value: kotlin.String,
    ) {
        @SerialName(value = "in_progress")
        IN_PROGRESS("in_progress"),

        @SerialName(value = "completed")
        COMPLETED("completed"),

        @SerialName(value = "incomplete")
        INCOMPLETE("incomplete"),
    }
}
