/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.usb.AndroidUsbCommunication;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0010H\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/jahnen/libaums/core/usb/UsbRequestCommunication;", "Lme/jahnen/libaums/core/usb/AndroidUsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "inRequest", "Landroid/hardware/usb/UsbRequest;", "outRequest", "workaroundBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "bulkInTransfer", "", "dest", "bulkInTransferApiLesserO", "bulkInTransferApiO", "bulkOutTransfer", "src", "bulkOutTransferApiLesserO", "bulkOutTransferApiO", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nUsbRequestCommunication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsbRequestCommunication.kt\nme/jahnen/libaums/core/usb/UsbRequestCommunication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class UsbRequestCommunication
extends AndroidUsbCommunication {
    @NotNull
    private final UsbRequest outRequest;
    @NotNull
    private final UsbRequest inRequest;
    private final ByteBuffer workaroundBuffer;

    /*
     * WARNING - void declaration
     */
    public UsbRequestCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        void $this$inRequest_u24lambda_u241;
        UsbRequest $this$outRequest_u24lambda_u240;
        UsbRequest usbRequest;
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkNotNullParameter((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkNotNullParameter((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkNotNullParameter((Object)inEndpoint, (String)"inEndpoint");
        super(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
        UsbRequest usbRequest2 = usbRequest = new UsbRequest();
        UsbRequestCommunication usbRequestCommunication = this;
        boolean bl = false;
        $this$outRequest_u24lambda_u240.initialize(this.getDeviceConnection(), outEndpoint);
        usbRequestCommunication.outRequest = usbRequest;
        $this$outRequest_u24lambda_u240 = usbRequest = new UsbRequest();
        usbRequestCommunication = this;
        boolean bl2 = false;
        $this$inRequest_u24lambda_u241.initialize(this.getDeviceConnection(), inEndpoint);
        usbRequestCommunication.inRequest = usbRequest;
        this.workaroundBuffer = ByteBuffer.allocate(131072);
    }

    @RequiresApi(value=26)
    public final int bulkOutTransferApiO(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int oldPosition = src.position();
        if (!this.outRequest.queue(src)) {
            throw new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        UsbRequest request = usbDeviceConnection.requestWait();
        if (request == this.outRequest) {
            return this.workaroundBuffer.position() - oldPosition;
        }
        throw new IOException("requestWait failed! Request: " + request);
    }

    public final int bulkOutTransferApiLesserO(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int length = src.remaining();
        int oldPosition = src.position();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.put(src);
        if (!this.outRequest.queue(this.workaroundBuffer, length)) {
            throw new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        UsbRequest request = usbDeviceConnection.requestWait();
        if (request == this.outRequest) {
            src.position(oldPosition + this.workaroundBuffer.position());
            return this.workaroundBuffer.position();
        }
        throw new IOException("requestWait failed! Request: " + request);
    }

    @Override
    public synchronized int bulkOutTransfer(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return Build.VERSION.SDK_INT >= 26 ? this.bulkOutTransferApiO(src) : this.bulkOutTransferApiLesserO(src);
    }

    public final int bulkInTransferApiLesserO(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int length = dest.remaining();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.limit(length);
        if (!this.inRequest.queue(this.workaroundBuffer, length)) {
            throw new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        UsbRequest request = usbDeviceConnection.requestWait();
        if (request == this.inRequest) {
            this.workaroundBuffer.flip();
            dest.put(this.workaroundBuffer);
            return this.workaroundBuffer.limit();
        }
        throw new IOException("requestWait failed! Request: " + request);
    }

    @RequiresApi(value=26)
    public final int bulkInTransferApiO(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int oldPosition = dest.position();
        if (!this.inRequest.queue(dest)) {
            throw new IOException("Error queueing request.");
        }
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        UsbRequest request = usbDeviceConnection.requestWait();
        if (request == this.outRequest) {
            return this.workaroundBuffer.position() - oldPosition;
        }
        throw new IOException("requestWait failed! Request: " + request);
    }

    @Override
    public synchronized int bulkInTransfer(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return Build.VERSION.SDK_INT >= 26 ? this.bulkInTransferApiO(dest) : this.bulkInTransferApiLesserO(dest);
    }
}

