/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.usb.HoneyCombMr1Communication;
import me.jahnen.libaums.core.usb.JellyBeanMr2Communication;
import me.jahnen.libaums.core.usb.UsbCommunication;
import me.jahnen.libaums.core.usb.UsbCommunicationCreator;
import me.jahnen.libaums.core.usb.UsbRequestCommunication;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lme/jahnen/libaums/core/usb/UsbCommunicationFactory;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "communications", "Ljava/util/ArrayList;", "Lme/jahnen/libaums/core/usb/UsbCommunicationCreator;", "underlyingUsbCommunication", "Lme/jahnen/libaums/core/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "getUnderlyingUsbCommunication$annotations", "getUnderlyingUsbCommunication", "()Lme/jahnen/libaums/core/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "setUnderlyingUsbCommunication", "(Lme/jahnen/libaums/core/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;)V", "createUsbCommunication", "Lme/jahnen/libaums/core/usb/UsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "registerCommunication", "", "creator", "NoUsbCommunicationFound", "UnderlyingUsbCommunication", "libaums_release"})
public final class UsbCommunicationFactory {
    @NotNull
    public static final UsbCommunicationFactory INSTANCE = new UsbCommunicationFactory();
    private static final String TAG = UsbCommunicationFactory.class.getSimpleName();
    @NotNull
    private static final ArrayList<UsbCommunicationCreator> communications = new ArrayList();
    @NotNull
    private static UnderlyingUsbCommunication underlyingUsbCommunication = UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC;

    private UsbCommunicationFactory() {
    }

    @NotNull
    public static final UnderlyingUsbCommunication getUnderlyingUsbCommunication() {
        return underlyingUsbCommunication;
    }

    public static final void setUnderlyingUsbCommunication(@NotNull UnderlyingUsbCommunication underlyingUsbCommunication) {
        Intrinsics.checkNotNullParameter((Object)((Object)underlyingUsbCommunication), (String)"<set-?>");
        UsbCommunicationFactory.underlyingUsbCommunication = underlyingUsbCommunication;
    }

    @JvmStatic
    public static /* synthetic */ void getUnderlyingUsbCommunication$annotations() {
    }

    @JvmStatic
    public static final synchronized void registerCommunication(@NotNull UsbCommunicationCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        communications.add(creator);
    }

    @NotNull
    public final UsbCommunication createUsbCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkNotNullParameter((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkNotNullParameter((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkNotNullParameter((Object)inEndpoint, (String)"inEndpoint");
        switch (WhenMappings.$EnumSwitchMapping$0[underlyingUsbCommunication.ordinal()]) {
            case 1: {
                UsbCommunication usbCommunication;
                if (Build.VERSION.SDK_INT >= 18) {
                    usbCommunication = new JellyBeanMr2Communication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
                } else {
                    Log.i((String)TAG, (String)"using workaround usb communication");
                    usbCommunication = new HoneyCombMr1Communication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
                }
                return usbCommunication;
            }
            case 2: {
                return new UsbRequestCommunication(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
            }
            case 3: {
                for (UsbCommunicationCreator creator : communications) {
                    UsbCommunication communication = creator.create(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
                    if (communication == null) continue;
                    return communication;
                }
                break;
            }
        }
        throw new NoUsbCommunicationFound();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/usb/UsbCommunicationFactory$UnderlyingUsbCommunication;", "", "(Ljava/lang/String;I)V", "USB_REQUEST_ASYNC", "DEVICE_CONNECTION_SYNC", "OTHER", "libaums_release"})
    public static final class UnderlyingUsbCommunication
    extends Enum<UnderlyingUsbCommunication> {
        public static final /* enum */ UnderlyingUsbCommunication USB_REQUEST_ASYNC = new UnderlyingUsbCommunication();
        public static final /* enum */ UnderlyingUsbCommunication DEVICE_CONNECTION_SYNC = new UnderlyingUsbCommunication();
        public static final /* enum */ UnderlyingUsbCommunication OTHER = new UnderlyingUsbCommunication();
        private static final /* synthetic */ UnderlyingUsbCommunication[] $VALUES;

        public static UnderlyingUsbCommunication[] values() {
            return (UnderlyingUsbCommunication[])$VALUES.clone();
        }

        public static UnderlyingUsbCommunication valueOf(String value) {
            return Enum.valueOf(UnderlyingUsbCommunication.class, value);
        }

        static {
            $VALUES = underlyingUsbCommunicationArray = new UnderlyingUsbCommunication[]{UnderlyingUsbCommunication.USB_REQUEST_ASYNC, UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC, UnderlyingUsbCommunication.OTHER};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UnderlyingUsbCommunication.values().length];
            try {
                nArray[UnderlyingUsbCommunication.DEVICE_CONNECTION_SYNC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnderlyingUsbCommunication.USB_REQUEST_ASYNC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnderlyingUsbCommunication.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/jahnen/libaums/core/usb/UsbCommunicationFactory$NoUsbCommunicationFound;", "Ljava/io/IOException;", "()V", "libaums_release"})
    public static final class NoUsbCommunicationFound
    extends IOException {
    }
}

