/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.usb.AndroidUsbCommunication;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lme/jahnen/libaums/core/usb/HoneyCombMr1Communication;", "Lme/jahnen/libaums/core/usb/AndroidUsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "bulkInTransfer", "", "dest", "Ljava/nio/ByteBuffer;", "bulkOutTransfer", "src", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nHoneyCombMr1Communication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoneyCombMr1Communication.kt\nme/jahnen/libaums/core/usb/HoneyCombMr1Communication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class HoneyCombMr1Communication
extends AndroidUsbCommunication {
    public HoneyCombMr1Communication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkNotNullParameter((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkNotNullParameter((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkNotNullParameter((Object)inEndpoint, (String)"inEndpoint");
        super(usbManager, usbDevice, usbInterface, outEndpoint, inEndpoint);
    }

    @Override
    public int bulkOutTransfer(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (!(!this.isClosed())) {
            boolean $i$a$-require-HoneyCombMr1Communication$bulkOutTransfer$22 = false;
            String $i$a$-require-HoneyCombMr1Communication$bulkOutTransfer$22 = "device is closed";
            throw new IllegalArgumentException($i$a$-require-HoneyCombMr1Communication$bulkOutTransfer$22.toString());
        }
        int offset = src.position();
        if (offset == 0) {
            UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
            Intrinsics.checkNotNull((Object)usbDeviceConnection);
            int result = usbDeviceConnection.bulkTransfer(this.getOutEndpoint(), src.array(), src.remaining(), 5000);
            if (result == -1) {
                throw new IOException("Could not write to device, result == -1");
            }
            src.position(src.position() + result);
            return result;
        }
        byte[] tmpBuffer = new byte[src.remaining()];
        System.arraycopy(src.array(), offset, tmpBuffer, 0, src.remaining());
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        int result = usbDeviceConnection.bulkTransfer(this.getOutEndpoint(), tmpBuffer, src.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not write to device, result == -1");
        }
        src.position(src.position() + result);
        return result;
    }

    @Override
    public int bulkInTransfer(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(!this.isClosed())) {
            boolean $i$a$-require-HoneyCombMr1Communication$bulkInTransfer$22 = false;
            String $i$a$-require-HoneyCombMr1Communication$bulkInTransfer$22 = "device is closed";
            throw new IllegalArgumentException($i$a$-require-HoneyCombMr1Communication$bulkInTransfer$22.toString());
        }
        int offset = dest.position();
        if (offset == 0) {
            UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
            Intrinsics.checkNotNull((Object)usbDeviceConnection);
            int result = usbDeviceConnection.bulkTransfer(this.getInEndpoint(), dest.array(), dest.remaining(), 5000);
            if (result == -1) {
                throw new IOException("Could read from to device, result == -1");
            }
            dest.position(dest.position() + result);
            return result;
        }
        byte[] tmpBuffer = new byte[dest.remaining()];
        UsbDeviceConnection usbDeviceConnection = this.getDeviceConnection();
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        int result = usbDeviceConnection.bulkTransfer(this.getInEndpoint(), tmpBuffer, dest.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not read from device, result == -1");
        }
        System.arraycopy(tmpBuffer, 0, dest.array(), offset, result);
        dest.position(dest.position() + result);
        return result;
    }
}

