/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.ErrNo;
import me.jahnen.libaums.core.usb.UsbCommunication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0007\b \u0018\u0000 12\u00020\u0001:\u00011B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0019\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\"H\u0082 J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J8\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\"H\u0016J\b\u0010-\u001a\u00020\u001eH\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020\u001eH\u0016J\u0011\u00100\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0082 R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lme/jahnen/libaums/core/usb/AndroidUsbCommunication;", "Lme/jahnen/libaums/core/usb/UsbCommunication;", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "getDeviceConnection", "()Landroid/hardware/usb/UsbDeviceConnection;", "setDeviceConnection", "(Landroid/hardware/usb/UsbDeviceConnection;)V", "getInEndpoint", "()Landroid/hardware/usb/UsbEndpoint;", "isClosed", "", "()Z", "setClosed", "(Z)V", "isNativeInited", "getOutEndpoint", "getUsbInterface", "()Landroid/hardware/usb/UsbInterface;", "clearFeatureHalt", "", "endpoint", "clearHaltNative", "fd", "", "close", "closeUsbConnection", "controlTransfer", "requestType", "request", "value", "index", "buffer", "", "length", "initNativeLibrary", "initUsbConnection", "resetDevice", "resetUsbDeviceNative", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nAndroidUsbCommunication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidUsbCommunication.kt\nme/jahnen/libaums/core/usb/AndroidUsbCommunication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class AndroidUsbCommunication
implements UsbCommunication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsbManager usbManager;
    @NotNull
    private final UsbDevice usbDevice;
    @NotNull
    private final UsbInterface usbInterface;
    @NotNull
    private final UsbEndpoint outEndpoint;
    @NotNull
    private final UsbEndpoint inEndpoint;
    private boolean isNativeInited;
    @Nullable
    private UsbDeviceConnection deviceConnection;
    private boolean isClosed;
    private static final String TAG = AndroidUsbCommunication.class.getSimpleName();

    public AndroidUsbCommunication(@NotNull UsbManager usbManager, @NotNull UsbDevice usbDevice, @NotNull UsbInterface usbInterface, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        Intrinsics.checkNotNullParameter((Object)usbManager, (String)"usbManager");
        Intrinsics.checkNotNullParameter((Object)usbDevice, (String)"usbDevice");
        Intrinsics.checkNotNullParameter((Object)usbInterface, (String)"usbInterface");
        Intrinsics.checkNotNullParameter((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkNotNullParameter((Object)inEndpoint, (String)"inEndpoint");
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
        this.initNativeLibrary();
        this.initUsbConnection();
    }

    @Override
    @NotNull
    public UsbInterface getUsbInterface() {
        return this.usbInterface;
    }

    @Override
    @NotNull
    public UsbEndpoint getOutEndpoint() {
        return this.outEndpoint;
    }

    @Override
    @NotNull
    public UsbEndpoint getInEndpoint() {
        return this.inEndpoint;
    }

    @Nullable
    public final UsbDeviceConnection getDeviceConnection() {
        return this.deviceConnection;
    }

    public final void setDeviceConnection(@Nullable UsbDeviceConnection usbDeviceConnection) {
        this.deviceConnection = usbDeviceConnection;
    }

    protected final boolean isClosed() {
        return this.isClosed;
    }

    protected final void setClosed(boolean bl) {
        this.isClosed = bl;
    }

    private final void initUsbConnection() {
        if (this.isClosed) {
            return;
        }
        Log.d((String)TAG, (String)"setup device");
        UsbDeviceConnection usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        if (usbDeviceConnection == null) {
            throw new IOException("deviceConnection is null!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection = usbDeviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection2);
        boolean claim = usbDeviceConnection2.claimInterface(this.getUsbInterface(), true);
        if (!claim) {
            throw new IOException("could not claim interface!");
        }
    }

    private final void initNativeLibrary() {
        try {
            System.loadLibrary("usb-lib");
            this.isNativeInited = true;
        }
        catch (UnsatisfiedLinkError e) {
            this.isNativeInited = false;
            Log.e((String)TAG, (String)"could not load usb-lib", (Throwable)e);
        }
    }

    @Override
    public int controlTransfer(int requestType, int request, int value, int index, @NotNull byte[] buffer, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "device is closed";
            throw new IllegalArgumentException(string.toString());
        }
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        return usbDeviceConnection.controlTransfer(requestType, request, value, index, buffer, length, 5000);
    }

    @Override
    public void resetDevice() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "device is closed";
            throw new IllegalArgumentException(string.toString());
        }
        Log.d((String)TAG, (String)"Performing native reset");
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        if (!usbDeviceConnection.releaseInterface(this.getUsbInterface())) {
            Log.w((String)TAG, (String)("Failed to release interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection2);
        if (!this.resetUsbDeviceNative(usbDeviceConnection2.getFileDescriptor())) {
            Log.w((String)TAG, (String)("ioctl failed! errno " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
            Log.w((String)TAG, (String)"USB device will likely require new discovery and permissions");
        }
        UsbDeviceConnection usbDeviceConnection3 = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection3);
        if (!usbDeviceConnection3.claimInterface(this.getUsbInterface(), true)) {
            throw new IOException("Could not claim interface, errno: " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr());
        }
    }

    @Override
    public void clearFeatureHalt(@NotNull UsbEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "device is closed";
            throw new IllegalArgumentException(string.toString());
        }
        Log.w((String)TAG, (String)("Clearing halt on endpoint " + endpoint + " (direction " + endpoint.getDirection() + ')'));
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        boolean result = this.clearHaltNative(usbDeviceConnection.getFileDescriptor(), endpoint.getAddress());
        if (!result) {
            Log.e((String)TAG, (String)("Clear halt failed: errno " + ErrNo.INSTANCE.getErrno() + ' ' + ErrNo.INSTANCE.getErrstr()));
        }
    }

    private final void closeUsbConnection() {
        if (this.deviceConnection == null) {
            return;
        }
        UsbDeviceConnection usbDeviceConnection = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection);
        boolean release = usbDeviceConnection.releaseInterface(this.getUsbInterface());
        if (!release) {
            Log.e((String)TAG, (String)"could not release interface!");
        }
        UsbDeviceConnection usbDeviceConnection2 = this.deviceConnection;
        Intrinsics.checkNotNull((Object)usbDeviceConnection2);
        usbDeviceConnection2.close();
    }

    @Override
    public void close() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "device is already closed";
            throw new IllegalArgumentException(string.toString());
        }
        Log.d((String)TAG, (String)"close device");
        this.closeUsbConnection();
        this.isClosed = true;
    }

    private final native boolean resetUsbDeviceNative(int var1);

    private final native boolean clearHaltNative(int var1, int var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/usb/AndroidUsbCommunication$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

