/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.partition.fs;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.FileSystem;
import me.jahnen.libaums.core.partition.PartitionTable;
import me.jahnen.libaums.core.partition.PartitionTableEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lme/jahnen/libaums/core/partition/fs/FileSystemPartitionTable;", "Lme/jahnen/libaums/core/partition/PartitionTable;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "fs", "Lme/jahnen/libaums/core/fs/FileSystem;", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Lme/jahnen/libaums/core/fs/FileSystem;)V", "entries", "", "Lme/jahnen/libaums/core/partition/PartitionTableEntry;", "getEntries$libaums_release", "()Ljava/util/List;", "setEntries$libaums_release", "(Ljava/util/List;)V", "partitionTableEntries", "", "getPartitionTableEntries", "size", "", "getSize", "()I", "Companion", "libaums_release"})
public final class FileSystemPartitionTable
implements PartitionTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<PartitionTableEntry> entries;
    private static final String TAG = FileSystemPartitionTable.class.getSimpleName();

    public FileSystemPartitionTable(@NotNull BlockDeviceDriver blockDevice, @NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.entries = new ArrayList();
        Log.i((String)TAG, (String)"Found a device without partition table, yay!");
        long totalNumberOfSectors = fs.getCapacity() / (long)blockDevice.getBlockSize();
        if (fs.getCapacity() % (long)blockDevice.getBlockSize() != 0L) {
            Log.w((String)TAG, (String)"fs capacity is not multiple of block size");
        }
        this.entries.add(new PartitionTableEntry(fs.getType(), 0L, totalNumberOfSectors));
    }

    @NotNull
    public final List<PartitionTableEntry> getEntries$libaums_release() {
        return this.entries;
    }

    public final void setEntries$libaums_release(@NotNull List<PartitionTableEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entries = list;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    @NotNull
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.entries;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/partition/fs/FileSystemPartitionTable$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

