/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.partition;

import android.util.Log;
import com.github.mjdev.libaums.partition.gpt.GPTCreator;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.partition.PartitionTable;
import me.jahnen.libaums.core.partition.fs.FileSystemPartitionTableCreator;
import me.jahnen.libaums.core.partition.mbr.MasterBootRecordCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/jahnen/libaums/core/partition/PartitionTableFactory;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "partitionTables", "Ljava/util/ArrayList;", "Lme/jahnen/libaums/core/partition/PartitionTableFactory$PartitionTableCreator;", "createPartitionTable", "Lme/jahnen/libaums/core/partition/PartitionTable;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "registerPartitionTable", "", "creator", "PartitionTableCreator", "UnsupportedPartitionTableException", "libaums_release"})
public final class PartitionTableFactory {
    @NotNull
    public static final PartitionTableFactory INSTANCE = new PartitionTableFactory();
    private static final String TAG = PartitionTableFactory.class.getSimpleName();
    @NotNull
    private static final ArrayList<PartitionTableCreator> partitionTables = new ArrayList();

    private PartitionTableFactory() {
    }

    @NotNull
    public final PartitionTable createPartitionTable(@NotNull BlockDeviceDriver blockDevice) throws IOException {
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        for (PartitionTableCreator creator : partitionTables) {
            PartitionTable table = creator.read(blockDevice);
            if (table != null) {
                Log.d((String)TAG, (String)("Found partition table " + creator.getClass().getSimpleName()));
                return table;
            }
            Log.d((String)TAG, (String)(creator.getClass().getSimpleName() + " returned null"));
        }
        throw new UnsupportedPartitionTableException();
    }

    public final synchronized void registerPartitionTable(@NotNull PartitionTableCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        partitionTables.add(creator);
    }

    static {
        INSTANCE.registerPartitionTable(new FileSystemPartitionTableCreator());
        INSTANCE.registerPartitionTable(new GPTCreator());
        INSTANCE.registerPartitionTable(new MasterBootRecordCreator());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/partition/PartitionTableFactory$PartitionTableCreator;", "", "read", "Lme/jahnen/libaums/core/partition/PartitionTable;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "libaums_release"})
    public static interface PartitionTableCreator {
        @Nullable
        public PartitionTable read(@NotNull BlockDeviceDriver var1) throws IOException;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/jahnen/libaums/core/partition/PartitionTableFactory$UnsupportedPartitionTableException;", "Ljava/io/IOException;", "()V", "libaums_release"})
    public static final class UnsupportedPartitionTableException
    extends IOException {
    }
}

