/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.partition;

import android.util.Log;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.driver.ByteBlockDevice;
import me.jahnen.libaums.core.fs.FileSystem;
import me.jahnen.libaums.core.fs.FileSystemFactory;
import me.jahnen.libaums.core.partition.PartitionTableEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lme/jahnen/libaums/core/partition/Partition;", "Lme/jahnen/libaums/core/driver/ByteBlockDevice;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "entry", "Lme/jahnen/libaums/core/partition/PartitionTableEntry;", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Lme/jahnen/libaums/core/partition/PartitionTableEntry;)V", "<set-?>", "Lme/jahnen/libaums/core/fs/FileSystem;", "fileSystem", "getFileSystem", "()Lme/jahnen/libaums/core/fs/FileSystem;", "volumeLabel", "", "getVolumeLabel", "()Ljava/lang/String;", "Companion", "libaums_release"})
public final class Partition
extends ByteBlockDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private FileSystem fileSystem;
    private static final String TAG = Partition.class.getSimpleName();

    public Partition(@NotNull BlockDeviceDriver blockDevice, @NotNull PartitionTableEntry entry) {
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        super(blockDevice, entry.getLogicalBlockAddress());
    }

    @NotNull
    public final FileSystem getFileSystem() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem != null) {
            return fileSystem;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileSystem");
        return null;
    }

    @NotNull
    public final String getVolumeLabel() {
        return this.getFileSystem().getVolumeLabel();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/jahnen/libaums/core/partition/Partition$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "createPartition", "Lme/jahnen/libaums/core/partition/Partition;", "entry", "Lme/jahnen/libaums/core/partition/PartitionTableEntry;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Partition createPartition(@NotNull PartitionTableEntry entry, @NotNull BlockDeviceDriver blockDevice) throws IOException {
            Partition partition;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
            try {
                Partition partition2 = new Partition(blockDevice, entry);
                FileSystem fs = FileSystemFactory.INSTANCE.createFileSystem(entry, partition2);
                partition2.fileSystem = fs;
            }
            catch (FileSystemFactory.UnsupportedFileSystemException e) {
                Log.w((String)TAG, (String)"Unsupported fs on partition");
                partition = null;
            }
            return partition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

