/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jahnen.libaums.core.fs.fat32.ShortName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lme/jahnen/libaums/core/fs/fat32/ShortNameGenerator;", "", "()V", "containShortName", "", "shortNames", "", "Lme/jahnen/libaums/core/fs/fat32/ShortName;", "shortName", "containsInvalidChars", "str", "", "generateShortName", "lfnName", "existingShortNames", "getNextHexPart", "hexPart", "limit", "", "isValidChar", "c", "", "replaceInvalidChars", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nShortNameGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortNameGenerator.kt\nme/jahnen/libaums/core/fs/fat32/ShortNameGenerator\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,213:1\n107#2:214\n79#2,22:215\n*S KotlinDebug\n*F\n+ 1 ShortNameGenerator.kt\nme/jahnen/libaums/core/fs/fat32/ShortNameGenerator\n*L\n121#1:214\n121#1:215,22\n*E\n"})
public final class ShortNameGenerator {
    @NotNull
    public static final ShortNameGenerator INSTANCE = new ShortNameGenerator();

    private ShortNameGenerator() {
    }

    private final boolean isValidChar(char c) {
        boolean bl = '0' <= c ? c < ':' : false;
        if (bl) {
            return true;
        }
        return ('A' <= c ? c < '[' : false) ? true : c == '$' || c == '%' || c == '\'' || c == '-' || c == '_' || c == '@' || c == '~' || c == '`' || c == '!' || c == '(' || c == ')' || c == '{' || c == '}' || c == '^' || c == '#' || c == '&';
    }

    private final boolean containsInvalidChars(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (this.isValidChar(c)) continue;
            return true;
        }
        return false;
    }

    private final String replaceInvalidChars(String str) {
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (this.isValidChar(c)) {
                builder.append(c);
                continue;
            }
            builder.append("_");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String getNextHexPart(String hexPart, int limit) {
        String tempHexString;
        long hexValue = Long.parseLong(hexPart, 16);
        if ((tempHexString = Long.toHexString(++hexValue)).length() <= limit) {
            StringBuilder sb = new StringBuilder();
            int n = limit - tempHexString.length();
            for (int i = 0; i < n; ++i) {
                sb.append("0");
            }
            return sb.toString() + tempHexString;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShortName generateShortName(@NotNull String lfnName, @NotNull Collection<ShortName> existingShortNames) {
        int i;
        void $this$trim$iv;
        String lfnName2;
        Intrinsics.checkNotNullParameter((Object)lfnName, (String)"lfnName");
        Intrinsics.checkNotNullParameter(existingShortNames, (String)"existingShortNames");
        String string = lfnName2 = lfnName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        string = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        lfnName2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        for (i = 0; i < lfnName2.length() && lfnName2.charAt(i) == '.'; ++i) {
        }
        String string3 = lfnName2.substring(i);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        lfnName2 = string3;
        lfnName2 = StringsKt.replace$default((String)lfnName2, (String)" ", (String)"", (boolean)false, (int)4, null);
        String filenamePart = null;
        String extensionPart = null;
        int indexOfDot = StringsKt.lastIndexOf$default((CharSequence)lfnName2, (String)".", (int)0, (boolean)false, (int)6, null);
        if (indexOfDot == -1) {
            filenamePart = lfnName2;
            extensionPart = "";
        } else {
            String string4 = lfnName2.substring(0, indexOfDot);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            filenamePart = string4;
            String string5 = lfnName2.substring(indexOfDot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            extensionPart = string5;
            if (extensionPart.length() > 3) {
                String string6 = extensionPart.substring(0, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                extensionPart = string6;
            }
        }
        if (this.containsInvalidChars(filenamePart)) {
            filenamePart = this.replaceInvalidChars(filenamePart);
        }
        if (this.containsInvalidChars(extensionPart)) {
            extensionPart = this.replaceInvalidChars(extensionPart);
        }
        String filePrefix = filenamePart;
        if (((CharSequence)filenamePart).length() == 0) {
            filePrefix = "__";
        } else if (filenamePart.length() == 1) {
            filePrefix = filePrefix + '_';
        } else if (filenamePart.length() != 2 && filenamePart.length() > 2) {
            String string7 = filenamePart.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            filePrefix = string7;
        }
        String extSuffix = extensionPart;
        if (((CharSequence)extensionPart).length() == 0) {
            extSuffix = "000";
        } else if (extensionPart.length() == 1) {
            extSuffix = extensionPart + "00";
        } else if (extensionPart.length() == 2) {
            extSuffix = extensionPart + '0';
        }
        String hexPart = "0000";
        int tildeDigit = 0;
        ShortName result = new ShortName(filePrefix + hexPart + '~' + tildeDigit, extSuffix);
        while (this.containShortName(existingShortNames, result)) {
            String hexPartNullable = this.getNextHexPart(hexPart, 4);
            if (hexPartNullable != null) {
                hexPart = hexPartNullable;
            } else {
                if (tildeDigit + 1 >= 10) break;
                ++tildeDigit;
                hexPart = "0000";
            }
            result = new ShortName(filePrefix + hexPart + '~' + tildeDigit, extSuffix);
        }
        return result;
    }

    private final boolean containShortName(Collection<ShortName> shortNames, ShortName shortName) {
        boolean contain = false;
        for (ShortName temp : shortNames) {
            if (!StringsKt.equals((String)temp.getString(), (String)shortName.getString(), (boolean)true)) continue;
            contain = true;
            break;
        }
        return contain;
    }
}

