/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import me.jahnen.libaums.core.fs.fat32.FatDirectoryEntry;
import me.jahnen.libaums.core.fs.fat32.ShortName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020#J\u0006\u0010'\u001a\u00020#J\u0006\u0010(\u001a\u00020#J\u0016\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010+\u001a\u00020\u0003H\u0016R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018\u00a8\u0006-"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;", "", "name", "", "shortName", "Lme/jahnen/libaums/core/fs/fat32/ShortName;", "(Ljava/lang/String;Lme/jahnen/libaums/core/fs/fat32/ShortName;)V", "actualEntry", "Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "lfnName", "(Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;Ljava/lang/String;)V", "<set-?>", "getActualEntry", "()Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "entryCount", "", "getEntryCount", "()I", "newSize", "", "fileSize", "getFileSize", "()J", "setFileSize", "(J)V", "isDirectory", "", "()Z", "getName$libaums_release", "()Ljava/lang/String;", "newStartCluster", "startCluster", "getStartCluster", "setStartCluster", "serialize", "", "buffer", "Ljava/nio/ByteBuffer;", "setDirectory", "setLastAccessedTimeToNow", "setLastModifiedTimeToNow", "setName", "newName", "toString", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nFatLfnDirectoryEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FatLfnDirectoryEntry.kt\nme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,266:1\n1#2:267\n731#3,9:268\n37#4,2:277\n*S KotlinDebug\n*F\n+ 1 FatLfnDirectoryEntry.kt\nme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry\n*L\n96#1:268,9\n96#1:277,2\n*E\n"})
public final class FatLfnDirectoryEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String lfnName;
    @NotNull
    private FatDirectoryEntry actualEntry;

    private FatLfnDirectoryEntry(FatDirectoryEntry actualEntry, String lfnName) {
        this.lfnName = lfnName;
        this.actualEntry = actualEntry;
    }

    @NotNull
    public final FatDirectoryEntry getActualEntry() {
        return this.actualEntry;
    }

    public final int getEntryCount() {
        int result;
        block1: {
            result = 0;
            result = 1;
            String string = this.lfnName;
            if (string == null) break block1;
            String lfnName = string;
            boolean bl = false;
            int len = lfnName.length();
            result += len / 13;
            if (len % 13 != 0) {
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getName$libaums_release() {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String sname;
        String string = this.lfnName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        ShortName shortName = this.actualEntry.getShortName();
        Intrinsics.checkNotNull((Object)shortName);
        String name = sname = shortName.getString();
        String ext = "";
        Object object = sname;
        Regex regex = new Regex("\\.");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        if (split.length == 2) {
            name = split[0];
            ext = split[1];
        }
        if (this.actualEntry.isShortNameLowerCase()) {
            String string2 = name.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
            name = string2;
        }
        if (this.actualEntry.isShortNameExtLowerCase()) {
            String string3 = ext.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
            ext = string3;
        }
        if (((CharSequence)ext).length() > 0) {
            name = name + '.' + ext;
        }
        return name;
    }

    public final long getFileSize() {
        return this.actualEntry.getFileSize();
    }

    public final void setFileSize(long newSize) {
        this.actualEntry.setFileSize(newSize);
    }

    public final long getStartCluster() {
        return this.actualEntry.getStartCluster();
    }

    public final void setStartCluster(long newStartCluster) {
        this.actualEntry.setStartCluster(newStartCluster);
    }

    public final boolean isDirectory() {
        return this.actualEntry.isDirectory();
    }

    public FatLfnDirectoryEntry(@Nullable String name, @NotNull ShortName shortName) {
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        this(new FatDirectoryEntry(), name);
        this.actualEntry.setShortName(shortName);
    }

    public final void serialize(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        String string = this.lfnName;
        if (string != null) {
            String lfnName = string;
            boolean bl = false;
            ShortName shortName = this.actualEntry.getShortName();
            Intrinsics.checkNotNull((Object)shortName);
            byte checksum = shortName.calculateCheckSum();
            int entrySize = this.getEntryCount();
            int index = entrySize - 2;
            FatDirectoryEntry entry = FatDirectoryEntry.Companion.createLfnPart(lfnName, index * 13, checksum, index + 1, true);
            entry.serialize(buffer);
            while (index-- > 0) {
                entry = FatDirectoryEntry.Companion.createLfnPart(lfnName, index * 13, checksum, index + 1, false);
                entry.serialize(buffer);
            }
        }
        this.actualEntry.serialize(buffer);
    }

    public final void setName(@NotNull String newName, @NotNull ShortName shortName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        this.lfnName = newName;
        this.actualEntry.setShortName(shortName);
    }

    public final void setLastAccessedTimeToNow() {
        this.actualEntry.setLastAccessedDateTime(System.currentTimeMillis());
    }

    public final void setLastModifiedTimeToNow() {
        this.actualEntry.setLastModifiedDateTime(System.currentTimeMillis());
    }

    public final void setDirectory() {
        this.actualEntry.setDirectory();
    }

    @NotNull
    public String toString() {
        return "[FatLfnDirectoryEntry getName()=" + this.getName$libaums_release() + ']';
    }

    public /* synthetic */ FatLfnDirectoryEntry(FatDirectoryEntry actualEntry, String lfnName, DefaultConstructorMarker $constructor_marker) {
        this(actualEntry, lfnName);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001c\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a8\u0006\r"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry$Companion;", "", "()V", "copyDateTime", "", "from", "Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;", "to", "read", "actualEntry", "Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "lfnParts", "", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FatLfnDirectoryEntry read(@NotNull FatDirectoryEntry actualEntry, @NotNull List<FatDirectoryEntry> lfnParts) {
            Intrinsics.checkNotNullParameter((Object)actualEntry, (String)"actualEntry");
            Intrinsics.checkNotNullParameter(lfnParts, (String)"lfnParts");
            StringBuilder builder = new StringBuilder(13 * lfnParts.size());
            if (!((Collection)lfnParts).isEmpty()) {
                int n = lfnParts.size() + -1;
                if (0 <= n) {
                    do {
                        int i = n--;
                        lfnParts.get(i).extractLfnPart(builder);
                    } while (0 <= n);
                }
                return new FatLfnDirectoryEntry(actualEntry, builder.toString(), null);
            }
            return new FatLfnDirectoryEntry(actualEntry, null, null);
        }

        public final void copyDateTime(@NotNull FatLfnDirectoryEntry from, @NotNull FatLfnDirectoryEntry to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            FatDirectoryEntry actualFrom = from.getActualEntry();
            FatDirectoryEntry actualTo = to.getActualEntry();
            actualTo.setCreatedDateTime(actualFrom.getCreatedDateTime());
            actualTo.setLastAccessedDateTime(actualFrom.getLastAccessedDateTime());
            actualTo.setLastModifiedDateTime(actualFrom.getLastModifiedDateTime());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

