/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.AbstractUsbFile;
import me.jahnen.libaums.core.fs.UsbFile;
import me.jahnen.libaums.core.fs.fat32.ClusterChain;
import me.jahnen.libaums.core.fs.fat32.FAT;
import me.jahnen.libaums.core.fs.fat32.Fat32BootSector;
import me.jahnen.libaums.core.fs.fat32.FatDirectory;
import me.jahnen.libaums.core.fs.fat32.FatLfnDirectoryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010*\u001a\u00020\u0014H\u0016J\b\u0010+\u001a\u00020&H\u0016J\b\u0010,\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020&H\u0002J\b\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b01H\u0016\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\b\u0012\u0004\u0012\u00020(01H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020(H\u0016J\u0018\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00142\u0006\u00106\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020&2\u0006\u00108\u001a\u00020\u00142\u0006\u0010;\u001a\u000209H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006<"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatFile;", "Lme/jahnen/libaums/core/fs/AbstractUsbFile;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "fat", "Lme/jahnen/libaums/core/fs/fat32/FAT;", "bootSector", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "entry", "Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;", "parent", "Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Lme/jahnen/libaums/core/fs/fat32/FAT;Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;Lme/jahnen/libaums/core/fs/fat32/FatDirectory;)V", "chain", "Lme/jahnen/libaums/core/fs/fat32/ClusterChain;", "isDirectory", "", "()Z", "isRoot", "newLength", "", "length", "getLength", "()J", "setLength", "(J)V", "newName", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getParent", "()Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "setParent", "(Lme/jahnen/libaums/core/fs/fat32/FatDirectory;)V", "close", "", "createDirectory", "Lme/jahnen/libaums/core/fs/UsbFile;", "createFile", "createdAt", "delete", "flush", "initChain", "lastAccessed", "lastModified", "list", "", "()[Ljava/lang/String;", "listFiles", "()[Lme/jahnen/libaums/core/fs/UsbFile;", "moveTo", "destination", "read", "offset", "Ljava/nio/ByteBuffer;", "write", "source", "libaums_release"})
public final class FatFile
extends AbstractUsbFile {
    @NotNull
    private final BlockDeviceDriver blockDevice;
    @NotNull
    private final FAT fat;
    @NotNull
    private final Fat32BootSector bootSector;
    @NotNull
    private final FatLfnDirectoryEntry entry;
    @Nullable
    private FatDirectory parent;
    private ClusterChain chain;

    public FatFile(@NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector, @NotNull FatLfnDirectoryEntry entry, @Nullable FatDirectory parent) {
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkNotNullParameter((Object)fat, (String)"fat");
        Intrinsics.checkNotNullParameter((Object)bootSector, (String)"bootSector");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.blockDevice = blockDevice;
        this.fat = fat;
        this.bootSector = bootSector;
        this.entry = entry;
        this.parent = parent;
    }

    @Override
    @Nullable
    public FatDirectory getParent() {
        return this.parent;
    }

    public void setParent(@Nullable FatDirectory fatDirectory) {
        this.parent = fatDirectory;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return this.entry.getName$libaums_release();
    }

    @Override
    public void setName(@NotNull String newName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.renameEntry$libaums_release(this.entry, newName);
    }

    @Override
    public long getLength() {
        return this.entry.getFileSize();
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.initChain();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.setLength$libaums_release(newLength);
        this.entry.setFileSize(newLength);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    private final void initChain() throws IOException {
        if (this.chain == null) {
            this.chain = new ClusterChain(this.entry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
    }

    @Override
    public long createdAt() {
        return this.entry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public long lastModified() {
        return this.entry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public long lastAccessed() {
        return this.entry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    @NotNull
    public String[] list() {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    @NotNull
    public UsbFile[] listFiles() throws IOException {
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public void read(long offset, @NotNull ByteBuffer destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.initChain();
        this.entry.setLastAccessedTimeToNow();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.read$libaums_release(offset, destination);
    }

    @Override
    public void write(long offset, @NotNull ByteBuffer source) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.initChain();
        long length = offset + (long)source.remaining();
        if (length > this.getLength()) {
            this.setLength(length);
        }
        this.entry.setLastModifiedTimeToNow();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.write$libaums_release(offset, source);
    }

    @Override
    public void flush() throws IOException {
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.write$libaums_release();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    @NotNull
    public UsbFile createDirectory(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    @NotNull
    public UsbFile createFile(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        throw new UnsupportedOperationException("This is a file!");
    }

    @Override
    public void moveTo(@NotNull UsbFile destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.move$libaums_release(this.entry, destination);
        this.setParent((FatDirectory)destination);
    }

    @Override
    public void delete() throws IOException {
        this.initChain();
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.removeEntry$libaums_release(this.entry);
        FatDirectory fatDirectory2 = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory2);
        fatDirectory2.write$libaums_release();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.setLength$libaums_release(0L);
    }
}

