/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.fs.FileSystemFactory;
import me.jahnen.libaums.core.fs.fat32.ShortName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 J2\u00020\u0001:\u0001JB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u00107\u001a\u0002082\n\u00109\u001a\u00060:j\u0002`;J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010@\u001a\u00020\u00162\u0006\u0010A\u001a\u00020\u0012H\u0002J\u000e\u0010B\u001a\u0002082\u0006\u0010C\u001a\u00020\u0004J\u0006\u0010D\u001a\u000208J\u0010\u0010E\u001a\u0002082\u0006\u0010A\u001a\u00020\u0012H\u0002J\u0018\u0010F\u001a\u0002082\u0006\u0010=\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u0012H\u0002J\u0018\u0010H\u001a\u0002082\u0006\u0010=\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u0007H\u0002J\b\u0010I\u001a\u000204H\u0016R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R\u0011\u0010\u001d\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u001f\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010 \u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017R\u0011\u0010!\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R$\u0010\"\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010\fR$\u0010%\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR*\u0010*\u001a\u0004\u0018\u00010)2\b\u0010(\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\n\"\u0004\b2\u0010\fR\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006K"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "", "()V", "data", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "dateTime", "", "createdDateTime", "getCreatedDateTime", "()J", "setCreatedDateTime", "(J)V", "newSize", "fileSize", "getFileSize", "setFileSize", "flags", "", "getFlags", "()I", "isArchive", "", "()Z", "isDeleted", "isDirectory", "isHidden", "isLfnEntry", "isReadOnly", "isShortNameExtLowerCase", "isShortNameLowerCase", "isSystem", "isVolume", "isVolumeLabel", "lastAccessedDateTime", "getLastAccessedDateTime", "setLastAccessedDateTime", "lastModifiedDateTime", "getLastModifiedDateTime", "setLastModifiedDateTime", "sn", "Lme/jahnen/libaums/core/fs/fat32/ShortName;", "shortName", "getShortName", "()Lme/jahnen/libaums/core/fs/fat32/ShortName;", "setShortName", "(Lme/jahnen/libaums/core/fs/fat32/ShortName;)V", "newStartCluster", "startCluster", "getStartCluster", "setStartCluster", "volumeLabel", "", "getVolumeLabel", "()Ljava/lang/String;", "extractLfnPart", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getUnsignedInt16", "offset", "getUnsignedInt32", "getUnsignedInt8", "isFlagSet", "flag", "serialize", "buffer", "setDirectory", "setFlag", "setUnsignedInt16", "value", "setUnsignedInt32", "toString", "Companion", "libaums_release"})
public final class FatDirectoryEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ByteBuffer data;
    @Nullable
    private ShortName shortName;
    public static final int SIZE = 32;
    private static final int ATTR_OFF = 11;
    private static final int FILE_SIZE_OFF = 28;
    private static final int MSB_CLUSTER_OFF = 20;
    private static final int LSB_CLUSTER_OFF = 26;
    private static final int CREATED_DATE_OFF = 16;
    private static final int CREATED_TIME_OFF = 14;
    private static final int LAST_WRITE_DATE_OFF = 24;
    private static final int LAST_WRITE_TIME_OFF = 22;
    private static final int LAST_ACCESSED_DATE_OFF = 18;
    private static final int FLAG_READONLY = 1;
    private static final int FLAG_HIDDEN = 2;
    private static final int FLAG_SYSTEM = 4;
    private static final int FLAG_VOLUME_ID = 8;
    private static final int FLAG_DIRECTORY = 16;
    private static final int FLAG_ARCHIVE = 32;
    private static final int SHORTNAME_CASE_OFF = 12;
    public static final int ENTRY_DELETED = 229;

    private FatDirectoryEntry(ByteBuffer data) {
        this.data = data;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.setShortName(ShortName.Companion.parse(this.data));
        this.data.clear();
    }

    /* synthetic */ FatDirectoryEntry(ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(32);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(SIZE)");
            byteBuffer = byteBuffer2;
        }
        this(byteBuffer);
    }

    @Nullable
    public final ShortName getShortName() {
        return this.data.get(0) == 0 ? null : this.shortName;
    }

    public final void setShortName(@Nullable ShortName sn) {
        this.shortName = sn;
        this.data.clear();
        ShortName shortName = this.shortName;
        if (shortName != null) {
            shortName.serialize(this.data);
        }
        this.data.clear();
    }

    private final int getFlags() {
        return this.data.get(11);
    }

    public final boolean isShortNameLowerCase() {
        return (byte)(this.data.get(12) & 8) != 0;
    }

    public final boolean isShortNameExtLowerCase() {
        return (byte)(this.data.get(12) & 0x10) != 0;
    }

    public final boolean isLfnEntry() {
        return this.isHidden() && this.isVolume() && this.isReadOnly() && this.isSystem();
    }

    public final boolean isDirectory() {
        return (this.getFlags() & 0x18) == 16;
    }

    public final boolean isVolumeLabel() {
        return this.isLfnEntry() ? false : (this.getFlags() & 0x18) == 8;
    }

    public final boolean isSystem() {
        return this.isFlagSet(4);
    }

    public final boolean isHidden() {
        return this.isFlagSet(2);
    }

    public final boolean isArchive() {
        return this.isFlagSet(32);
    }

    public final boolean isReadOnly() {
        return this.isFlagSet(1);
    }

    public final boolean isVolume() {
        return this.isFlagSet(8);
    }

    public final boolean isDeleted() {
        return this.getUnsignedInt8(0) == 229;
    }

    public final long getCreatedDateTime() {
        return FatDirectoryEntry.Companion.decodeDateTime(this.getUnsignedInt16(16), this.getUnsignedInt16(14));
    }

    public final void setCreatedDateTime(long dateTime) {
        this.setUnsignedInt16(16, FatDirectoryEntry.Companion.encodeDate(dateTime));
        this.setUnsignedInt16(14, FatDirectoryEntry.Companion.encodeTime(dateTime));
    }

    public final long getLastModifiedDateTime() {
        return FatDirectoryEntry.Companion.decodeDateTime(this.getUnsignedInt16(24), this.getUnsignedInt16(22));
    }

    public final void setLastModifiedDateTime(long dateTime) {
        this.setUnsignedInt16(24, FatDirectoryEntry.Companion.encodeDate(dateTime));
        this.setUnsignedInt16(22, FatDirectoryEntry.Companion.encodeTime(dateTime));
    }

    public final long getLastAccessedDateTime() {
        return FatDirectoryEntry.Companion.decodeDateTime(this.getUnsignedInt16(18), 0);
    }

    public final void setLastAccessedDateTime(long dateTime) {
        this.setUnsignedInt16(18, FatDirectoryEntry.Companion.encodeDate(dateTime));
    }

    @NotNull
    public final String getVolumeLabel() {
        byte b;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 11 && (b = this.data.get(i)) != 0; ++i) {
            builder.append((char)b);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public final long getStartCluster() {
        int msb = this.getUnsignedInt16(20);
        int lsb = this.getUnsignedInt16(26);
        return (long)msb << 16 | (long)lsb;
    }

    public final void setStartCluster(long newStartCluster) {
        this.setUnsignedInt16(20, (int)(newStartCluster >> 16 & 0xFFFFL));
        this.setUnsignedInt16(26, (int)(newStartCluster & 0xFFFFL));
    }

    public final long getFileSize() {
        return this.getUnsignedInt32(28);
    }

    public final void setFileSize(long newSize) {
        this.setUnsignedInt32(28, newSize);
    }

    public FatDirectoryEntry() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(32);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(SIZE)");
        this(byteBuffer);
        long now = System.currentTimeMillis();
        this.setCreatedDateTime(now);
        this.setLastAccessedDateTime(now);
        this.setLastModifiedDateTime(now);
    }

    public final void serialize(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.put(this.data.array());
    }

    private final void setFlag(int flag) {
        int flags = this.getFlags();
        this.data.put(11, (byte)(flag | flags));
    }

    private final boolean isFlagSet(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public final void setDirectory() {
        this.setFlag(16);
    }

    public final void extractLfnPart(@NotNull StringBuilder builder) {
        int len;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        char[] name = new char[]{(char)this.data.getShort(1), (char)this.data.getShort(3), (char)this.data.getShort(5), (char)this.data.getShort(7), (char)this.data.getShort(9), (char)this.data.getShort(14), (char)this.data.getShort(16), (char)this.data.getShort(18), (char)this.data.getShort(20), (char)this.data.getShort(22), (char)this.data.getShort(24), (char)this.data.getShort(28), (char)this.data.getShort(30)};
        for (len = 0; len < 13 && name[len] != '\u0000'; ++len) {
        }
        builder.append(name, 0, len);
    }

    private final int getUnsignedInt8(int offset) {
        return this.data.get(offset) & 0xFF;
    }

    private final int getUnsignedInt16(int offset) {
        int i1 = this.data.get(offset) & 0xFF;
        int i2 = this.data.get(offset + 1) & 0xFF;
        return i2 << 8 | i1;
    }

    private final long getUnsignedInt32(int offset) {
        long i1 = this.data.get(offset) & 0xFF;
        long i2 = this.data.get(offset + 1) & 0xFF;
        long i3 = this.data.get(offset + 2) & 0xFF;
        long i4 = this.data.get(offset + 3) & 0xFF;
        return i4 << 24 | i3 << 16 | i2 << 8 | i1;
    }

    private final void setUnsignedInt16(int offset, int value) {
        this.data.put(offset, (byte)(value & 0xFF));
        this.data.put(offset + 1, (byte)(value >>> 8 & 0xFF));
    }

    private final void setUnsignedInt32(int offset, long value) {
        this.data.put(offset, (byte)(value & 0xFFL));
        this.data.put(offset + 1, (byte)(value >>> 8 & 0xFFL));
        this.data.put(offset + 2, (byte)(value >>> 16 & 0xFFL));
        this.data.put(offset + 3, (byte)(value >>> 24 & 0xFFL));
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[FatDirectoryEntry shortName=");
        ShortName shortName = this.getShortName();
        Intrinsics.checkNotNull((Object)shortName);
        return stringBuilder.append(shortName.getString()).append(']').toString();
    }

    public /* synthetic */ FatDirectoryEntry(ByteBuffer data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0019J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010'\u001a\u00020#H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010*\u001a\u00020+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry$Companion;", "", "()V", "ATTR_OFF", "", "CREATED_DATE_OFF", "CREATED_TIME_OFF", "ENTRY_DELETED", "FILE_SIZE_OFF", "FLAG_ARCHIVE", "FLAG_DIRECTORY", "FLAG_HIDDEN", "FLAG_READONLY", "FLAG_SYSTEM", "FLAG_VOLUME_ID", "LAST_ACCESSED_DATE_OFF", "LAST_WRITE_DATE_OFF", "LAST_WRITE_TIME_OFF", "LSB_CLUSTER_OFF", "MSB_CLUSTER_OFF", "SHORTNAME_CASE_OFF", "SIZE", "createLfnPart", "Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "unicode", "", "offset", "checksum", "", "index", "isLast", "", "createVolumeLabel", "volumeLabel", "decodeDateTime", "", "date", "time", "encodeDate", "timeInMillis", "encodeTime", "read", "data", "Ljava/nio/ByteBuffer;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FatDirectoryEntry read(@NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            byte[] buffer = new byte[32];
            if (data.get(data.position()) == 0) {
                return null;
            }
            data.get(buffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(buffer)");
            return new FatDirectoryEntry(byteBuffer, null);
        }

        @NotNull
        public final FatDirectoryEntry createVolumeLabel(@NotNull String volumeLabel) {
            Intrinsics.checkNotNullParameter((Object)volumeLabel, (String)"volumeLabel");
            FatDirectoryEntry result = new FatDirectoryEntry();
            ByteBuffer buffer = ByteBuffer.allocate(32);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            String string = volumeLabel;
            Charset charset = Charset.forName("ASCII");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"ASCII\")");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            System.arraycopy(byArray, 0, buffer.array(), 0, volumeLabel.length());
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            result.data = buffer;
            result.setFlag(8);
            return result;
        }

        @NotNull
        public final FatDirectoryEntry createLfnPart(@NotNull String unicode, int offset, byte checksum, int index, boolean isLast) {
            int diff;
            Intrinsics.checkNotNullParameter((Object)unicode, (String)"unicode");
            String unicode2 = unicode;
            int offset2 = offset;
            FatDirectoryEntry result = new FatDirectoryEntry();
            if (isLast && (diff = unicode2.length() - offset2) < 13) {
                StringBuilder builder = new StringBuilder(13);
                builder.append(unicode2, offset2, unicode2.length());
                builder.append('\u0000');
                int n = 13 - diff;
                for (int i = 0; i < n; ++i) {
                    builder.append('\uffff');
                }
                offset2 = 0;
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                unicode2 = string;
            }
            ByteBuffer buffer = ByteBuffer.allocate(32);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.put(0, (byte)(isLast ? index + 64 : index));
            buffer.putShort(1, (short)unicode2.charAt(offset2));
            buffer.putShort(3, (short)unicode2.charAt(offset2 + 1));
            buffer.putShort(5, (short)unicode2.charAt(offset2 + 2));
            buffer.putShort(7, (short)unicode2.charAt(offset2 + 3));
            buffer.putShort(9, (short)unicode2.charAt(offset2 + 4));
            buffer.put(11, (byte)15);
            buffer.put(12, (byte)0);
            buffer.put(13, checksum);
            buffer.putShort(14, (short)unicode2.charAt(offset2 + 5));
            buffer.putShort(16, (short)unicode2.charAt(offset2 + 6));
            buffer.putShort(18, (short)unicode2.charAt(offset2 + 7));
            buffer.putShort(20, (short)unicode2.charAt(offset2 + 8));
            buffer.putShort(22, (short)unicode2.charAt(offset2 + 9));
            buffer.putShort(24, (short)unicode2.charAt(offset2 + 10));
            buffer.putShort(26, (short)0);
            buffer.putShort(28, (short)unicode2.charAt(offset2 + 11));
            buffer.putShort(30, (short)unicode2.charAt(offset2 + 12));
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            result.data = buffer;
            return result;
        }

        private final long decodeDateTime(int date, int time) {
            Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
            calendar.set(1, 1980 + (date >> 9));
            calendar.set(2, (date >> 5 & 0xF) - 1);
            calendar.set(5, date & 0x1F);
            calendar.set(11, time >> 11);
            calendar.set(12, time >> 5 & 0x3F);
            calendar.set(13, (time & 0x1F) * 2);
            return calendar.getTimeInMillis();
        }

        private final int encodeDate(long timeInMillis) {
            Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
            calendar.setTimeInMillis(timeInMillis);
            return (calendar.get(1) - 1980 << 9) + (calendar.get(2) + 1 << 5) + calendar.get(5);
        }

        private final int encodeTime(long timeInMillis) {
            Calendar calendar = Calendar.getInstance(FileSystemFactory.getTimeZone());
            calendar.setTimeInMillis(timeInMillis);
            return (calendar.get(11) << 11) + (calendar.get(12) << 5) + calendar.get(13) / 2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

