/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.AbstractUsbFile;
import me.jahnen.libaums.core.fs.UsbFile;
import me.jahnen.libaums.core.fs.fat32.ClusterChain;
import me.jahnen.libaums.core.fs.fat32.FAT;
import me.jahnen.libaums.core.fs.fat32.Fat32BootSector;
import me.jahnen.libaums.core.fs.fat32.Fat32FileSystem;
import me.jahnen.libaums.core.fs.fat32.FatDirectoryEntry;
import me.jahnen.libaums.core.fs.fat32.FatFile;
import me.jahnen.libaums.core.fs.fat32.FatLfnDirectoryEntry;
import me.jahnen.libaums.core.fs.fat32.ShortName;
import me.jahnen.libaums.core.fs.fat32.ShortNameGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 S2\u00020\u0001:\u0001SB;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020-H\u0002J\b\u00104\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020 H\u0016J\u0010\u00106\u001a\u0002072\u0006\u0010\"\u001a\u00020 H\u0016J\b\u00108\u001a\u00020\u0018H\u0016J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000202H\u0016J\b\u0010;\u001a\u000202H\u0002J\b\u0010<\u001a\u00020\u0018H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J\u0013\u0010>\u001a\b\u0012\u0004\u0012\u00020 0?H\u0016\u00a2\u0006\u0002\u0010@J\u0013\u0010A\u001a\b\u0012\u0004\u0012\u00020B0?H\u0016\u00a2\u0006\u0002\u0010CJ\u001d\u0010D\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020BH\u0000\u00a2\u0006\u0002\bFJ\u0010\u0010G\u001a\u0002022\u0006\u0010E\u001a\u00020BH\u0016J\u0018\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020\u00182\u0006\u0010E\u001a\u00020JH\u0016J\b\u0010K\u001a\u000202H\u0002J\u0017\u0010L\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\bMJ\u001f\u0010N\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020 H\u0000\u00a2\u0006\u0002\bOJ\r\u0010P\u001a\u000202H\u0000\u00a2\u0006\u0002\bQJ\u0018\u0010P\u001a\u0002022\u0006\u0010I\u001a\u00020\u00182\u0006\u0010R\u001a\u00020JH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0004\u0018\u00010 2\b\u0010.\u001a\u0004\u0018\u00010 @BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010$\u00a8\u0006T"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "Lme/jahnen/libaums/core/fs/AbstractUsbFile;", "fs", "Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "fat", "Lme/jahnen/libaums/core/fs/fat32/FAT;", "bootSector", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "entry", "Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;", "parent", "(Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem;Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Lme/jahnen/libaums/core/fs/fat32/FAT;Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;Lme/jahnen/libaums/core/fs/fat32/FatLfnDirectoryEntry;Lme/jahnen/libaums/core/fs/fat32/FatDirectory;)V", "chain", "Lme/jahnen/libaums/core/fs/fat32/ClusterChain;", "entries", "", "hasBeenInited", "", "isDirectory", "()Z", "isRoot", "<anonymous parameter 0>", "", "length", "getLength", "()J", "setLength", "(J)V", "lfnMap", "", "", "newName", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getParent", "()Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "setParent", "(Lme/jahnen/libaums/core/fs/fat32/FatDirectory;)V", "shortNameMap", "Lme/jahnen/libaums/core/fs/fat32/ShortName;", "Lme/jahnen/libaums/core/fs/fat32/FatDirectoryEntry;", "<set-?>", "volumeLabel", "getVolumeLabel$libaums_release", "addEntry", "", "lfnEntry", "close", "createDirectory", "createFile", "Lme/jahnen/libaums/core/fs/fat32/FatFile;", "createdAt", "delete", "flush", "init", "lastAccessed", "lastModified", "list", "", "()[Ljava/lang/String;", "listFiles", "Lme/jahnen/libaums/core/fs/UsbFile;", "()[Lme/jahnen/libaums/core/fs/UsbFile;", "move", "destination", "move$libaums_release", "moveTo", "read", "offset", "Ljava/nio/ByteBuffer;", "readEntries", "removeEntry", "removeEntry$libaums_release", "renameEntry", "renameEntry$libaums_release", "write", "write$libaums_release", "source", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nFatDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FatDirectory.kt\nme/jahnen/libaums/core/fs/fat32/FatDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,561:1\n1#2:562\n37#3,2:563\n37#3,2:565\n*S KotlinDebug\n*F\n+ 1 FatDirectory.kt\nme/jahnen/libaums/core/fs/fat32/FatDirectory\n*L\n400#1:563,2\n428#1:565,2\n*E\n"})
public final class FatDirectory
extends AbstractUsbFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fat32FileSystem fs;
    @NotNull
    private final BlockDeviceDriver blockDevice;
    @NotNull
    private final FAT fat;
    @NotNull
    private final Fat32BootSector bootSector;
    @Nullable
    private FatLfnDirectoryEntry entry;
    @Nullable
    private FatDirectory parent;
    private ClusterChain chain;
    @Nullable
    private List<FatLfnDirectoryEntry> entries;
    @NotNull
    private final Map<String, FatLfnDirectoryEntry> lfnMap;
    @NotNull
    private final Map<ShortName, FatDirectoryEntry> shortNameMap;
    @Nullable
    private String volumeLabel;
    private boolean hasBeenInited;
    private static final String TAG = FatDirectory.class.getSimpleName();

    public FatDirectory(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector, @Nullable FatLfnDirectoryEntry entry, @Nullable FatDirectory parent) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkNotNullParameter((Object)fat, (String)"fat");
        Intrinsics.checkNotNullParameter((Object)bootSector, (String)"bootSector");
        this.fs = fs;
        this.blockDevice = blockDevice;
        this.fat = fat;
        this.bootSector = bootSector;
        this.entry = entry;
        this.parent = parent;
        this.lfnMap = new HashMap();
        this.shortNameMap = new HashMap();
    }

    @Override
    @Nullable
    public FatDirectory getParent() {
        return this.parent;
    }

    public void setParent(@Nullable FatDirectory fatDirectory) {
        this.parent = fatDirectory;
    }

    @Nullable
    public final String getVolumeLabel$libaums_release() {
        return this.volumeLabel;
    }

    @Override
    public boolean isRoot() {
        return this.entry == null;
    }

    @Override
    public long getLength() {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void setLength(long l) {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        if (this.entry != null) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
            string = fatLfnDirectoryEntry.getName$libaums_release();
        } else {
            string = "/";
        }
        return string;
    }

    @Override
    public void setName(@NotNull String newName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "Cannot rename root dir!";
            throw new IllegalStateException(string.toString());
        }
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.renameEntry$libaums_release(this.entry, newName);
    }

    private final void init() throws IOException {
        if (this.chain == null) {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
            this.chain = new ClusterChain(fatLfnDirectoryEntry.getStartCluster(), this.blockDevice, this.fat, this.bootSector);
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        if (list.size() == 0 && !this.hasBeenInited) {
            this.readEntries();
        }
        this.hasBeenInited = true;
    }

    private final void readEntries() throws IOException {
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)clusterChain.getLength$libaums_release());
        ClusterChain clusterChain2 = this.chain;
        if (clusterChain2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain2 = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        clusterChain2.read$libaums_release(0L, buffer);
        ArrayList<FatDirectoryEntry> list = new ArrayList<FatDirectoryEntry>();
        buffer.flip();
        while (buffer.remaining() > 0 && FatDirectoryEntry.Companion.read(buffer) != null) {
            FatDirectoryEntry e;
            if (e.isLfnEntry()) {
                list.add(e);
                continue;
            }
            if (e.isVolumeLabel()) {
                if (!this.isRoot()) {
                    Log.w((String)TAG, (String)"volume label in non root dir!");
                }
                this.volumeLabel = e.getVolumeLabel();
                StringBuilder stringBuilder = new StringBuilder().append("volume label: ");
                String string = this.volumeLabel;
                Intrinsics.checkNotNull((Object)string);
                Log.d((String)TAG, (String)stringBuilder.append(string).toString());
                continue;
            }
            if (e.isDeleted()) {
                list.clear();
                continue;
            }
            FatLfnDirectoryEntry lfnEntry = FatLfnDirectoryEntry.Companion.read(e, (List<FatDirectoryEntry>)list);
            this.addEntry(lfnEntry, e);
            list.clear();
        }
    }

    private final void addEntry(FatLfnDirectoryEntry lfnEntry, FatDirectoryEntry entry) {
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        list.add(lfnEntry);
        Map<String, FatLfnDirectoryEntry> map = this.lfnMap;
        String string = lfnEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        string = string2;
        map.put(string, lfnEntry);
        ShortName shortName = entry.getShortName();
        Intrinsics.checkNotNull((Object)shortName);
        this.shortNameMap.put(shortName, entry);
    }

    public final void removeEntry$libaums_release(@Nullable FatLfnDirectoryEntry lfnEntry) {
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        TypeIntrinsics.asMutableCollection((Object)list).remove(lfnEntry);
        FatLfnDirectoryEntry fatLfnDirectoryEntry = lfnEntry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        Object object = fatLfnDirectoryEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        this.lfnMap.remove(string);
        object = this.shortNameMap;
        ShortName shortName = lfnEntry.getActualEntry().getShortName();
        TypeIntrinsics.asMutableMap((Object)object).remove(shortName);
    }

    public final void renameEntry$libaums_release(@Nullable FatLfnDirectoryEntry lfnEntry, @NotNull String newName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        FatLfnDirectoryEntry fatLfnDirectoryEntry = lfnEntry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        if (Intrinsics.areEqual((Object)fatLfnDirectoryEntry.getName$libaums_release(), (Object)newName)) {
            return;
        }
        this.removeEntry$libaums_release(lfnEntry);
        lfnEntry.setName(newName, ShortNameGenerator.INSTANCE.generateShortName(newName, (Collection<ShortName>)this.shortNameMap.keySet()));
        this.addEntry(lfnEntry, lfnEntry.getActualEntry());
        this.write$libaums_release();
    }

    public final void write$libaums_release() throws IOException {
        this.init();
        boolean writeVolumeLabel = this.isRoot() && this.volumeLabel != null;
        int totalEntryCount = 0;
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        for (FatLfnDirectoryEntry entry : list) {
            totalEntryCount += entry.getEntryCount();
        }
        if (writeVolumeLabel) {
            ++totalEntryCount;
        }
        long totalBytes = totalEntryCount * 32;
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.setLength$libaums_release(totalBytes);
        ClusterChain clusterChain2 = this.chain;
        if (clusterChain2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain2 = null;
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)clusterChain2.getLength$libaums_release());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (writeVolumeLabel) {
            String string = this.volumeLabel;
            Intrinsics.checkNotNull((Object)string);
            FatDirectoryEntry fatDirectoryEntry = FatDirectoryEntry.Companion.createVolumeLabel(string);
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            fatDirectoryEntry.serialize(buffer);
        }
        List<FatLfnDirectoryEntry> list2 = this.entries;
        Intrinsics.checkNotNull(list2);
        for (FatLfnDirectoryEntry entry : list2) {
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            entry.serialize(buffer);
        }
        if (totalBytes % (long)this.bootSector.getBytesPerCluster() != 0L || totalBytes == 0L) {
            buffer.put(new byte[buffer.remaining()]);
        }
        buffer.flip();
        ClusterChain clusterChain3 = this.chain;
        if (clusterChain3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain3 = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        clusterChain3.write$libaums_release(0L, buffer);
    }

    @Override
    @NotNull
    public FatFile createFile(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        if (this.lfnMap.containsKey(string2)) {
            throw new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.INSTANCE.generateShortName(name, (Collection<ShortName>)this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = new FatLfnDirectoryEntry(name, shortName);
        long newStartCluster = this.fat.alloc$libaums_release(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        FatFile file = new FatFile(this.blockDevice, this.fat, this.bootSector, entry, this);
        ((Map)this.fs.getFileCache$libaums_release()).put(file.getAbsolutePath(), file);
        return file;
    }

    @Override
    @NotNull
    public FatDirectory createDirectory(@NotNull String name) throws IOException {
        long l;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        if (this.lfnMap.containsKey(string2)) {
            throw new IOException("Item already exists!");
        }
        this.init();
        ShortName shortName = ShortNameGenerator.INSTANCE.generateShortName(name, (Collection<ShortName>)this.shortNameMap.keySet());
        FatLfnDirectoryEntry entry = new FatLfnDirectoryEntry(name, shortName);
        entry.setDirectory();
        long newStartCluster = this.fat.alloc$libaums_release(new Long[0], 1)[0];
        entry.setStartCluster(newStartCluster);
        Log.d((String)TAG, (String)("adding entry: " + entry + " with short name: " + shortName));
        this.addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        FatDirectory result = new FatDirectory(this.fs, this.blockDevice, this.fat, this.bootSector, entry, this);
        result.hasBeenInited = true;
        result.entries = new ArrayList();
        FatLfnDirectoryEntry dotEntry = new FatLfnDirectoryEntry(null, new ShortName(".", ""));
        dotEntry.setDirectory();
        dotEntry.setStartCluster(newStartCluster);
        FatLfnDirectoryEntry.Companion.copyDateTime(entry, dotEntry);
        result.addEntry(dotEntry, dotEntry.getActualEntry());
        FatLfnDirectoryEntry dotDotEntry = new FatLfnDirectoryEntry(null, new ShortName("..", ""));
        dotDotEntry.setDirectory();
        if (this.isRoot()) {
            l = 0L;
        } else {
            FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
            Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
            l = fatLfnDirectoryEntry.getStartCluster();
        }
        dotDotEntry.setStartCluster(l);
        FatLfnDirectoryEntry.Companion.copyDateTime(entry, dotDotEntry);
        result.addEntry(dotDotEntry, dotDotEntry.getActualEntry());
        result.write$libaums_release();
        ((Map)this.fs.getFileCache$libaums_release()).put(result.getAbsolutePath(), result);
        return result;
    }

    @Override
    public long createdAt() {
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root dir!";
            throw new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        return fatLfnDirectoryEntry.getActualEntry().getCreatedDateTime();
    }

    @Override
    public long lastModified() {
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root dir!";
            throw new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        return fatLfnDirectoryEntry.getActualEntry().getLastModifiedDateTime();
    }

    @Override
    public long lastAccessed() {
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root dir!";
            throw new IllegalStateException(string.toString());
        }
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        return fatLfnDirectoryEntry.getActualEntry().getLastAccessedDateTime();
    }

    @Override
    @NotNull
    public String[] list() throws IOException {
        this.init();
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        ArrayList<String> list2 = new ArrayList<String>(list.size());
        List<FatLfnDirectoryEntry> list3 = this.entries;
        Intrinsics.checkNotNull(list3);
        for (FatLfnDirectoryEntry entry : list3) {
            String name = entry.getName$libaums_release();
            if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) continue;
            list2.add(name);
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public UsbFile[] listFiles() throws IOException {
        this.init();
        List<FatLfnDirectoryEntry> list = this.entries;
        Intrinsics.checkNotNull(list);
        ArrayList<UsbFile> list2 = new ArrayList<UsbFile>(list.size());
        List<FatLfnDirectoryEntry> list3 = this.entries;
        Intrinsics.checkNotNull(list3);
        for (FatLfnDirectoryEntry entry : list3) {
            UsbFile usbFile;
            String name = entry.getName$libaums_release();
            if (Intrinsics.areEqual((Object)name, (Object)".") || Intrinsics.areEqual((Object)name, (Object)"..")) continue;
            String entryAbsolutePath = this.isRoot() ? '/' + entry.getName$libaums_release() : this.getAbsolutePath() + '/' + entry.getName$libaums_release();
            if (this.fs.getFileCache$libaums_release().get(entryAbsolutePath) != null) {
                UsbFile usbFile2 = this.fs.getFileCache$libaums_release().get(entryAbsolutePath);
                Intrinsics.checkNotNull((Object)usbFile2);
                usbFile = usbFile2;
            } else {
                usbFile = entry.isDirectory() ? (UsbFile)new FatDirectory(this.fs, this.blockDevice, this.fat, this.bootSector, entry, this) : (UsbFile)new FatFile(this.blockDevice, this.fat, this.bootSector, entry, this);
            }
            Intrinsics.checkNotNullExpressionValue((Object)usbFile, (String)"when {\n                f\u2026ntry, this)\n            }");
            UsbFile file = usbFile;
            ((Map)this.fs.getFileCache$libaums_release()).put(entryAbsolutePath, file);
            list2.add(file);
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new UsbFile[0]);
    }

    @Override
    public void read(long offset, @NotNull ByteBuffer destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void write(long offset, @NotNull ByteBuffer source) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("This is a directory!");
    }

    @Override
    public void moveTo(@NotNull UsbFile destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!(!this.isRoot())) {
            boolean $i$a$-check-FatDirectory$moveTo$42 = false;
            String $i$a$-check-FatDirectory$moveTo$42 = "cannot move root dir!";
            throw new IllegalStateException($i$a$-check-FatDirectory$moveTo$42.toString());
        }
        if (!destination.isDirectory()) {
            boolean $i$a$-check-FatDirectory$moveTo$52 = false;
            String $i$a$-check-FatDirectory$moveTo$52 = "destination cannot be a file!";
            throw new IllegalStateException($i$a$-check-FatDirectory$moveTo$52.toString());
        }
        if (!(destination instanceof FatDirectory)) {
            boolean bl = false;
            String string = "cannot move between different filesystems!";
            throw new IllegalStateException(string.toString());
        }
        Map<String, FatLfnDirectoryEntry> map = ((FatDirectory)destination).lfnMap;
        FatLfnDirectoryEntry fatLfnDirectoryEntry = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry);
        String string = fatLfnDirectoryEntry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        if (map.containsKey(string2)) {
            throw new IOException("item already exists in destination!");
        }
        this.init();
        ((FatDirectory)destination).init();
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.removeEntry$libaums_release(this.entry);
        FatDirectory fatDirectory2 = (FatDirectory)destination;
        FatLfnDirectoryEntry fatLfnDirectoryEntry2 = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry2);
        FatLfnDirectoryEntry fatLfnDirectoryEntry3 = this.entry;
        Intrinsics.checkNotNull((Object)fatLfnDirectoryEntry3);
        fatDirectory2.addEntry(fatLfnDirectoryEntry2, fatLfnDirectoryEntry3.getActualEntry());
        FatDirectory fatDirectory3 = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory3);
        fatDirectory3.write$libaums_release();
        ((FatDirectory)destination).write$libaums_release();
        this.setParent((FatDirectory)destination);
    }

    public final void move$libaums_release(@NotNull FatLfnDirectoryEntry entry, @NotNull UsbFile destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (!destination.isDirectory()) {
            boolean $i$a$-check-FatDirectory$move$32 = false;
            String $i$a$-check-FatDirectory$move$32 = "destination cannot be a file!";
            throw new IllegalStateException($i$a$-check-FatDirectory$move$32.toString());
        }
        if (!(destination instanceof FatDirectory)) {
            boolean bl = false;
            String string = "cannot move between different filesystems!";
            throw new IllegalStateException(string.toString());
        }
        Map<String, FatLfnDirectoryEntry> map = ((FatDirectory)destination).lfnMap;
        String string = entry.getName$libaums_release();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        if (map.containsKey(string2)) {
            throw new IOException("item already exists in destination!");
        }
        this.init();
        ((FatDirectory)destination).init();
        this.removeEntry$libaums_release(entry);
        ((FatDirectory)destination).addEntry(entry, entry.getActualEntry());
        this.write$libaums_release();
        ((FatDirectory)destination).write$libaums_release();
    }

    @Override
    public void delete() throws IOException {
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "Root dir cannot be deleted!";
            throw new IllegalStateException(string.toString());
        }
        this.init();
        for (UsbFile file : this.listFiles()) {
            file.delete();
        }
        FatDirectory fatDirectory = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory);
        fatDirectory.removeEntry$libaums_release(this.entry);
        FatDirectory fatDirectory2 = this.getParent();
        Intrinsics.checkNotNull((Object)fatDirectory2);
        fatDirectory2.write$libaums_release();
        ClusterChain clusterChain = this.chain;
        if (clusterChain == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chain");
            clusterChain = null;
        }
        clusterChain.setLength$libaums_release(0L);
    }

    @JvmStatic
    @NotNull
    public static final FatDirectory readRoot$libaums_release(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector) throws IOException {
        return Companion.readRoot$libaums_release(fs, blockDevice, fat, bootSector);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001\u00a2\u0006\u0002\b\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FatDirectory$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "readRoot", "Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "fs", "Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "fat", "Lme/jahnen/libaums/core/fs/fat32/FAT;", "bootSector", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "readRoot$libaums_release", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FatDirectory readRoot$libaums_release(@NotNull Fat32FileSystem fs, @NotNull BlockDeviceDriver blockDevice, @NotNull FAT fat, @NotNull Fat32BootSector bootSector) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
            Intrinsics.checkNotNullParameter((Object)fat, (String)"fat");
            Intrinsics.checkNotNullParameter((Object)bootSector, (String)"bootSector");
            FatDirectory result = new FatDirectory(fs, blockDevice, fat, bootSector, null, null);
            result.chain = new ClusterChain(bootSector.getRootDirStartCluster(), blockDevice, fat, bootSector);
            result.init();
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

