/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.FileSystem;
import me.jahnen.libaums.core.fs.UsbFile;
import me.jahnen.libaums.core.fs.fat32.FAT;
import me.jahnen.libaums.core.fs.fat32.Fat32BootSector;
import me.jahnen.libaums.core.fs.fat32.FatDirectory;
import me.jahnen.libaums.core.fs.fat32.FsInfoStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u0014\u0010%\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem;", "Lme/jahnen/libaums/core/fs/FileSystem;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "first512Bytes", "Ljava/nio/ByteBuffer;", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Ljava/nio/ByteBuffer;)V", "bootSector", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "capacity", "", "getCapacity", "()J", "chunkSize", "", "getChunkSize", "()I", "fat", "Lme/jahnen/libaums/core/fs/fat32/FAT;", "fileCache", "Ljava/util/WeakHashMap;", "", "Lme/jahnen/libaums/core/fs/UsbFile;", "getFileCache$libaums_release", "()Ljava/util/WeakHashMap;", "freeSpace", "getFreeSpace", "fsInfoStructure", "Lme/jahnen/libaums/core/fs/fat32/FsInfoStructure;", "occupiedSpace", "getOccupiedSpace", "rootDirectory", "Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "getRootDirectory", "()Lme/jahnen/libaums/core/fs/fat32/FatDirectory;", "type", "getType", "volumeLabel", "getVolumeLabel", "()Ljava/lang/String;", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nFat32FileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fat32FileSystem.kt\nme/jahnen/libaums/core/fs/fat32/Fat32FileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
public final class Fat32FileSystem
implements FileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fat32BootSector bootSector;
    @NotNull
    private final FAT fat;
    @NotNull
    private final FsInfoStructure fsInfoStructure;
    @NotNull
    private final FatDirectory rootDirectory;
    @NotNull
    private final WeakHashMap<String, UsbFile> fileCache;
    private static final String TAG = Fat32FileSystem.class.getSimpleName();

    private Fat32FileSystem(BlockDeviceDriver blockDevice, ByteBuffer first512Bytes) throws IOException {
        this.bootSector = Fat32BootSector.Companion.read(first512Bytes);
        this.fileCache = new WeakHashMap();
        this.fsInfoStructure = FsInfoStructure.Companion.read(blockDevice, this.bootSector.getFsInfoStartSector() * this.bootSector.getBytesPerSector());
        this.fat = new FAT(blockDevice, this.bootSector, this.fsInfoStructure);
        this.rootDirectory = FatDirectory.Companion.readRoot$libaums_release(this, blockDevice, this.fat, this.bootSector);
        Log.d((String)TAG, (String)this.bootSector.toString());
    }

    @Override
    @NotNull
    public FatDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public final WeakHashMap<String, UsbFile> getFileCache$libaums_release() {
        return this.fileCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getVolumeLabel() {
        String string;
        String string2;
        String string3 = this.getRootDirectory().getVolumeLabel$libaums_release();
        if (string3 != null) {
            void var1_1;
            String it = string3;
            boolean bl = false;
            string2 = var1_1;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    @Override
    public long getCapacity() {
        return this.bootSector.getTotalNumberOfSectors() * (long)this.bootSector.getBytesPerSector();
    }

    @Override
    public long getOccupiedSpace() {
        return this.getCapacity() - this.getFreeSpace();
    }

    @Override
    public long getFreeSpace() {
        return this.fsInfoStructure.getFreeClusterCount() * (long)this.bootSector.getBytesPerCluster();
    }

    @Override
    public int getChunkSize() {
        return this.bootSector.getBytesPerCluster();
    }

    @Override
    public int getType() {
        return 2;
    }

    @JvmStatic
    @Nullable
    public static final Fat32FileSystem read(@NotNull BlockDeviceDriver blockDevice) throws IOException {
        return Companion.read(blockDevice);
    }

    public /* synthetic */ Fat32FileSystem(BlockDeviceDriver blockDevice, ByteBuffer first512Bytes, DefaultConstructorMarker $constructor_marker) {
        this(blockDevice, first512Bytes);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "read", "Lme/jahnen/libaums/core/fs/fat32/Fat32FileSystem;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Fat32FileSystem read(@NotNull BlockDeviceDriver blockDevice) throws IOException {
            Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
            ByteBuffer buffer = ByteBuffer.allocate(512);
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            blockDevice.read(0L, buffer);
            buffer.flip();
            return (char)buffer.get(82) != 'F' || (char)buffer.get(83) != 'A' || (char)buffer.get(84) != 'T' || (char)buffer.get(85) != '3' || (char)buffer.get(86) != '2' || (char)buffer.get(87) != ' ' || (char)buffer.get(88) != ' ' || (char)buffer.get(89) != ' ' ? null : new Fat32FileSystem(blockDevice, buffer, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

