/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000bR\u001e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u001e\u0010!\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR\u001e\u0010#\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006-"}, d2={"Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "", "()V", "bytesPerCluster", "", "getBytesPerCluster", "()I", "<set-?>", "", "bytesPerSector", "getBytesPerSector", "()S", "dataAreaOffset", "", "getDataAreaOffset", "()J", "", "fatCount", "getFatCount", "()B", "fsInfoStartSector", "getFsInfoStartSector", "", "isFatMirrored", "()Z", "reservedSectors", "getReservedSectors", "rootDirStartCluster", "getRootDirStartCluster", "sectorsPerCluster", "getSectorsPerCluster", "sectorsPerFat", "getSectorsPerFat", "totalNumberOfSectors", "getTotalNumberOfSectors", "validFat", "getValidFat", "", "volumeLabel", "getVolumeLabel", "()Ljava/lang/String;", "getFatOffset", "fatNumber", "toString", "Companion", "libaums_release"})
public final class Fat32BootSector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private short bytesPerSector;
    private short sectorsPerCluster;
    private short reservedSectors;
    private byte fatCount;
    private long totalNumberOfSectors;
    private long sectorsPerFat;
    private long rootDirStartCluster;
    private short fsInfoStartSector;
    private boolean isFatMirrored;
    private byte validFat;
    @Nullable
    private String volumeLabel;
    private static final int BYTES_PER_SECTOR_OFF = 11;
    private static final int SECTORS_PER_CLUSTER_OFF = 13;
    private static final int RESERVED_COUNT_OFF = 14;
    private static final int FAT_COUNT_OFF = 16;
    private static final int TOTAL_SECTORS_OFF = 32;
    private static final int SECTORS_PER_FAT_OFF = 36;
    private static final int FLAGS_OFF = 40;
    private static final int ROOT_DIR_CLUSTER_OFF = 44;
    private static final int FS_INFO_SECTOR_OFF = 48;
    private static final int VOLUME_LABEL_OFF = 48;

    private Fat32BootSector() {
    }

    public final short getBytesPerSector() {
        return this.bytesPerSector;
    }

    public final short getSectorsPerCluster() {
        return this.sectorsPerCluster;
    }

    public final short getReservedSectors() {
        return this.reservedSectors;
    }

    public final byte getFatCount() {
        return this.fatCount;
    }

    public final long getTotalNumberOfSectors() {
        return this.totalNumberOfSectors;
    }

    public final long getSectorsPerFat() {
        return this.sectorsPerFat;
    }

    public final long getRootDirStartCluster() {
        return this.rootDirStartCluster;
    }

    public final short getFsInfoStartSector() {
        return this.fsInfoStartSector;
    }

    public final boolean isFatMirrored() {
        return this.isFatMirrored;
    }

    public final byte getValidFat() {
        return this.validFat;
    }

    @Nullable
    public final String getVolumeLabel() {
        return this.volumeLabel;
    }

    public final int getBytesPerCluster() {
        return this.sectorsPerCluster * this.bytesPerSector;
    }

    public final long getDataAreaOffset() {
        return this.getFatOffset(0) + (long)this.fatCount * this.sectorsPerFat * (long)this.bytesPerSector;
    }

    public final long getFatOffset(int fatNumber) {
        return (long)this.bytesPerSector * ((long)this.reservedSectors + (long)fatNumber * this.sectorsPerFat);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fat32BootSector{bytesPerSector=").append(this.bytesPerSector).append(", sectorsPerCluster=").append(this.sectorsPerCluster).append(", reservedSectors=").append(this.reservedSectors).append(", fatCount=").append(this.fatCount).append(", totalNumberOfSectors=").append(this.totalNumberOfSectors).append(", sectorsPerFat=").append(this.sectorsPerFat).append(", rootDirStartCluster=").append(this.rootDirStartCluster).append(", fsInfoStartSector=").append(this.fsInfoStartSector).append(", fatMirrored=").append(this.isFatMirrored).append(", validFat=").append(this.validFat).append(", volumeLabel='").append(this.volumeLabel).append("'}");
        return stringBuilder.toString();
    }

    @JvmStatic
    @NotNull
    public static final Fat32BootSector read(@NotNull ByteBuffer buffer) {
        return Companion.read(buffer);
    }

    public /* synthetic */ Fat32BootSector(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector$Companion;", "", "()V", "BYTES_PER_SECTOR_OFF", "", "FAT_COUNT_OFF", "FLAGS_OFF", "FS_INFO_SECTOR_OFF", "RESERVED_COUNT_OFF", "ROOT_DIR_CLUSTER_OFF", "SECTORS_PER_CLUSTER_OFF", "SECTORS_PER_FAT_OFF", "TOTAL_SECTORS_OFF", "VOLUME_LABEL_OFF", "read", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "buffer", "Ljava/nio/ByteBuffer;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Fat32BootSector read(@NotNull ByteBuffer buffer) {
            byte b;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Fat32BootSector result = new Fat32BootSector(null);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            result.bytesPerSector = buffer.getShort(11);
            result.sectorsPerCluster = (short)(buffer.get(13) & 0xFF);
            result.reservedSectors = buffer.getShort(14);
            result.fatCount = buffer.get(16);
            result.totalNumberOfSectors = (long)buffer.getInt(32) & 0xFFFFFFFFL;
            result.sectorsPerFat = (long)buffer.getInt(36) & 0xFFFFFFFFL;
            result.rootDirStartCluster = (long)buffer.getInt(44) & 0xFFFFFFFFL;
            result.fsInfoStartSector = buffer.getShort(48);
            short flag = buffer.getShort(40);
            result.isFatMirrored = (flag & 0x80) == 0;
            result.validFat = (byte)(flag & 7);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < 11 && (b = buffer.get(48 + i)) != 0; ++i) {
                builder.append((char)b);
            }
            result.volumeLabel = builder.toString();
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

