/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs.fat32;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.fat32.Fat32BootSector;
import me.jahnen.libaums.core.fs.fat32.FsInfoStructure;
import me.jahnen.libaums.core.util.LRUCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FAT;", "", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "bootSector", "Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;", "fsInfoStructure", "Lme/jahnen/libaums/core/fs/fat32/FsInfoStructure;", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;Lme/jahnen/libaums/core/fs/fat32/Fat32BootSector;Lme/jahnen/libaums/core/fs/fat32/FsInfoStructure;)V", "cache", "Lme/jahnen/libaums/core/util/LRUCache;", "", "", "fatNumbers", "", "fatOffset", "", "alloc", "chain", "numberOfClusters", "", "alloc$libaums_release", "([Ljava/lang/Long;I)[Ljava/lang/Long;", "free", "free$libaums_release", "getChain", "startCluster", "getChain$libaums_release", "(J)[Ljava/lang/Long;", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nFAT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FAT.kt\nme/jahnen/libaums/core/fs/fat32/FAT\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n37#2,2:388\n37#2,2:390\n1#3:392\n*S KotlinDebug\n*F\n+ 1 FAT.kt\nme/jahnen/libaums/core/fs/fat32/FAT\n*L\n135#1:388,2\n268#1:390,2\n*E\n"})
public final class FAT {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockDeviceDriver blockDevice;
    @NotNull
    private final FsInfoStructure fsInfoStructure;
    @NotNull
    private final long[] fatOffset;
    @NotNull
    private int[] fatNumbers;
    @NotNull
    private final LRUCache<Long, Long[]> cache;
    private static final String TAG = FAT.class.getSimpleName();
    private static final int FAT32_EOF_CLUSTER = 0xFFFFFF8;

    public FAT(@NotNull BlockDeviceDriver blockDevice, @NotNull Fat32BootSector bootSector, @NotNull FsInfoStructure fsInfoStructure) {
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkNotNullParameter((Object)bootSector, (String)"bootSector");
        Intrinsics.checkNotNullParameter((Object)fsInfoStructure, (String)"fsInfoStructure");
        this.blockDevice = blockDevice;
        this.fsInfoStructure = fsInfoStructure;
        this.cache = new LRUCache(64);
        if (!bootSector.isFatMirrored()) {
            byte fatNumber = bootSector.getValidFat();
            int[] nArray = new int[]{fatNumber};
            this.fatNumbers = nArray;
            Log.i((String)TAG, (String)("fat is not mirrored, fat " + fatNumber + " is valid"));
        } else {
            int fatCount = bootSector.getFatCount();
            this.fatNumbers = new int[fatCount];
            for (int i = 0; i < fatCount; ++i) {
                this.fatNumbers[i] = i;
            }
            Log.i((String)TAG, (String)("fat is mirrored, fat count: " + fatCount));
        }
        this.fatOffset = new long[this.fatNumbers.length];
        int n = this.fatOffset.length;
        for (int i = 0; i < n; ++i) {
            this.fatOffset[i] = bootSector.getFatOffset(this.fatNumbers[i]);
        }
    }

    @NotNull
    public final Long[] getChain$libaums_release(long startCluster) throws IOException {
        if (startCluster == 0L) {
            return new Long[0];
        }
        Long[] cachedChain = (Long[])this.cache.get(startCluster);
        if (cachedChain != null) {
            return cachedChain;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long currentCluster = startCluster;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        do {
            result.add(currentCluster);
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset == offset) continue;
            buffer.clear();
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            this.blockDevice.read(offset, buffer);
            lastOffset = offset;
        } while ((currentCluster = (long)(buffer.getInt((int)offsetInBlock) & 0xFFFFFFF)) < 0xFFFFFF8L);
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long[] arr = thisCollection$iv.toArray(new Long[0]);
        Long l = startCluster;
        ((Map)this.cache).put(l, arr);
        return arr;
    }

    @NotNull
    public final Long[] alloc$libaums_release(@NotNull Long[] chain, int numberOfClusters) throws IOException {
        int numberOfClusters2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        int originalNumberOfClusters = numberOfClusters2 = numberOfClusters;
        ArrayList<Long> result = new ArrayList<Long>(chain.length + numberOfClusters2);
        result.addAll((Collection)Arrays.asList(Arrays.copyOf(chain, chain.length)));
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long cluster = !(chain.length == 0) ? chain[chain.length - 1] : -1L;
        long lastAllocated = this.fsInfoStructure.getLastAllocatedClusterHint();
        if (lastAllocated == (long)FsInfoStructure.Companion.getINVALID_VALUE()) {
            lastAllocated = 2L;
        }
        long currentCluster = lastAllocated;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        while (numberOfClusters2 > 0) {
            long l = currentCluster;
            currentCluster = l + 1L;
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            if (buffer.getInt((int)offsetInBlock) != 0) continue;
            result.add(currentCluster);
            --numberOfClusters2;
        }
        if ((int)cluster != -1) {
            offset = (this.fatOffset[0] + cluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + cluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Number)result.get(chain.length)).longValue());
        }
        int n = result.size() - 1;
        for (int i = chain.length; i < n; ++i) {
            Object e = result.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"result[i]");
            currentCluster = ((Number)e).longValue();
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.blockDevice.write(lastOffset, buffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, (int)((Number)result.get(i + 1)).longValue());
        }
        Object e = result.get(result.size() - 1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"result[result.size - 1]");
        currentCluster = ((Number)e).longValue();
        offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
        offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
        if (lastOffset != offset) {
            buffer.clear();
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            this.blockDevice.write(lastOffset, buffer);
            buffer.clear();
            this.blockDevice.read(offset, buffer);
        }
        buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
        buffer.clear();
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.blockDevice.write(offset, buffer);
        this.fsInfoStructure.setLastAllocatedClusterHint(currentCluster);
        this.fsInfoStructure.decreaseClusterCount(originalNumberOfClusters);
        this.fsInfoStructure.write();
        Log.i((String)TAG, (String)"allocating clusters finished");
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Long[] arr = thisCollection$iv.toArray(new Long[0]);
        ((Map)this.cache).put(arr[0], arr);
        return arr;
    }

    @NotNull
    public final Long[] free$libaums_release(@NotNull Long[] chain, int numberOfClusters) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        int offsetInChain = chain.length - numberOfClusters;
        int bufferSize = this.blockDevice.getBlockSize() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (!(offsetInChain >= 0)) {
            boolean bl = false;
            String string = "trying to remove more clusters in chain than currently exist!";
            throw new IllegalStateException(string.toString());
        }
        long currentCluster = 0L;
        long offset = 0L;
        long offsetInBlock = 0L;
        long lastOffset = -1L;
        int n = chain.length;
        for (int i = offsetInChain; i < n; ++i) {
            currentCluster = chain[i];
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                if ((int)lastOffset != -1) {
                    buffer.clear();
                    Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                    this.blockDevice.write(lastOffset, buffer);
                }
                buffer.clear();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.blockDevice.read(offset, buffer);
                lastOffset = offset;
            }
            buffer.putInt((int)offsetInBlock, 0);
        }
        if (offsetInChain > 0) {
            currentCluster = chain[offsetInChain - 1];
            offset = (this.fatOffset[0] + currentCluster * (long)4) / (long)bufferSize * (long)bufferSize;
            offsetInBlock = (this.fatOffset[0] + currentCluster * (long)4) % (long)bufferSize;
            if (lastOffset != offset) {
                buffer.clear();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.blockDevice.write(lastOffset, buffer);
                buffer.clear();
                this.blockDevice.read(offset, buffer);
            }
            buffer.putInt((int)offsetInBlock, 0xFFFFFF8);
            buffer.clear();
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            this.blockDevice.write(offset, buffer);
        } else {
            buffer.clear();
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
            this.blockDevice.write(lastOffset, buffer);
        }
        Log.i((String)TAG, (String)("freed " + numberOfClusters + " clusters"));
        this.fsInfoStructure.decreaseClusterCount(-numberOfClusters);
        this.fsInfoStructure.write();
        Long[] arr = Arrays.copyOfRange(chain, 0, offsetInChain);
        Intrinsics.checkNotNullExpressionValue((Object)arr, (String)"arr");
        if (!(arr.length == 0)) {
            ((Map)this.cache).put(arr[0], arr);
        }
        return arr;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/jahnen/libaums/core/fs/fat32/FAT$Companion;", "", "()V", "FAT32_EOF_CLUSTER", "", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

