/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.fs.FileSystem;
import me.jahnen.libaums.core.fs.UsbFile;
import me.jahnen.libaums.core.fs.UsbFileInputStream;
import me.jahnen.libaums.core.fs.UsbFileOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lme/jahnen/libaums/core/fs/UsbFileStreamFactory;", "", "()V", "createBufferedInputStream", "Ljava/io/BufferedInputStream;", "file", "Lme/jahnen/libaums/core/fs/UsbFile;", "fs", "Lme/jahnen/libaums/core/fs/FileSystem;", "createBufferedOutputStream", "Ljava/io/BufferedOutputStream;", "libaums_release"})
public final class UsbFileStreamFactory {
    @NotNull
    public static final UsbFileStreamFactory INSTANCE = new UsbFileStreamFactory();

    private UsbFileStreamFactory() {
    }

    @JvmStatic
    @NotNull
    public static final BufferedOutputStream createBufferedOutputStream(@NotNull UsbFile file, @NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        return new BufferedOutputStream(new UsbFileOutputStream(file, false, 2, null), fs.getChunkSize());
    }

    @JvmStatic
    @NotNull
    public static final BufferedInputStream createBufferedInputStream(@NotNull UsbFile file, @NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        return new BufferedInputStream(new UsbFileInputStream(file), fs.getChunkSize());
    }
}

