/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.fs.UsbFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/jahnen/libaums/core/fs/UsbFileOutputStream;", "Ljava/io/OutputStream;", "file", "Lme/jahnen/libaums/core/fs/UsbFile;", "append", "", "(Lme/jahnen/libaums/core/fs/UsbFile;Z)V", "currentByteOffset", "", "close", "", "flush", "write", "buffer", "", "offset", "", "count", "oneByte", "libaums_release"})
public final class UsbFileOutputStream
extends OutputStream {
    @NotNull
    private final UsbFile file;
    private long currentByteOffset;

    @JvmOverloads
    public UsbFileOutputStream(@NotNull UsbFile file, boolean append) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        if (this.file.isDirectory()) {
            throw new UnsupportedOperationException("UsbFileOutputStream cannot be created on directory!");
        }
        if (append) {
            this.currentByteOffset = this.file.getLength();
        }
    }

    public /* synthetic */ UsbFileOutputStream(UsbFile usbFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(usbFile, bl);
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] byArray = new byte[]{(byte)oneByte};
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer);
        long l = this.currentByteOffset;
        this.currentByteOffset = l + 1L;
    }

    @Override
    public void close() throws IOException {
        this.file.setLength(this.currentByteOffset);
        this.file.close();
    }

    @Override
    public void flush() throws IOException {
        this.file.flush();
    }

    @Override
    public void write(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += (long)buffer.length;
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int count) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(offset);
        byteBuffer.limit(count + offset);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        this.file.write(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += (long)count;
    }

    @JvmOverloads
    public UsbFileOutputStream(@NotNull UsbFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(file, false, 2, null);
    }
}

