/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.fs.UsbFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/jahnen/libaums/core/fs/UsbFileInputStream;", "Ljava/io/InputStream;", "file", "Lme/jahnen/libaums/core/fs/UsbFile;", "(Lme/jahnen/libaums/core/fs/UsbFile;)V", "currentByteOffset", "", "available", "", "close", "", "read", "buffer", "", "byteOffset", "byteCount", "skip", "Companion", "libaums_release"})
public final class UsbFileInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsbFile file;
    private long currentByteOffset;
    private static final String TAG = UsbFileInputStream.class.getSimpleName();

    public UsbFileInputStream(@NotNull UsbFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        if (this.file.isDirectory()) {
            throw new UnsupportedOperationException("UsbFileInputStream cannot be created on directory!");
        }
    }

    @Override
    public int available() throws IOException {
        Log.d((String)TAG, (String)"available");
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.allocate(512);
        buffer.limit(1);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.file.read(this.currentByteOffset, buffer);
        long l = this.currentByteOffset;
        this.currentByteOffset = l + 1L;
        buffer.flip();
        return buffer.get();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public int read(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)buffer.length, length - this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.limit((int)toRead);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        this.file.read(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += toRead;
        return (int)toRead;
    }

    @Override
    public int read(@NotNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)byteCount, length - this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(byteOffset);
        byteBuffer.limit((int)toRead + byteOffset);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        this.file.read(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += toRead;
        return (int)toRead;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skippedBytes = Math.min(byteCount, this.file.getLength() - this.currentByteOffset);
        this.currentByteOffset += skippedBytes;
        return skippedBytes;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/fs/UsbFileInputStream$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

