/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs;

import java.io.IOException;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.fs.FileSystem;
import me.jahnen.libaums.core.fs.FileSystemCreator;
import me.jahnen.libaums.core.fs.fat32.Fat32FileSystemCreator;
import me.jahnen.libaums.core.partition.PartitionTableEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lme/jahnen/libaums/core/fs/FileSystemFactory;", "", "()V", "DEFAULT_PRIORITY", "", "count", "fileSystems", "Ljava/util/TreeSet;", "Lme/jahnen/libaums/core/fs/FileSystemFactory$PrioritizedFileSystemCreator;", "kotlin.jvm.PlatformType", "timeZone", "Ljava/util/TimeZone;", "getTimeZone$annotations", "getTimeZone", "()Ljava/util/TimeZone;", "setTimeZone", "(Ljava/util/TimeZone;)V", "clearFileSystems", "", "createFileSystem", "Lme/jahnen/libaums/core/fs/FileSystem;", "entry", "Lme/jahnen/libaums/core/partition/PartitionTableEntry;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "registerFileSystem", "creator", "Lme/jahnen/libaums/core/fs/FileSystemCreator;", "priority", "PrioritizedFileSystemCreator", "UnsupportedFileSystemException", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nFileSystemFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemFactory.kt\nme/jahnen/libaums/core/fs/FileSystemFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1855#2,2:116\n*S KotlinDebug\n*F\n+ 1 FileSystemFactory.kt\nme/jahnen/libaums/core/fs/FileSystemFactory\n*L\n67#1:116,2\n*E\n"})
public final class FileSystemFactory {
    @NotNull
    public static final FileSystemFactory INSTANCE = new FileSystemFactory();
    private static int count;
    @NotNull
    private static final TreeSet<PrioritizedFileSystemCreator> fileSystems;
    public static final int DEFAULT_PRIORITY = 0;
    private static TimeZone timeZone;

    private FileSystemFactory() {
    }

    public static final TimeZone getTimeZone() {
        return timeZone;
    }

    public static final void setTimeZone(TimeZone timeZone) {
        FileSystemFactory.timeZone = timeZone;
    }

    @JvmStatic
    public static /* synthetic */ void getTimeZone$annotations() {
    }

    @NotNull
    public final synchronized FileSystem createFileSystem(@NotNull PartitionTableEntry entry, @NotNull BlockDeviceDriver blockDevice) throws IOException, UnsupportedFileSystemException {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
        Iterable $this$forEach$iv = fileSystems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrioritizedFileSystemCreator it = (PrioritizedFileSystemCreator)element$iv;
            boolean bl = false;
            FileSystem fs = it.getCreator().read(entry, blockDevice);
            if (fs == null) continue;
            return fs;
        }
        throw new UnsupportedFileSystemException();
    }

    @JvmStatic
    public static final synchronized void registerFileSystem(@NotNull FileSystemCreator creator) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        FileSystemFactory.registerFileSystem(creator, 0);
    }

    @JvmStatic
    public static final synchronized void registerFileSystem(@NotNull FileSystemCreator creator, int priority) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        int n = count;
        count = n + 1;
        fileSystems.add(new PrioritizedFileSystemCreator(priority, n, creator));
    }

    @JvmStatic
    public static final synchronized void clearFileSystems() {
        fileSystems.clear();
    }

    static {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                PrioritizedFileSystemCreator it = (PrioritizedFileSystemCreator)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (PrioritizedFileSystemCreator)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        };
        fileSystems = new TreeSet(new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    PrioritizedFileSystemCreator it = (PrioritizedFileSystemCreator)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCount());
                    it = (PrioritizedFileSystemCreator)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCount()));
                }
                return n;
            }
        });
        timeZone = TimeZone.getDefault();
        FileSystemFactory.registerFileSystem(new Fat32FileSystemCreator(), 1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/jahnen/libaums/core/fs/FileSystemFactory$UnsupportedFileSystemException;", "Ljava/io/IOException;", "()V", "libaums_release"})
    public static final class UnsupportedFileSystemException
    extends IOException {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lme/jahnen/libaums/core/fs/FileSystemFactory$PrioritizedFileSystemCreator;", "", "priority", "", "count", "creator", "Lme/jahnen/libaums/core/fs/FileSystemCreator;", "(IILme/jahnen/libaums/core/fs/FileSystemCreator;)V", "getCount", "()I", "getCreator", "()Lme/jahnen/libaums/core/fs/FileSystemCreator;", "getPriority", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "libaums_release"})
    private static final class PrioritizedFileSystemCreator {
        private final int priority;
        private final int count;
        @NotNull
        private final FileSystemCreator creator;

        public PrioritizedFileSystemCreator(int priority, int count, @NotNull FileSystemCreator creator) {
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            this.priority = priority;
            this.count = count;
            this.creator = creator;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public final FileSystemCreator getCreator() {
            return this.creator;
        }

        public final int component1() {
            return this.priority;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final FileSystemCreator component3() {
            return this.creator;
        }

        @NotNull
        public final PrioritizedFileSystemCreator copy(int priority, int count, @NotNull FileSystemCreator creator) {
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            return new PrioritizedFileSystemCreator(priority, count, creator);
        }

        public static /* synthetic */ PrioritizedFileSystemCreator copy$default(PrioritizedFileSystemCreator prioritizedFileSystemCreator, int n, int n2, FileSystemCreator fileSystemCreator, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = prioritizedFileSystemCreator.priority;
            }
            if ((n3 & 2) != 0) {
                n2 = prioritizedFileSystemCreator.count;
            }
            if ((n3 & 4) != 0) {
                fileSystemCreator = prioritizedFileSystemCreator.creator;
            }
            return prioritizedFileSystemCreator.copy(n, n2, fileSystemCreator);
        }

        @NotNull
        public String toString() {
            return "PrioritizedFileSystemCreator(priority=" + this.priority + ", count=" + this.count + ", creator=" + this.creator + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.priority);
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + this.creator.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrioritizedFileSystemCreator)) {
                return false;
            }
            PrioritizedFileSystemCreator prioritizedFileSystemCreator = (PrioritizedFileSystemCreator)other;
            if (this.priority != prioritizedFileSystemCreator.priority) {
                return false;
            }
            if (this.count != prioritizedFileSystemCreator.count) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.creator, (Object)prioritizedFileSystemCreator.creator);
        }
    }
}

