/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.fs;

import android.util.Log;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jahnen.libaums.core.fs.UsbFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lme/jahnen/libaums/core/fs/AbstractUsbFile;", "Lme/jahnen/libaums/core/fs/UsbFile;", "()V", "absolutePath", "", "getAbsolutePath", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "search", "path", "searchThis", "name", "toString", "Companion", "libaums_release"})
public abstract class AbstractUsbFile
implements UsbFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = AbstractUsbFile.class.getSimpleName();

    @Override
    @NotNull
    public String getAbsolutePath() {
        String string;
        String string2;
        if (this.isRoot()) {
            return "/";
        }
        UsbFile usbFile = this.getParent();
        if (usbFile != null) {
            UsbFile parent = usbFile;
            boolean bl = false;
            string2 = parent.isRoot() ? '/' + this.getName() : parent.getAbsolutePath() + '/' + this.getName();
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    @Override
    @Nullable
    public UsbFile search(@NotNull String path) throws IOException {
        int index;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String path2 = path;
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException("This is a file!");
        }
        Log.d((String)TAG, (String)("search file: " + path2));
        if (this.isRoot() && Intrinsics.areEqual((Object)path2, (Object)"/")) {
            return this;
        }
        if (this.isRoot() && StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            String string = path2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            path2 = string;
        }
        if (StringsKt.endsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            String string = path2.substring(0, path2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            path2 = string;
        }
        if ((index = StringsKt.indexOf$default((CharSequence)path2, (String)"/", (int)0, (boolean)false, (int)6, null)) < 0) {
            Log.d((String)TAG, (String)("search entry: " + path2));
            return this.searchThis(path2);
        }
        String string = path2.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String subPath = string;
        String string2 = path2.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String dirName = string2;
        Log.d((String)TAG, (String)("search recursively " + subPath + " in " + dirName));
        UsbFile file = this.searchThis(dirName);
        if (file != null && file.isDirectory()) {
            Log.d((String)TAG, (String)("found directory " + dirName));
            return file.search(subPath);
        }
        Log.d((String)TAG, (String)("not found " + path2));
        return null;
    }

    private final UsbFile searchThis(String name) throws IOException {
        for (UsbFile file : this.listFiles()) {
            if (!Intrinsics.areEqual((Object)file.getName(), (Object)name)) continue;
            return file;
        }
        return null;
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof UsbFile && Intrinsics.areEqual((Object)this.getAbsolutePath(), (Object)((UsbFile)other).getAbsolutePath());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/fs/AbstractUsbFile$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

