/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.driver.scsi.commands.sense;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.scsi.commands.sense.Aborted;
import me.jahnen.libaums.core.driver.scsi.commands.sense.BlankCheck;
import me.jahnen.libaums.core.driver.scsi.commands.sense.CopyAborted;
import me.jahnen.libaums.core.driver.scsi.commands.sense.DataProtect;
import me.jahnen.libaums.core.driver.scsi.commands.sense.HardwareError;
import me.jahnen.libaums.core.driver.scsi.commands.sense.IllegalCommand;
import me.jahnen.libaums.core.driver.scsi.commands.sense.ManualIntervention;
import me.jahnen.libaums.core.driver.scsi.commands.sense.MediaNotInserted;
import me.jahnen.libaums.core.driver.scsi.commands.sense.MediumError;
import me.jahnen.libaums.core.driver.scsi.commands.sense.Miscompare;
import me.jahnen.libaums.core.driver.scsi.commands.sense.NotReady;
import me.jahnen.libaums.core.driver.scsi.commands.sense.NotReadyTryAgain;
import me.jahnen.libaums.core.driver.scsi.commands.sense.RestartRequired;
import me.jahnen.libaums.core.driver.scsi.commands.sense.SenseException;
import me.jahnen.libaums.core.driver.scsi.commands.sense.UnitAttention;
import me.jahnen.libaums.core.driver.scsi.commands.sense.VolumeOverflow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006!"}, d2={"Lme/jahnen/libaums/core/driver/scsi/commands/sense/ScsiRequestSenseResponse;", "", "()V", "<set-?>", "", "additionalSenseCode", "getAdditionalSenseCode", "()B", "additionalSenseCodeQualifier", "getAdditionalSenseCodeQualifier", "additionalSenseLength", "getAdditionalSenseLength", "", "commandSpecificInformation", "getCommandSpecificInformation", "()I", "errorCode", "getErrorCode", "information", "getInformation", "", "informationValid", "getInformationValid", "()Z", "segmentNumber", "getSegmentNumber", "senseKey", "getSenseKey", "checkResponseForError", "", "handleMediumError", "handleNotReady", "Companion", "libaums_release"})
public final class ScsiRequestSenseResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean informationValid;
    private byte errorCode;
    private byte segmentNumber;
    private byte senseKey;
    private int information;
    private byte additionalSenseLength;
    private int commandSpecificInformation;
    private byte additionalSenseCode;
    private byte additionalSenseCodeQualifier;
    public static final int NO_SENSE = 0;
    public static final int RECOVERED_ERROR = 1;
    public static final int NOT_READY = 2;
    public static final int MEDIUM_ERROR = 3;
    public static final int HARDWARE_ERROR = 4;
    public static final int ILLEGAL_REQUEST = 5;
    public static final int UNIT_ATTENTION = 6;
    public static final int DATA_PROTECT = 7;
    public static final int BLANK_CHECK = 8;
    public static final int COPY_ABORTED = 10;
    public static final int ABORTED = 11;
    public static final int VOLUME_OVERFLOW = 13;
    public static final int MISCOMPARE = 14;
    public static final int COMPLETED = 15;

    private ScsiRequestSenseResponse() {
    }

    public final boolean getInformationValid() {
        return this.informationValid;
    }

    public final byte getErrorCode() {
        return this.errorCode;
    }

    public final byte getSegmentNumber() {
        return this.segmentNumber;
    }

    public final byte getSenseKey() {
        return this.senseKey;
    }

    public final int getInformation() {
        return this.information;
    }

    public final byte getAdditionalSenseLength() {
        return this.additionalSenseLength;
    }

    public final int getCommandSpecificInformation() {
        return this.commandSpecificInformation;
    }

    public final byte getAdditionalSenseCode() {
        return this.additionalSenseCode;
    }

    public final byte getAdditionalSenseCodeQualifier() {
        return this.additionalSenseCodeQualifier;
    }

    public final void checkResponseForError() {
        switch (this.senseKey) {
            case 0: 
            case 1: 
            case 15: {
                break;
            }
            case 2: {
                this.handleNotReady();
                break;
            }
            case 3: {
                this.handleMediumError();
                break;
            }
            case 4: {
                throw new HardwareError(this);
            }
            case 5: {
                throw new IllegalCommand(this);
            }
            case 6: {
                throw new UnitAttention(this);
            }
            case 7: {
                throw new DataProtect(this);
            }
            case 8: {
                throw new BlankCheck(this);
            }
            case 10: {
                throw new CopyAborted(this);
            }
            case 11: {
                throw new Aborted(this);
            }
            case 13: {
                throw new VolumeOverflow(this);
            }
            case 14: {
                throw new Miscompare(this);
            }
        }
        throw new SenseException(this, "Sense exception: " + this.senseKey);
    }

    private final void handleNotReady() {
        if (this.additionalSenseCode == 4) {
            switch (this.additionalSenseCodeQualifier) {
                case 1: {
                    throw new NotReadyTryAgain(this);
                }
                case 3: {
                    throw new ManualIntervention(this, null, 2, null);
                }
                case 4: {
                    throw new NotReadyTryAgain(this);
                }
                case 7: {
                    throw new NotReadyTryAgain(this);
                }
                case 9: {
                    throw new NotReadyTryAgain(this);
                }
                case 34: {
                    throw new RestartRequired(this);
                }
                case 18: {
                    throw new NotReady(this, "Not ready; logical unit offline");
                }
            }
        } else if (this.additionalSenseCode == 58) {
            throw new MediaNotInserted(this);
        }
        throw new NotReady(this, null, 2, null);
    }

    private final void handleMediumError() {
        switch (this.additionalSenseCode) {
            case 12: {
                throw new MediumError(this, "Write error");
            }
            case 17: {
                throw new MediumError(this, "Read error");
            }
            case 49: {
                throw new MediumError(this, "Storage medium corrupted");
            }
        }
        throw new MediumError(this, null, 2, null);
    }

    public /* synthetic */ ScsiRequestSenseResponse(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/jahnen/libaums/core/driver/scsi/commands/sense/ScsiRequestSenseResponse$Companion;", "", "()V", "ABORTED", "", "BLANK_CHECK", "COMPLETED", "COPY_ABORTED", "DATA_PROTECT", "HARDWARE_ERROR", "ILLEGAL_REQUEST", "MEDIUM_ERROR", "MISCOMPARE", "NOT_READY", "NO_SENSE", "RECOVERED_ERROR", "UNIT_ATTENTION", "VOLUME_OVERFLOW", "read", "Lme/jahnen/libaums/core/driver/scsi/commands/sense/ScsiRequestSenseResponse;", "buffer", "Ljava/nio/ByteBuffer;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScsiRequestSenseResponse read(@NotNull ByteBuffer buffer) {
            ScsiRequestSenseResponse scsiRequestSenseResponse;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            buffer.order(ByteOrder.BIG_ENDIAN);
            ScsiRequestSenseResponse $this$read_u24lambda_u240 = scsiRequestSenseResponse = new ScsiRequestSenseResponse(null);
            boolean bl = false;
            $this$read_u24lambda_u240.errorCode = buffer.get();
            $this$read_u24lambda_u240.segmentNumber = buffer.get();
            $this$read_u24lambda_u240.senseKey = buffer.get();
            $this$read_u24lambda_u240.information = buffer.getInt();
            $this$read_u24lambda_u240.additionalSenseLength = buffer.get();
            $this$read_u24lambda_u240.commandSpecificInformation = buffer.getInt();
            $this$read_u24lambda_u240.additionalSenseCode = buffer.get();
            $this$read_u24lambda_u240.additionalSenseCodeQualifier = buffer.get();
            $this$read_u24lambda_u240.informationValid = ($this$read_u24lambda_u240.getErrorCode() & 0x80) > 0;
            $this$read_u24lambda_u240.errorCode = (byte)($this$read_u24lambda_u240.getErrorCode() & 0x7F);
            $this$read_u24lambda_u240.senseKey = (byte)($this$read_u24lambda_u240.getSenseKey() & 0xF);
            return scsiRequestSenseResponse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

