/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.driver.scsi;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.driver.scsi.commands.CommandBlockWrapper;
import me.jahnen.libaums.core.driver.scsi.commands.CommandStatusWrapper;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiInquiry;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiInquiryResponse;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiRead10;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiReadCapacity;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiReadCapacityResponse;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiTestUnitReady;
import me.jahnen.libaums.core.driver.scsi.commands.ScsiWrite10;
import me.jahnen.libaums.core.driver.scsi.commands.sense.InitRequired;
import me.jahnen.libaums.core.driver.scsi.commands.sense.NotReadyTryAgain;
import me.jahnen.libaums.core.driver.scsi.commands.sense.ScsiRequestSense;
import me.jahnen.libaums.core.driver.scsi.commands.sense.ScsiRequestSenseResponse;
import me.jahnen.libaums.core.driver.scsi.commands.sense.SenseException;
import me.jahnen.libaums.core.usb.PipeException;
import me.jahnen.libaums.core.usb.UsbCommunication;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u001cH\u0002J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0014H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010+\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0014H\u0002J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0014H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lme/jahnen/libaums/core/driver/scsi/ScsiBlockDevice;", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "usbCommunication", "Lme/jahnen/libaums/core/usb/UsbCommunication;", "lun", "", "(Lme/jahnen/libaums/core/usb/UsbCommunication;B)V", "<set-?>", "", "blockSize", "getBlockSize", "()I", "blocks", "", "getBlocks", "()J", "cbwTagCounter", "csw", "Lme/jahnen/libaums/core/driver/scsi/commands/CommandStatusWrapper;", "cswBuffer", "Ljava/nio/ByteBuffer;", "lastBlockAddress", "outBuffer", "readCommand", "Lme/jahnen/libaums/core/driver/scsi/commands/ScsiRead10;", "writeCommand", "Lme/jahnen/libaums/core/driver/scsi/commands/ScsiWrite10;", "bulkOnlyMassStorageReset", "", "handleCommandResult", "", "status", "init", "initAttempt", "read", "deviceOffset", "buffer", "requestSense", "transferCommand", "command", "Lme/jahnen/libaums/core/driver/scsi/commands/CommandBlockWrapper;", "inBuffer", "transferCommandWithoutDataPhase", "transferOneCommand", "write", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nScsiBlockDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScsiBlockDevice.kt\nme/jahnen/libaums/core/driver/scsi/ScsiBlockDevice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
public final class ScsiBlockDevice
implements BlockDeviceDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsbCommunication usbCommunication;
    private final byte lun;
    @NotNull
    private final ByteBuffer outBuffer;
    @NotNull
    private final ByteBuffer cswBuffer;
    private int blockSize;
    private int lastBlockAddress;
    @NotNull
    private final ScsiWrite10 writeCommand;
    @NotNull
    private final ScsiRead10 readCommand;
    @NotNull
    private final CommandStatusWrapper csw;
    private int cbwTagCounter;
    private static final int MAX_RECOVERY_ATTEMPTS = 5;
    private static final String TAG = ScsiBlockDevice.class.getSimpleName();

    public ScsiBlockDevice(@NotNull UsbCommunication usbCommunication, byte lun) {
        Intrinsics.checkNotNullParameter((Object)usbCommunication, (String)"usbCommunication");
        this.usbCommunication = usbCommunication;
        this.lun = lun;
        ByteBuffer byteBuffer = ByteBuffer.allocate(31);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(31)");
        this.outBuffer = byteBuffer;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(13);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(CommandStatusWrapper.SIZE)");
        this.cswBuffer = byteBuffer2;
        this.writeCommand = new ScsiWrite10(this.lun);
        this.readCommand = new ScsiRead10(this.lun);
        this.csw = new CommandStatusWrapper();
        this.cbwTagCounter = 1;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public long getBlocks() {
        return this.lastBlockAddress;
    }

    @Override
    public void init() throws IOException {
        Exception lastException = null;
        for (int i = 0; i < 6; ++i) {
            try {
                this.initAttempt();
                return;
            }
            catch (InitRequired e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Reinitializing device";
                }
                Log.i((String)TAG, (String)string);
                lastException = e;
            }
            catch (NotReadyTryAgain e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Reinitializing device";
                }
                Log.i((String)TAG, (String)string);
                lastException = e;
            }
            Thread.sleep(100L);
        }
        throw new IOException("MAX_RECOVERY_ATTEMPTS Exceeded while trying to init communication with USB device, please reattach device and try again", lastException);
    }

    private final void initAttempt() throws IOException {
        ByteBuffer inBuffer = ByteBuffer.allocate(36);
        ScsiInquiry inquiry = new ScsiInquiry((byte)inBuffer.array().length, this.lun);
        CommandBlockWrapper commandBlockWrapper = inquiry;
        Intrinsics.checkNotNullExpressionValue((Object)inBuffer, (String)"inBuffer");
        this.transferCommand(commandBlockWrapper, inBuffer);
        inBuffer.clear();
        ScsiInquiryResponse inquiryResponse = ScsiInquiryResponse.Companion.read(inBuffer);
        Log.d((String)TAG, (String)("inquiry response: " + inquiryResponse));
        if (inquiryResponse.getPeripheralQualifier() != 0 || inquiryResponse.getPeripheralDeviceType() != 0) {
            throw new IOException("unsupported PeripheralQualifier or PeripheralDeviceType");
        }
        ScsiTestUnitReady testUnit = new ScsiTestUnitReady(this.lun);
        this.transferCommandWithoutDataPhase(testUnit);
        ScsiReadCapacity readCapacity = new ScsiReadCapacity(this.lun);
        inBuffer.clear();
        this.transferCommand(readCapacity, inBuffer);
        inBuffer.clear();
        ScsiReadCapacityResponse readCapacityResponse = ScsiReadCapacityResponse.Companion.read(inBuffer);
        this.blockSize = readCapacityResponse.getBlockLength();
        this.lastBlockAddress = readCapacityResponse.getLogicalBlockAddress();
        Log.i((String)TAG, (String)("Block size: " + this.getBlockSize()));
        Log.i((String)TAG, (String)("Last block address: " + this.lastBlockAddress));
    }

    private final void transferCommand(CommandBlockWrapper command, ByteBuffer inBuffer) throws IOException {
        Exception lastException = null;
        for (int i = 0; i < 6; ++i) {
            try {
                int result = this.transferOneCommand(command, inBuffer);
                boolean senseWasNotIssued = this.handleCommandResult(result);
                if (senseWasNotIssued || command.getDirection() == CommandBlockWrapper.Direction.NONE) {
                    return;
                }
            }
            catch (SenseException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "SenseException";
                }
                Log.w((String)TAG, (String)string);
                SenseException senseException = e;
                if (senseException instanceof InitRequired) {
                    this.init();
                } else if (!(senseException instanceof NotReadyTryAgain)) {
                    throw e;
                }
                lastException = e;
            }
            catch (PipeException e) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = e.getMessage();
                if (string == null) {
                    string = "PipeException";
                }
                Log.w((String)TAG, (String)stringBuilder.append(string).append(", try bulk storage reset and retry").toString());
                this.bulkOnlyMassStorageReset();
                lastException = e;
            }
            catch (IOException e) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = e.getMessage();
                if (string == null) {
                    string = "IOException";
                }
                Log.w((String)TAG, (String)stringBuilder.append(string).append(", retrying...").toString());
                lastException = e;
            }
            Thread.sleep(100L);
        }
        throw new IOException("MAX_RECOVERY_ATTEMPTS Exceeded while trying to transfer command to device, please reattach device and try again", lastException);
    }

    private final void transferCommandWithoutDataPhase(CommandBlockWrapper command) throws IOException {
        if (!(command.getDirection() == CommandBlockWrapper.Direction.NONE)) {
            boolean bl = false;
            String string = "Command has a data phase";
            throw new IllegalArgumentException(string.toString());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(0)");
        this.transferCommand(command, byteBuffer);
    }

    private final boolean handleCommandResult(int status) throws IOException {
        boolean bl;
        switch (status) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                this.requestSense();
                bl = false;
                break;
            }
            case 2: {
                this.bulkOnlyMassStorageReset();
                throw new IOException("phase error, please reattach device and try again");
            }
            default: {
                throw new IllegalStateException("CommandStatus wrapper illegal status " + status);
            }
        }
        return bl;
    }

    private final void requestSense() throws IOException {
        ByteBuffer inBuffer = ByteBuffer.allocate(18);
        ScsiRequestSense sense = new ScsiRequestSense((byte)inBuffer.array().length, this.lun);
        CommandBlockWrapper commandBlockWrapper = sense;
        Intrinsics.checkNotNullExpressionValue((Object)inBuffer, (String)"inBuffer");
        int status = this.transferOneCommand(commandBlockWrapper, inBuffer);
        switch (status) {
            case 0: {
                inBuffer.clear();
                ScsiRequestSenseResponse response = ScsiRequestSenseResponse.Companion.read(inBuffer);
                response.checkResponseForError();
                break;
            }
            case 1: {
                throw new IOException("requesting sense failed");
            }
            case 2: {
                this.bulkOnlyMassStorageReset();
                throw new IOException("phase error, please reattach device and try again");
            }
            default: {
                throw new IllegalStateException("CommandStatus wrapper illegal status " + status);
            }
        }
    }

    private final void bulkOnlyMassStorageReset() throws IOException {
        Log.w((String)TAG, (String)"sending bulk only mass storage request");
        byte[] bArr = new byte[2];
        int transferred = this.usbCommunication.controlTransfer(33, 255, 0, this.usbCommunication.getUsbInterface().getId(), bArr, 0);
        if (transferred == -1) {
            throw new IOException("bulk only mass storage reset failed!");
        }
        Log.d((String)TAG, (String)"Trying to clear halt on both endpoints");
        this.usbCommunication.clearFeatureHalt(this.usbCommunication.getInEndpoint());
        this.usbCommunication.clearFeatureHalt(this.usbCommunication.getOutEndpoint());
    }

    private final int transferOneCommand(CommandBlockWrapper command, ByteBuffer inBuffer) throws IOException {
        byte[] outArray = this.outBuffer.array();
        Arrays.fill(outArray, (byte)0);
        command.setDCbwTag(this.cbwTagCounter);
        int n = this.cbwTagCounter;
        this.cbwTagCounter = n + 1;
        this.outBuffer.clear();
        command.serialize(this.outBuffer);
        this.outBuffer.clear();
        int written = this.usbCommunication.bulkOutTransfer(this.outBuffer);
        if (written != outArray.length) {
            throw new IOException("Writing all bytes on command " + command + " failed!");
        }
        int transferLength = command.getDCbwDataTransferLength();
        inBuffer.limit(inBuffer.position() + transferLength);
        int read = 0;
        if (transferLength > 0) {
            if (command.getDirection() == CommandBlockWrapper.Direction.IN) {
                do {
                    read += this.usbCommunication.bulkInTransfer(inBuffer);
                    if (!command.getBCbwDynamicSize()) continue;
                    transferLength = command.dynamicSizeFromPartialResponse(inBuffer);
                    inBuffer.limit(inBuffer.position() + transferLength);
                } while (read < transferLength);
                if (read != transferLength) {
                    throw new IOException("Unexpected command size (" + read + ") on response to " + command);
                }
            } else {
                written = 0;
                while ((written += this.usbCommunication.bulkOutTransfer(inBuffer)) < transferLength) {
                }
                if (written != transferLength) {
                    throw new IOException("Could not write all bytes: " + command);
                }
            }
        }
        this.cswBuffer.clear();
        read = this.usbCommunication.bulkInTransfer(this.cswBuffer);
        if (read != 13) {
            throw new IOException("Unexpected command size while expecting csw");
        }
        this.cswBuffer.clear();
        this.csw.read(this.cswBuffer);
        if (this.csw.getDCswTag() != command.getDCbwTag()) {
            throw new IOException("wrong csw tag!");
        }
        return this.csw.getBCswStatus();
    }

    @Override
    public synchronized void read(long deviceOffset, @NotNull ByteBuffer buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(buffer.remaining() % this.getBlockSize() == 0)) {
            boolean bl = false;
            String string = "buffer.remaining() must be multiple of blockSize!";
            throw new IllegalArgumentException(string.toString());
        }
        this.readCommand.init((int)deviceOffset, buffer.remaining(), this.getBlockSize());
        this.transferCommand(this.readCommand, buffer);
        buffer.position(buffer.limit());
    }

    @Override
    public synchronized void write(long deviceOffset, @NotNull ByteBuffer buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(buffer.remaining() % this.getBlockSize() == 0)) {
            boolean bl = false;
            String string = "buffer.remaining() must be multiple of blockSize!";
            throw new IllegalArgumentException(string.toString());
        }
        this.writeCommand.init((int)deviceOffset, buffer.remaining(), this.getBlockSize());
        this.transferCommand(this.writeCommand, buffer);
        buffer.position(buffer.limit());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/jahnen/libaums/core/driver/scsi/ScsiBlockDevice$Companion;", "", "()V", "MAX_RECOVERY_ATTEMPTS", "", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

