/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/jahnen/libaums/core/driver/ByteBlockDevice;", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "targetBlockDevice", "logicalOffsetToAdd", "", "(Lme/jahnen/libaums/core/driver/BlockDeviceDriver;J)V", "blockSize", "", "getBlockSize", "()I", "blocks", "getBlocks", "()J", "init", "", "read", "byteOffset", "dest", "Ljava/nio/ByteBuffer;", "write", "src", "Companion", "libaums_release"})
public class ByteBlockDevice
implements BlockDeviceDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockDeviceDriver targetBlockDevice;
    private final long logicalOffsetToAdd;
    private static final String TAG = ByteBlockDevice.class.getSimpleName();

    @JvmOverloads
    public ByteBlockDevice(@NotNull BlockDeviceDriver targetBlockDevice, long logicalOffsetToAdd) {
        Intrinsics.checkNotNullParameter((Object)targetBlockDevice, (String)"targetBlockDevice");
        this.targetBlockDevice = targetBlockDevice;
        this.logicalOffsetToAdd = logicalOffsetToAdd;
    }

    public /* synthetic */ ByteBlockDevice(BlockDeviceDriver blockDeviceDriver, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        this(blockDeviceDriver, l);
    }

    @Override
    public int getBlockSize() {
        return this.targetBlockDevice.getBlockSize();
    }

    @Override
    public long getBlocks() {
        return this.targetBlockDevice.getBlocks();
    }

    @Override
    public void init() throws IOException {
        this.targetBlockDevice.init();
    }

    @Override
    public void read(long byteOffset, @NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        long devOffset = byteOffset / (long)this.getBlockSize() + this.logicalOffsetToAdd;
        if (byteOffset % (long)this.getBlockSize() != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.getBlockSize());
            Intrinsics.checkNotNullExpressionValue((Object)tmp, (String)"tmp");
            this.targetBlockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.getBlockSize()));
            int limit = Math.min(dest.remaining(), tmp.remaining());
            tmp.limit(tmp.position() + limit);
            dest.put(tmp);
            long l = devOffset;
            devOffset = l + 1L;
        }
        if (dest.remaining() > 0) {
            ByteBuffer buffer = null;
            if (dest.remaining() % this.getBlockSize() != 0) {
                int rounded = this.getBlockSize() - dest.remaining() % this.getBlockSize() + dest.remaining();
                ByteBuffer byteBuffer = ByteBuffer.allocate(rounded);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(rounded)");
                buffer = byteBuffer;
                buffer.limit(rounded);
            } else {
                buffer = dest;
            }
            this.targetBlockDevice.read(devOffset, buffer);
            if (dest.remaining() % this.getBlockSize() != 0) {
                System.arraycopy(buffer.array(), 0, dest.array(), dest.position(), dest.remaining());
            }
            dest.position(dest.limit());
        }
    }

    @Override
    public void write(long byteOffset, @NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        long devOffset = byteOffset / (long)this.getBlockSize() + this.logicalOffsetToAdd;
        if (byteOffset % (long)this.getBlockSize() != 0L) {
            ByteBuffer tmp = ByteBuffer.allocate(this.getBlockSize());
            Intrinsics.checkNotNullExpressionValue((Object)tmp, (String)"tmp");
            this.targetBlockDevice.read(devOffset, tmp);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.getBlockSize()));
            int remaining = Math.min(tmp.remaining(), src.remaining());
            tmp.put(src.array(), src.position(), remaining);
            src.position(src.position() + remaining);
            tmp.clear();
            this.targetBlockDevice.write(devOffset, tmp);
            long l = devOffset;
            devOffset = l + 1L;
        }
        if (src.remaining() > 0) {
            ByteBuffer buffer = null;
            if (src.remaining() % this.getBlockSize() != 0) {
                int rounded = this.getBlockSize() - src.remaining() % this.getBlockSize() + src.remaining();
                ByteBuffer byteBuffer = ByteBuffer.allocate(rounded);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(rounded)");
                buffer = byteBuffer;
                buffer.limit(rounded);
                System.arraycopy(src.array(), src.position(), buffer.array(), 0, src.remaining());
                src.position(src.limit());
            } else {
                buffer = src;
            }
            this.targetBlockDevice.write(devOffset, buffer);
        }
    }

    @JvmOverloads
    public ByteBlockDevice(@NotNull BlockDeviceDriver targetBlockDevice) {
        Intrinsics.checkNotNullParameter((Object)targetBlockDevice, (String)"targetBlockDevice");
        this(targetBlockDevice, 0L, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/jahnen/libaums/core/driver/ByteBlockDevice$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

