/*
 * Decompiled with CFR 0.152.
 */
package me.jahnen.libaums.core;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.driver.BlockDeviceDriverFactory;
import me.jahnen.libaums.core.driver.scsi.commands.sense.MediaNotInserted;
import me.jahnen.libaums.core.partition.Partition;
import me.jahnen.libaums.core.partition.PartitionTable;
import me.jahnen.libaums.core.partition.PartitionTableEntry;
import me.jahnen.libaums.core.partition.PartitionTableFactory;
import me.jahnen.libaums.core.usb.UsbCommunication;
import me.jahnen.libaums.core.usb.UsbCommunicationFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/jahnen/libaums/core/UsbMassStorageDevice;", "", "usbManager", "Landroid/hardware/usb/UsbManager;", "usbDevice", "Landroid/hardware/usb/UsbDevice;", "usbInterface", "Landroid/hardware/usb/UsbInterface;", "inEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "outEndpoint", "(Landroid/hardware/usb/UsbManager;Landroid/hardware/usb/UsbDevice;Landroid/hardware/usb/UsbInterface;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "inited", "", "partitions", "", "Lme/jahnen/libaums/core/partition/Partition;", "getPartitions", "()Ljava/util/List;", "setPartitions", "(Ljava/util/List;)V", "usbCommunication", "Lme/jahnen/libaums/core/usb/UsbCommunication;", "getUsbDevice", "()Landroid/hardware/usb/UsbDevice;", "close", "", "init", "initPartitions", "partitionTable", "Lme/jahnen/libaums/core/partition/PartitionTable;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "setupDevice", "Companion", "libaums_release"})
@SourceDebugExtension(value={"SMAP\nUsbMassStorageDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsbMassStorageDevice.kt\nme/jahnen/libaums/core/UsbMassStorageDevice\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1549#2:267\n1620#2,3:268\n1603#2,9:271\n1855#2:280\n1856#2:282\n1612#2:283\n1603#2,9:284\n1855#2:293\n1856#2:295\n1612#2:296\n1#3:281\n1#3:294\n*S KotlinDebug\n*F\n+ 1 UsbMassStorageDevice.kt\nme/jahnen/libaums/core/UsbMassStorageDevice\n*L\n133#1:267\n133#1:268,3\n136#1:271,9\n136#1:280\n136#1:282\n136#1:283\n160#1:284,9\n160#1:293\n160#1:295\n160#1:296\n136#1:281\n160#1:294\n*E\n"})
public final class UsbMassStorageDevice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsbManager usbManager;
    @NotNull
    private final UsbDevice usbDevice;
    @NotNull
    private final UsbInterface usbInterface;
    @NotNull
    private final UsbEndpoint inEndpoint;
    @NotNull
    private final UsbEndpoint outEndpoint;
    public List<Partition> partitions;
    private boolean inited;
    private UsbCommunication usbCommunication;
    private static final String TAG = UsbMassStorageDevice.class.getSimpleName();
    private static final int INTERFACE_SUBCLASS = 6;
    private static final int INTERFACE_PROTOCOL = 80;

    private UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint) {
        this.usbManager = usbManager;
        this.usbDevice = usbDevice;
        this.usbInterface = usbInterface;
        this.inEndpoint = inEndpoint;
        this.outEndpoint = outEndpoint;
    }

    @NotNull
    public final UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    @NotNull
    public final List<Partition> getPartitions() {
        List<Partition> list = this.partitions;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"partitions");
        return null;
    }

    public final void setPartitions(@NotNull List<Partition> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.partitions = list;
    }

    public final void init() throws IOException {
        if (!this.usbManager.hasPermission(this.usbDevice)) {
            throw new IllegalStateException("Missing permission to access usb device: " + this.usbDevice);
        }
        this.setupDevice();
        this.inited = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupDevice() throws IOException {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.usbCommunication = UsbCommunicationFactory.INSTANCE.createUsbCommunication(this.usbManager, this.usbDevice, this.usbInterface, this.outEndpoint, this.inEndpoint);
        byte[] maxLun = new byte[1];
        UsbCommunication usbCommunication = this.usbCommunication;
        if (usbCommunication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbCommunication");
            usbCommunication = null;
        }
        usbCommunication.controlTransfer(161, 254, 0, this.usbInterface.getId(), maxLun, 1);
        Log.i((String)TAG, (String)("MAX LUN " + maxLun[0]));
        Iterable iterable = (Iterable)new IntRange(0, (int)maxLun[0]);
        UsbMassStorageDevice usbMassStorageDevice = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void lun;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UsbCommunication usbCommunication2 = this.usbCommunication;
            if (usbCommunication2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usbCommunication");
                usbCommunication2 = null;
            }
            collection.add(BlockDeviceDriverFactory.INSTANCE.createBlockDevice(usbCommunication2, (byte)lun));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<Partition> list;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                BlockDeviceDriver blockDevice = (BlockDeviceDriver)element$iv$iv;
                boolean bl2 = false;
                try {
                    blockDevice.init();
                }
                catch (MediaNotInserted e) {
                    list = null;
                    break block6;
                }
                PartitionTable partitionTable = PartitionTableFactory.INSTANCE.createPartitionTable(blockDevice);
                list = this.initPartitions(partitionTable, blockDevice);
            }
            if (list == null) continue;
            List<Partition> it$iv$iv = list;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        usbMassStorageDevice.setPartitions(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Partition> initPartitions(PartitionTable partitionTable, BlockDeviceDriver blockDevice) throws IOException {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = partitionTable.getPartitionTableEntries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Partition it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PartitionTableEntry it = (PartitionTableEntry)element$iv$iv;
            boolean bl2 = false;
            if (Partition.Companion.createPartition(it, blockDevice) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void close() {
        if (this.inited) {
            UsbCommunication usbCommunication = this.usbCommunication;
            if (usbCommunication == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usbCommunication");
                usbCommunication = null;
            }
            usbCommunication.close();
            this.inited = false;
        }
    }

    @JvmStatic
    @NotNull
    public static final List<UsbMassStorageDevice> getMassStorageDevices(@NotNull UsbDevice $this$getMassStorageDevices, @NotNull Context context) {
        return Companion.getMassStorageDevices($this$getMassStorageDevices, context);
    }

    @JvmStatic
    @NotNull
    public static final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
        return Companion.getMassStorageDevices(context);
    }

    public /* synthetic */ UsbMassStorageDevice(UsbManager usbManager, UsbDevice usbDevice, UsbInterface usbInterface, UsbEndpoint inEndpoint, UsbEndpoint outEndpoint, DefaultConstructorMarker $constructor_marker) {
        this(usbManager, usbDevice, usbInterface, inEndpoint, outEndpoint);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f*\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/jahnen/libaums/core/UsbMassStorageDevice$Companion;", "", "()V", "INTERFACE_PROTOCOL", "", "INTERFACE_SUBCLASS", "TAG", "", "kotlin.jvm.PlatformType", "getMassStorageDevices", "", "Lme/jahnen/libaums/core/UsbMassStorageDevice;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)[Lme/jahnen/libaums/core/UsbMassStorageDevice;", "", "Landroid/hardware/usb/UsbDevice;", "libaums_release"})
    @SourceDebugExtension(value={"SMAP\nUsbMassStorageDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsbMassStorageDevice.kt\nme/jahnen/libaums/core/UsbMassStorageDevice$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,266:1\n1549#2:267\n1620#2,3:268\n766#2:271\n857#2,2:272\n1549#2:274\n1620#2,3:275\n125#3:278\n152#3,3:279\n37#4,2:282\n*S KotlinDebug\n*F\n+ 1 UsbMassStorageDevice.kt\nme/jahnen/libaums/core/UsbMassStorageDevice$Companion\n*L\n197#1:267\n197#1:268,3\n198#1:271\n198#1:272,2\n205#1:274\n205#1:275,3\n256#1:278\n256#1:279,3\n262#1:282,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<UsbMassStorageDevice> getMassStorageDevices(@NotNull UsbDevice $this$getMassStorageDevices, @NotNull Context context) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getMassStorageDevices, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("usb");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.usb.UsbManager");
            UsbManager usbManager = (UsbManager)object;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$this$getMassStorageDevices.getInterfaceCount());
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this$getMassStorageDevices.getInterface((int)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UsbInterface it = (UsbInterface)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.getInterfaceClass() == 8 && it.getInterfaceSubclass() == 6 && it.getInterfaceProtocol() == 80;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                UsbMassStorageDevice usbMassStorageDevice;
                void usbInterface;
                UsbInterface it = (UsbInterface)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Log.i((String)TAG, (String)("Found usb interface: " + usbInterface));
                int endpointCount = usbInterface.getEndpointCount();
                if (endpointCount != 2) {
                    Log.w((String)TAG, (String)"Interface endpoint count != 2");
                }
                UsbEndpoint outEndpoint = null;
                UsbEndpoint inEndpoint = null;
                for (int j = 0; j < endpointCount; ++j) {
                    UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                    Log.i((String)TAG, (String)("Found usb endpoint: " + endpoint));
                    if (endpoint.getType() != 2) continue;
                    if (endpoint.getDirection() == 0) {
                        outEndpoint = endpoint;
                        continue;
                    }
                    inEndpoint = endpoint;
                }
                if (outEndpoint == null || inEndpoint == null) {
                    Log.e((String)TAG, (String)("Not all needed endpoints found. In: " + (outEndpoint != null) + ", Out: " + (outEndpoint != null)));
                    usbMassStorageDevice = null;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)usbInterface, (String)"usbInterface");
                    usbMassStorageDevice = new UsbMassStorageDevice(usbManager, $this$getMassStorageDevices, (UsbInterface)usbInterface, inEndpoint, outEndpoint, null);
                }
                collection.add(usbMassStorageDevice);
            }
            return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final UsbMassStorageDevice[] getMassStorageDevices(@NotNull Context context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("usb");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.usb.UsbManager");
            UsbManager usbManager = (UsbManager)object;
            HashMap hashMap = usbManager.getDeviceList();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"usbManager.deviceList");
            Map $this$map$iv = hashMap;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                UsbDevice device = (UsbDevice)it.getValue();
                Log.i((String)TAG, (String)("found usb device: " + it));
                Intrinsics.checkNotNullExpressionValue((Object)device, (String)"device");
                collection.add(Companion.getMassStorageDevices(device, context));
            }
            Collection $this$toTypedArray$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new UsbMassStorageDevice[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

