/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition.gpt;

import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.jahnen.libaums.core.driver.BlockDeviceDriver;
import me.jahnen.libaums.core.partition.PartitionTable;
import me.jahnen.libaums.core.partition.PartitionTableEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/github/mjdev/libaums/partition/gpt/GPT;", "Lme/jahnen/libaums/core/partition/PartitionTable;", "()V", "partitionTableEntries", "", "Lme/jahnen/libaums/core/partition/PartitionTableEntry;", "getPartitionTableEntries", "()Ljava/util/List;", "partitions", "Ljava/util/ArrayList;", "size", "", "getSize", "()I", "Companion", "libaums_release"})
public final class GPT
implements PartitionTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<PartitionTableEntry> partitions = new ArrayList();
    private static final String TAG = GPT.class.getSimpleName();
    @NotNull
    public static final String EFI_PART = "EFI PART";
    public static final int GPT_OFFSET = 512;
    public static final int ENTRY_SIZE = 128;
    public static final int FIRST_LBA_OFFSET = 32;
    public static final int LAST_LBA_OFFSET = 40;

    private GPT() {
    }

    @Override
    public int getSize() {
        return this.partitions.size() * 128;
    }

    @Override
    @NotNull
    public List<PartitionTableEntry> getPartitionTableEntries() {
        return this.partitions;
    }

    public /* synthetic */ GPT(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/mjdev/libaums/partition/gpt/GPT$Companion;", "", "()V", "EFI_PART", "", "ENTRY_SIZE", "", "FIRST_LBA_OFFSET", "GPT_OFFSET", "LAST_LBA_OFFSET", "TAG", "kotlin.jvm.PlatformType", "read", "Lcom/github/mjdev/libaums/partition/gpt/GPT;", "blockDevice", "Lme/jahnen/libaums/core/driver/BlockDeviceDriver;", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GPT read(@NotNull BlockDeviceDriver blockDevice) throws IOException {
            ByteBuffer buffer;
            Intrinsics.checkNotNullParameter((Object)blockDevice, (String)"blockDevice");
            GPT result = new GPT(null);
            ByteBuffer byteBuffer = buffer = ByteBuffer.allocate(1024);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
            blockDevice.read(0L, byteBuffer);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
            byte[] byArray2 = byArray;
            int n = 512;
            int n2 = 8;
            Charset charset = Charsets.US_ASCII;
            String efiTestString = new String(byArray2, n, n2, charset);
            Log.d((String)TAG, (String)("EFI test string " + efiTestString));
            if (!Intrinsics.areEqual((Object)efiTestString, (Object)GPT.EFI_PART)) {
                return null;
            }
            Log.d((String)TAG, (String)"EFI test string matches!");
            ByteBuffer byteBuffer2 = buffer = ByteBuffer.allocate(17408);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer");
            blockDevice.read(0L, byteBuffer2);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int entry_offset = 1024;
            while (buffer.get(entry_offset) != 0) {
                long firstLba = buffer.getLong(entry_offset + 32);
                PartitionTableEntry entry = new PartitionTableEntry(-1, firstLba, buffer.getLong(entry_offset + 40) - firstLba);
                result.partitions.add(entry);
                entry_offset += 128;
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

