/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson.compressor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import me.doubledutch.lazyjson.compressor.DictionaryCache;
import me.doubledutch.lazyjson.compressor.Segment;

public class Template {
    private List<Segment> segmentList = new ArrayList<Segment>();

    public void addSegment(Segment seg) {
        this.segmentList.add(seg);
    }

    public void addConstant(String pre) {
        this.addSegment(new Segment(pre));
    }

    public void addNull(String pre) {
        this.addSegment(new Segment(pre, 8));
    }

    public void addBoolean(String pre) {
        this.addSegment(new Segment(pre, 6));
    }

    public void addString(String pre) {
        this.addSegment(new Segment(pre, 7));
    }

    public void addByte(String pre) {
        this.addSegment(new Segment(pre, 0));
    }

    public void addShort(String pre) {
        this.addSegment(new Segment(pre, 1));
    }

    public void addInt(String pre) {
        this.addSegment(new Segment(pre, 2));
    }

    public void addLong(String pre) {
        this.addSegment(new Segment(pre, 3));
    }

    public void addDouble(String pre) {
        this.addSegment(new Segment(pre, 5));
    }

    public void addNull() {
        this.addSegment(new Segment(null, 8));
    }

    public void addBoolean() {
        this.addSegment(new Segment(null, 6));
    }

    public void addString() {
        this.addSegment(new Segment(null, 7));
    }

    public void addByte() {
        this.addSegment(new Segment(null, 0));
    }

    public void addShort() {
        this.addSegment(new Segment(null, 1));
    }

    public void addInt() {
        this.addSegment(new Segment(null, 2));
    }

    public void addLong() {
        this.addSegment(new Segment(null, 3));
    }

    public void addDouble() {
        this.addSegment(new Segment(null, 5));
    }

    public void compact() {
        ArrayList<Segment> compactList = new ArrayList<Segment>();
        StringBuilder buf = new StringBuilder();
        for (Segment segment : this.segmentList) {
            if (segment.type == -1) {
                if (segment.pre == null) continue;
                buf.append(segment.pre);
                continue;
            }
            if (buf.length() > 0) {
                if (segment.pre != null) {
                    buf.append(segment.pre);
                }
                segment.pre = buf.toString();
                buf = new StringBuilder();
            }
            compactList.add(segment);
        }
        if (buf.length() > 0) {
            compactList.add(new Segment(buf.toString()));
        }
        this.segmentList = compactList;
    }

    public String read(ByteBuffer buf, DictionaryCache dict) {
        StringBuilder data = new StringBuilder();
        for (Segment segment : this.segmentList) {
            data.append(segment.read(buf, dict));
        }
        return data.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Template)) {
            return false;
        }
        Template t = (Template)obj;
        if (t.segmentList.size() != this.segmentList.size()) {
            return false;
        }
        for (int i = 0; i < this.segmentList.size(); ++i) {
            if (this.segmentList.get(i).equals(t.segmentList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Template fromDataInput(DataInput din) throws IOException {
        Template t = new Template();
        int size = din.readInt();
        for (int i = 0; i < size; ++i) {
            t.addSegment(Segment.fromDataInput(din));
        }
        return t;
    }

    public void toDataOutput(DataOutput dout) throws IOException {
        dout.writeInt(this.segmentList.size());
        for (Segment s : this.segmentList) {
            s.toDataOutput(dout);
        }
    }

    public int hashCode() {
        int acc = 0;
        for (Segment s : this.segmentList) {
            if (s.pre != null) {
                acc += s.pre.length();
            }
            if (s.type <= 0) continue;
            acc *= s.type;
        }
        return acc;
    }
}

