/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson.compressor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.doubledutch.lazyjson.LazyArray;
import me.doubledutch.lazyjson.LazyElement;
import me.doubledutch.lazyjson.LazyObject;
import me.doubledutch.lazyjson.compressor.DictionaryCache;
import me.doubledutch.lazyjson.compressor.Template;

public class Compressor {
    private HashMap<Template, Short> templateSet = new HashMap();
    private HashMap<Short, Template> templateIdMap = new HashMap();
    private short nextTemplate = 0;
    private LinkedHashMap<Template, Integer> slidingWindow;
    private final int windowSize;
    private int minRepetitions;
    private String prefix;
    private boolean dirtyFlag = false;
    private DictionaryCache dictionary;
    private int templateHit = 0;
    private int templateMiss = 0;

    public Compressor(String prefix, int windowSizeArg, int minRepetitions) throws IOException {
        this.windowSize = windowSizeArg;
        this.minRepetitions = minRepetitions;
        this.prefix = prefix;
        this.slidingWindow = new LinkedHashMap<Template, Integer>(this.windowSize + 1, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Template, Integer> eldest) {
                return this.size() > Compressor.this.windowSize;
            }
        };
        this.dictionary = new DictionaryCache(this.windowSize, minRepetitions);
        this.reloadState();
    }

    private boolean shouldCompress(Template t) {
        if (this.templateSet.containsKey(t)) {
            return true;
        }
        if (this.minRepetitions == 0) {
            this.templateSet.put(t, this.nextTemplate);
            this.templateIdMap.put(this.nextTemplate, t);
            this.nextTemplate = (short)(this.nextTemplate + 1);
            this.dirtyFlag = true;
            return true;
        }
        if (this.slidingWindow.containsKey(t)) {
            int count = this.slidingWindow.get(t) + 1;
            if (count > this.minRepetitions) {
                this.slidingWindow.remove(t);
                this.templateSet.put(t, this.nextTemplate);
                this.templateIdMap.put(this.nextTemplate, t);
                this.nextTemplate = (short)(this.nextTemplate + 1);
                this.dirtyFlag = true;
                return true;
            }
            this.slidingWindow.put(t, count);
        } else {
            this.slidingWindow.put(t, 1);
        }
        return false;
    }

    public byte[] compress(String str) {
        return this.compress(LazyElement.parse(str));
    }

    public byte[] compress(LazyElement elm) {
        Template t = elm.extractTemplate();
        if (this.shouldCompress(t)) {
            try {
                ByteBuffer buf = ByteBuffer.allocate(elm.getSourceLength() - 2);
                buf.putShort(this.templateSet.get(t));
                elm.writeTemplateValues(buf, this.dictionary);
                int pos = buf.position();
                buf.rewind();
                byte[] result = new byte[pos];
                buf.get(result);
                ++this.templateHit;
                return result;
            }
            catch (BufferOverflowException buf) {
                // empty catch block
            }
        }
        byte[] encoded = elm.toString().getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(2 + encoded.length);
        buf.putShort((short)-1);
        buf.put(encoded);
        ++this.templateMiss;
        return buf.array();
    }

    public LazyElement decompressElement(byte[] data) {
        return LazyElement.parse(this.decompress(data));
    }

    public LazyObject decompressObject(byte[] data) {
        return new LazyObject(this.decompress(data));
    }

    public LazyArray decompressArray(byte[] data) {
        return new LazyArray(this.decompress(data));
    }

    public String decompress(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        short templateId = buf.getShort();
        if (templateId == -1) {
            return new String(data, 2, data.length - 2, StandardCharsets.UTF_8);
        }
        Template t = this.templateIdMap.get(templateId);
        String str = t.read(buf, this.dictionary);
        return str;
    }

    private void reloadState() throws IOException {
        DataInputStream in;
        File ftest = new File(this.prefix + ".templates");
        if (ftest.exists()) {
            in = new DataInputStream(new FileInputStream(this.prefix + ".templates"));
            this.nextTemplate = (short)in.readInt();
            for (int i = 0; i < this.nextTemplate; ++i) {
                Template t = Template.fromDataInput(in);
                this.templateSet.put(t, (short)i);
                this.templateIdMap.put((short)i, t);
            }
            in.close();
        }
        if ((ftest = new File(this.prefix + ".dictionary")).exists()) {
            in = new DataInputStream(new FileInputStream(this.prefix + ".dictionary"));
            this.dictionary.fromDataInputStream(in);
            in.close();
        }
    }

    public void commit() throws IOException {
        File ftest;
        DataOutputStream out;
        if (this.dirtyFlag) {
            out = new DataOutputStream(new FileOutputStream(this.prefix + ".templates-tmp"));
            out.writeInt(this.nextTemplate);
            for (Template t : this.templateSet.keySet()) {
                t.toDataOutput(out);
            }
            out.flush();
            out.close();
            ftest = new File(this.prefix + ".templates-tmp");
            ftest.renameTo(new File(this.prefix + ".templates"));
            this.dirtyFlag = false;
        }
        if (this.dictionary.isDirty()) {
            out = new DataOutputStream(new FileOutputStream(this.prefix + ".dictionary-tmp"));
            this.dictionary.toDataOutputStream(out);
            out.flush();
            out.close();
            ftest = new File(this.prefix + ".dictionary-tmp");
            ftest.renameTo(new File(this.prefix + ".dictionary"));
        }
    }

    public int getTemplateCount() {
        return this.templateSet.size();
    }

    public int getDictionaryCount() {
        return this.dictionary.getSize();
    }

    public double getTemplateUtilization() {
        if (this.templateHit + this.templateMiss == 0) {
            return 0.0;
        }
        return (double)this.templateHit / ((double)this.templateHit + (double)this.templateMiss);
    }

    public double getDictionaryUtilization() {
        return this.dictionary.getDictionaryUtilization();
    }
}

