/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson;

import me.doubledutch.lazyjson.LazyException;
import me.doubledutch.lazyjson.LazyNode;

public final class LazyParser {
    private final char CH_SPACE = (char)32;
    private final char CH_LINEFEED = (char)10;
    private final char CH_TAB = (char)9;
    private final char CH_CARRIAGE_RETURN = (char)13;
    private final char CH_QUOTE = (char)34;
    private final char CH_BACKSLASH = (char)92;
    private final char CH_SLASH = (char)47;
    private final char CH_b = (char)98;
    private final char CH_f = (char)102;
    private final char CH_n = (char)110;
    private final char CH_r = (char)114;
    private final char CH_t = (char)116;
    private final char CH_u = (char)117;
    private final char CH_l = (char)108;
    private final char CH_a = (char)97;
    private final char CH_s = (char)115;
    private final char CH_e = (char)101;
    private final char CH_E = (char)69;
    private final char CH_DASH = (char)45;
    private final char CH_PLUS = (char)43;
    private final char CH_COMMA = (char)44;
    private final char CH_COLON = (char)58;
    private final char CH_0 = (char)48;
    private final char CH_9 = (char)57;
    private final char CH_DOT = (char)46;
    private final char CH_BEGIN_CURLY = (char)123;
    private final char CH_END_CURLY = (char)125;
    private final char CH_BEGIN_BRACKET = (char)91;
    private final char CH_END_BRACKET = (char)93;
    private final int STACK_INCREASE = 31;
    private int STACK_SIZE = 32;
    protected LazyNode root;
    protected final char[] cbuf;
    protected final int length;
    private int n = 0;
    private LazyNode[] stack = new LazyNode[this.STACK_SIZE];
    private LazyNode stackTop = null;
    private int stackPointer = 1;

    protected LazyParser(String source) {
        this.length = source.length();
        this.cbuf = new char[this.length];
        source.getChars(0, this.length, this.cbuf, 0);
    }

    private void push(LazyNode token) {
        this.stackTop.addChild(token);
        if ((this.stackPointer & 0x1F) == 31) {
            LazyNode[] newStack = new LazyNode[this.STACK_SIZE + 31 + 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.STACK_SIZE);
            this.STACK_SIZE = this.STACK_SIZE + 31 + 1;
            this.stack = newStack;
        }
        this.stack[this.stackPointer++] = token;
        this.stackTop = token;
    }

    private LazyNode pop() {
        LazyNode value = this.stackTop;
        --this.stackPointer;
        if (this.stackPointer > 0) {
            this.stackTop = this.stack[this.stackPointer - 1];
        }
        return value;
    }

    private void drop() {
        --this.stackPointer;
        this.stackTop = this.stack[this.stackPointer - 1];
    }

    private int size() {
        return this.stackPointer - 1;
    }

    private final void consumeWhiteSpace() {
        char c = this.cbuf[this.n];
        while (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
            ++this.n;
            c = this.cbuf[this.n];
        }
    }

    private final void tryToConsumeWhiteSpace() {
        ++this.n;
        this.consumeWhiteSpace();
        --this.n;
    }

    private final boolean consumeString() throws LazyException {
        boolean escaped = false;
        ++this.n;
        char c = this.cbuf[this.n];
        while (c != '\"') {
            if (c == '\\') {
                ++this.n;
                c = this.cbuf[this.n];
                if (c != '\"' && c != '\\' && c != '/' && c != 'b' && c != 'f' && c != 'n' && c != 'r' && c != 't' && c != 'u') {
                    throw new LazyException("Invalid escape code", this.n);
                }
                escaped = true;
            }
            ++this.n;
            c = this.cbuf[this.n];
        }
        return escaped;
    }

    private final boolean consumeNumber(char c) throws LazyException {
        boolean floatChar = false;
        if (c == '-') {
            ++this.n;
            c = this.cbuf[this.n];
            if (c < '0' || c > '9') {
                throw new LazyException("Digit expected", this.n);
            }
        }
        ++this.n;
        if (c == '0') {
            c = this.cbuf[this.n];
            if (c >= '0' && c <= '9') {
                throw new LazyException("Number may not start with leading zero", this.n);
            }
        } else {
            c = this.cbuf[this.n];
        }
        while (c >= '0' && c <= '9') {
            ++this.n;
            c = this.cbuf[this.n];
        }
        if (c == '.') {
            floatChar = true;
            ++this.n;
            c = this.cbuf[this.n];
            if (c < '0' || c > '9') {
                throw new LazyException("Digit expected", this.n);
            }
            ++this.n;
            c = this.cbuf[this.n];
            while (c >= '0' && c <= '9') {
                ++this.n;
                c = this.cbuf[this.n];
            }
        }
        if (c == 'e' || c == 'E') {
            floatChar = true;
            ++this.n;
            c = this.cbuf[this.n];
            if (c == '-' || c == '+') {
                ++this.n;
                c = this.cbuf[this.n];
                if (c < '0' || c > '9') {
                    throw new LazyException("Digit expected", this.n);
                }
            } else if (c < '0' || c > '9') {
                throw new LazyException("Exponential part expected", this.n);
            }
            ++this.n;
            c = this.cbuf[this.n];
            while (c >= '0' && c <= '9') {
                ++this.n;
                c = this.cbuf[this.n];
            }
        }
        return floatChar;
    }

    protected void tokenize() throws LazyException {
        this.consumeWhiteSpace();
        char c = this.cbuf[this.n];
        if (c == '{') {
            this.stack[this.stackPointer++] = LazyNode.cObject(this.n);
        } else if (c == '[') {
            this.stack[this.stackPointer++] = LazyNode.cArray(this.n);
        } else {
            throw new LazyException("Can not parse raw JSON value, must be either object or array", 0);
        }
        this.stackTop = this.root = this.stack[1];
        ++this.n;
        boolean expectValue = false;
        boolean firstValue = true;
        LazyNode token = null;
        while (this.n < this.length) {
            c = this.cbuf[this.n];
            switch (c) {
                case '{': {
                    this.push(LazyNode.cObject(this.n));
                    expectValue = false;
                    firstValue = true;
                    break;
                }
                case '}': {
                    token = this.pop();
                    if (token == null) {
                        throw new LazyException("Unexpected end of object character", this.n);
                    }
                    if (token.type != 0) {
                        throw new LazyException("Unexpected end of object character", this.n);
                    }
                    token.endIndex = this.n + 1;
                    if (this.stackTop != null && (this.stackTop.type == 2 || this.stackTop.type == 3)) {
                        this.drop();
                    }
                    if (expectValue) {
                        throw new LazyException("Unexpected comma without another value", this.n - 1);
                    }
                    firstValue = false;
                    break;
                }
                case '\"': {
                    expectValue = false;
                    firstValue = false;
                    if (this.stackTop.type == 1) {
                        token = LazyNode.cStringValue(this.n + 1);
                        this.stackTop.addChild(token);
                        if (this.consumeString()) {
                            token.type = (byte)8;
                        }
                        token.endIndex = this.n;
                        break;
                    }
                    if (this.stackTop.type == 2 || this.stackTop.type == 3) {
                        token = LazyNode.cStringValue(this.n + 1);
                        this.stackTop.addChild(token);
                        if (this.consumeString()) {
                            token.type = (byte)8;
                        }
                        token.endIndex = this.n;
                        this.drop();
                        break;
                    }
                    if (this.stackTop.type != 0) break;
                    this.push(LazyNode.cField(this.n + 1));
                    if (this.consumeString()) {
                        this.stackTop.type = (byte)3;
                    }
                    this.stackTop.endIndex = this.n++;
                    this.consumeWhiteSpace();
                    c = this.cbuf[this.n];
                    if (c != ':') {
                        throw new LazyException("Unexpected character! Was expecting field separator ':'", this.n);
                    }
                    this.tryToConsumeWhiteSpace();
                    expectValue = true;
                    break;
                }
                case ',': {
                    if (expectValue) {
                        throw new LazyException("Unexpected comma", this.n);
                    }
                    expectValue = true;
                    if (this.stackTop == null || this.stackTop.type != 1 || !firstValue) break;
                    throw new LazyException("Expected value before comma", this.n);
                }
                case '[': {
                    if (this.stackTop.type == 0) {
                        throw new LazyException("Missing field name for array", this.n);
                    }
                    if (this.stackTop.type == 1 && !firstValue && !expectValue) {
                        throw new LazyException("Nested array without comma", this.n);
                    }
                    this.push(LazyNode.cArray(this.n));
                    expectValue = false;
                    firstValue = true;
                    break;
                }
                case ']': {
                    token = this.pop();
                    if (token == null) {
                        throw new LazyException("Unexpected end of array character", this.n);
                    }
                    if (token.type != 1) {
                        if (token.endIndex == -1) {
                            token.endIndex = this.n;
                        }
                        if ((token = this.pop()) == null || token.type != 1) {
                            throw new LazyException("Unexpected end of array", this.n);
                        }
                    }
                    token.endIndex = this.n + 1;
                    if (this.stackTop != null && (this.stackTop.type == 2 || this.stackTop.type == 3)) {
                        this.drop();
                    }
                    if (expectValue) {
                        throw new LazyException("Unexpected comma without another value", this.n - 1);
                    }
                    firstValue = false;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    if (this.stackTop.type == 1 && !firstValue && !expectValue) {
                        throw new LazyException("Unexpected value, missing comma?", this.n);
                    }
                    if (this.stackTop.type == 0) {
                        throw new LazyException("Unexpected value without field name", this.n);
                    }
                    firstValue = false;
                    expectValue = false;
                    if (c == 'n') {
                        if (this.cbuf[++this.n] == 'u' && this.cbuf[++this.n] == 'l' && this.cbuf[++this.n] == 'l') {
                            token = LazyNode.cValueNull(this.n);
                            this.stackTop.addChild(token);
                            token.endIndex = this.n;
                            if (this.stackTop.type != 2 && this.stackTop.type != 3) break;
                            this.drop();
                            break;
                        }
                        throw new LazyException("Syntax error", this.n);
                    }
                    if (c == 't') {
                        if (this.cbuf[++this.n] == 'r' && this.cbuf[++this.n] == 'u' && this.cbuf[++this.n] == 'e') {
                            token = LazyNode.cValueTrue(this.n);
                            this.stackTop.addChild(token);
                            token.endIndex = this.n;
                            if (this.stackTop.type != 2 && this.stackTop.type != 3) break;
                            this.drop();
                            break;
                        }
                        throw new LazyException("Syntax error", this.n);
                    }
                    if (c == 'f') {
                        if (this.cbuf[++this.n] == 'a' && this.cbuf[++this.n] == 'l' && this.cbuf[++this.n] == 's' && this.cbuf[++this.n] == 'e') {
                            token = LazyNode.cValueFalse(this.n);
                            this.stackTop.addChild(token);
                            token.endIndex = this.n;
                            if (this.stackTop.type != 2 && this.stackTop.type != 3) break;
                            this.drop();
                            break;
                        }
                        throw new LazyException("Syntax error", this.n);
                    }
                    if (c == '-' || c >= '0' && c <= '9') {
                        token = LazyNode.cNumberValue(this.n);
                        this.stackTop.addChild(token);
                        if (this.consumeNumber(c)) {
                            token.type = (byte)10;
                        }
                        token.endIndex = this.n--;
                        if (this.stackTop.type != 2 && this.stackTop.type != 3) break;
                        this.drop();
                        break;
                    }
                    throw new LazyException("Syntax error", this.n);
                }
            }
            ++this.n;
        }
        if (this.size() != 0) {
            throw new LazyException("Unexpected end of JSON data");
        }
        if (expectValue) {
            throw new LazyException("Unexpected trailing comma");
        }
        this.setBuffer(this.root);
    }

    private void setBuffer(LazyNode node) {
        node.cbuf = this.cbuf;
        LazyNode pointer = node.child;
        while (pointer != null) {
            if (pointer.child != null) {
                this.setBuffer(pointer);
            } else {
                pointer.cbuf = this.cbuf;
            }
            pointer = pointer.next;
        }
    }
}

