/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import me.doubledutch.lazyjson.LazyException;
import me.doubledutch.lazyjson.compressor.DictionaryCache;
import me.doubledutch.lazyjson.compressor.Template;

public final class LazyNode {
    protected static final byte OBJECT = 0;
    protected static final byte ARRAY = 1;
    protected static final byte FIELD = 2;
    protected static final byte EFIELD = 3;
    protected static final byte VALUE_TRUE = 4;
    protected static final byte VALUE_FALSE = 5;
    protected static final byte VALUE_NULL = 6;
    protected static final byte VALUE_STRING = 7;
    protected static final byte VALUE_ESTRING = 8;
    protected static final byte VALUE_INTEGER = 9;
    protected static final byte VALUE_FLOAT = 10;
    protected static final byte END_MARKER = 11;
    protected byte type;
    protected boolean dirty = false;
    protected char[] cbuf = null;
    protected StringBuilder dirtyBuf = null;
    protected int startIndex;
    protected int endIndex = -1;
    protected LazyNode child;
    protected LazyNode lastChild;
    protected LazyNode next;

    protected LazyNode(byte type, int startIndex) {
        this.startIndex = startIndex;
        this.type = type;
    }

    protected StringBuilder getDirtyBuf() {
        if (this.dirtyBuf == null) {
            this.dirtyBuf = new StringBuilder();
        }
        return this.dirtyBuf;
    }

    protected boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.child == null) {
            return false;
        }
        LazyNode pointer = this.child;
        while (pointer != null) {
            if (pointer.isDirty()) {
                return true;
            }
            pointer = pointer.next;
        }
        return false;
    }

    protected void addChild(LazyNode token) {
        if (this.lastChild == null) {
            this.child = token;
            this.lastChild = token;
            return;
        }
        this.lastChild.next = token;
        this.lastChild = token;
    }

    protected int getChildCount() {
        int num = 0;
        LazyNode token = this.child;
        while (token != null) {
            ++num;
            token = token.next;
        }
        return num;
    }

    protected static LazyNode cArray(int index) {
        return new LazyNode(1, index);
    }

    protected static LazyNode cObject(int index) {
        return new LazyNode(0, index);
    }

    protected static LazyNode cField(int index) {
        return new LazyNode(2, index);
    }

    protected static LazyNode cStringValue(int index) {
        return new LazyNode(7, index);
    }

    protected static LazyNode cNumberValue(int index) {
        return new LazyNode(9, index);
    }

    protected static LazyNode cValueTrue(int index) {
        return new LazyNode(4, index);
    }

    protected static LazyNode cValueFalse(int index) {
        return new LazyNode(5, index);
    }

    protected static LazyNode cValueNull(int index) {
        return new LazyNode(6, index);
    }

    protected int getIntValue() throws LazyException {
        int i = this.startIndex;
        boolean sign = false;
        int value = 0;
        if (this.type == 10) {
            return (int)this.getDoubleValue();
        }
        if (this.type == 7 || this.type == 8) {
            if (this.dirty) {
                if (this.dirtyBuf.charAt(i) == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.dirtyBuf.charAt(i);
                    if (c < '0' || c > '9') {
                        throw new LazyException("'" + this.getStringValue() + "' is not a valid integer", this.startIndex);
                    }
                    value += 48 - c;
                    if (i + 1 < this.endIndex) {
                        value *= 10;
                    }
                    ++i;
                }
            } else {
                if (this.cbuf[i] == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.cbuf[i];
                    if (c < '0' || c > '9') {
                        throw new LazyException("'" + this.getStringValue() + "' is not a valid integer", this.startIndex);
                    }
                    value += 48 - c;
                    if (i + 1 < this.endIndex) {
                        value *= 10;
                    }
                    ++i;
                }
            }
            return sign ? value : -value;
        }
        if (this.type == 9) {
            if (this.dirty) {
                if (this.dirtyBuf.charAt(i) == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.dirtyBuf.charAt(i);
                    value += 48 - c;
                    if (i + 1 < this.endIndex) {
                        value *= 10;
                    }
                    ++i;
                }
            } else {
                if (this.cbuf[i] == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.cbuf[i];
                    value += 48 - c;
                    if (i + 1 < this.endIndex) {
                        value *= 10;
                    }
                    ++i;
                }
            }
            return sign ? value : -value;
        }
        throw new LazyException("Not an integer", this.startIndex);
    }

    protected long getLongValue() throws LazyException {
        int i = this.startIndex;
        boolean sign = false;
        long value = 0L;
        if (this.type == 10) {
            return (long)this.getDoubleValue();
        }
        if (this.type == 7 || this.type == 8) {
            if (this.dirty) {
                if (this.dirtyBuf.charAt(i) == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.dirtyBuf.charAt(i);
                    if (c < '0' || c > '9') {
                        throw new LazyException("'" + this.getStringValue() + "' is not a valid long", this.startIndex);
                    }
                    value += (long)(48 - c);
                    if (i + 1 < this.endIndex) {
                        value *= 10L;
                    }
                    ++i;
                }
            } else {
                if (this.cbuf[i] == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.cbuf[i];
                    if (c < '0' || c > '9') {
                        throw new LazyException("'" + this.getStringValue() + "' is not a valid long", this.startIndex);
                    }
                    value += (long)(48 - c);
                    if (i + 1 < this.endIndex) {
                        value *= 10L;
                    }
                    ++i;
                }
            }
            return sign ? value : -value;
        }
        if (this.type == 9) {
            if (this.dirty) {
                if (this.dirtyBuf.charAt(i) == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.dirtyBuf.charAt(i);
                    value += (long)(48 - c);
                    if (i + 1 < this.endIndex) {
                        value *= 10L;
                    }
                    ++i;
                }
            } else {
                if (this.cbuf[i] == '-') {
                    sign = true;
                    ++i;
                }
                while (i < this.endIndex) {
                    char c = this.cbuf[i];
                    value += (long)(48 - c);
                    if (i + 1 < this.endIndex) {
                        value *= 10L;
                    }
                    ++i;
                }
            }
            return sign ? value : -value;
        }
        throw new LazyException("Not a long", this.startIndex);
    }

    protected double getDoubleValue() throws LazyException {
        double d = 0.0;
        String str = this.getStringValue();
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    protected String getStringValue() {
        if (this.type == 6) {
            return null;
        }
        if (this.type != 8 && this.type != 3) {
            if (this.dirty) {
                return this.dirtyBuf.substring(this.startIndex, this.endIndex);
            }
            return new String(this.cbuf, this.startIndex, this.endIndex - this.startIndex);
        }
        StringBuilder buf = new StringBuilder(this.endIndex - this.startIndex);
        if (this.dirty) {
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                char c = this.dirtyBuf.charAt(i);
                if (c == '\\') {
                    if ((c = this.dirtyBuf.charAt(++i)) == '\"' || c == '\\' || c == '/') {
                        buf.append(c);
                        continue;
                    }
                    if (c == 'b') {
                        buf.append('\b');
                        continue;
                    }
                    if (c == 'f') {
                        buf.append('\f');
                        continue;
                    }
                    if (c == 'n') {
                        buf.append('\n');
                        continue;
                    }
                    if (c == 'r') {
                        buf.append('\r');
                        continue;
                    }
                    if (c == 't') {
                        buf.append('\t');
                        continue;
                    }
                    if (c != 'u') continue;
                    String code = this.dirtyBuf.substring(i + 1, i + 5);
                    buf.append((char)Integer.parseInt(code, 16));
                    i += 4;
                    continue;
                }
                buf.append(c);
            }
        } else {
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                char c = this.cbuf[i];
                if (c == '\\') {
                    if ((c = this.cbuf[++i]) == '\"' || c == '\\' || c == '/') {
                        buf.append(c);
                        continue;
                    }
                    if (c == 'b') {
                        buf.append('\b');
                        continue;
                    }
                    if (c == 'f') {
                        buf.append('\f');
                        continue;
                    }
                    if (c == 'n') {
                        buf.append('\n');
                        continue;
                    }
                    if (c == 'r') {
                        buf.append('\r');
                        continue;
                    }
                    if (c == 't') {
                        buf.append('\t');
                        continue;
                    }
                    if (c != 'u') continue;
                    String code = new String(this.cbuf, i + 1, 4);
                    buf.append((char)Integer.parseInt(code, 16));
                    i += 4;
                    continue;
                }
                buf.append(c);
            }
        }
        return buf.toString();
    }

    protected String getRawStringValue() {
        if (this.dirty) {
            return this.dirtyBuf.substring(this.startIndex, this.endIndex);
        }
        return new String(this.cbuf, this.startIndex, this.endIndex - this.startIndex);
    }

    protected Iterator<String> getStringIterator() {
        return new StringIterator(this);
    }

    protected String toString(int pad) {
        String out = "";
        for (int i = 0; i < pad; ++i) {
            out = out + " ";
        }
        if (this.type == 0) {
            out = out + "{";
        } else if (this.type == 1) {
            out = out + "[";
        } else if (this.type == 2) {
            out = out + "\"";
        } else if (this.type == 9) {
            out = out + "i";
        } else if (this.type == 4 || this.type == 5) {
            out = out + "b";
        } else if (this.type == 10) {
            out = out + "f";
        } else if (this.type == 7 || this.type == 8) {
            out = out + "s";
        } else if (this.type == 6) {
            out = out + "n";
        }
        out = out + ":[" + this.startIndex + "," + this.endIndex + "]";
        if (this.dirty) {
            out = out + "d";
        }
        out = out + "\n";
        if (this.child != null) {
            LazyNode token = this.child;
            while (token != null) {
                out = out + token.toString(pad + 2);
                token = token.next;
            }
        } else if (this.child != null) {
            out = out + this.child.toString(pad + 2);
        }
        return out;
    }

    private void addCommaSeparatedChildren(Template template) {
        LazyNode next = this.child;
        boolean first = true;
        while (next != null) {
            if (first) {
                first = false;
            } else {
                template.addConstant(",");
            }
            next.addSegments(template);
            next = next.next;
        }
    }

    private String getFieldString() {
        return "\"" + this.getRawStringValue() + "\":";
    }

    private void putString(ByteBuffer buf, DictionaryCache dict) {
        int size;
        String str = this.getStringValue();
        short pos = dict.put(str);
        buf.putShort(pos);
        if (pos > -1) {
            return;
        }
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        for (size = data.length; size > 255; size -= 255) {
            buf.put((byte)-1);
        }
        buf.put((byte)size);
        buf.put(data);
    }

    protected void writeSegmentValues(ByteBuffer buf, DictionaryCache dict) throws BufferOverflowException {
        if (this.type == 0 || this.type == 1) {
            LazyNode next = this.child;
            while (next != null) {
                next.writeSegmentValues(buf, dict);
                next = next.next;
            }
        } else if (this.type == 2) {
            if (this.child.type == 4) {
                buf.put((byte)1);
            } else if (this.child.type == 5) {
                buf.put((byte)0);
            } else if (this.child.type == 7 || this.type == 8) {
                this.child.putString(buf, dict);
            } else if (this.child.type == 9) {
                long l = this.child.getLongValue();
                if (l < 128L && l >= -128L) {
                    buf.put((byte)l);
                } else if (l < 32768L && l >= -32768L) {
                    buf.putShort((short)l);
                } else if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    buf.putInt((int)l);
                } else {
                    buf.putLong(l);
                }
            } else if (this.child.type == 10) {
                buf.putDouble(this.child.getDoubleValue());
            } else {
                this.child.writeSegmentValues(buf, dict);
            }
        } else if (this.type == 4) {
            buf.put((byte)1);
        } else if (this.type == 5) {
            buf.put((byte)0);
        } else if (this.type == 7 || this.type == 8) {
            this.putString(buf, dict);
        } else if (this.type == 9) {
            long l = this.getLongValue();
            if (l < 128L && l >= -128L) {
                buf.put((byte)l);
            } else if (l < 32768L && l >= -32768L) {
                buf.putShort((short)l);
            } else if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                buf.putInt((int)l);
            } else {
                buf.putLong(l);
            }
        } else if (this.type == 10) {
            buf.putDouble(this.getDoubleValue());
        }
    }

    protected void addSegments(Template template) {
        if (this.type == 0) {
            template.addConstant("{");
            this.addCommaSeparatedChildren(template);
            template.addConstant("}");
        } else if (this.type == 1) {
            template.addConstant("[");
            this.addCommaSeparatedChildren(template);
            template.addConstant("]");
        } else if (this.type == 2) {
            if (this.child.type == 4 || this.child.type == 5) {
                template.addBoolean(this.getFieldString());
            } else if (this.child.type == 7) {
                template.addString(this.getFieldString());
            } else if (this.child.type == 6) {
                template.addNull(this.getFieldString());
            } else if (this.child.type == 9) {
                long l = this.child.getLongValue();
                if (l < 128L && l >= -128L) {
                    template.addByte(this.getFieldString());
                } else if (l < 32768L && l >= -32768L) {
                    template.addShort(this.getFieldString());
                } else if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    template.addInt(this.getFieldString());
                } else {
                    template.addLong(this.getFieldString());
                }
            } else if (this.child.type == 10) {
                template.addDouble(this.getFieldString());
            } else {
                template.addConstant(this.getFieldString());
                this.child.addSegments(template);
            }
        } else if (this.type == 4 || this.type == 5) {
            template.addBoolean();
        } else if (this.type == 6) {
            template.addNull();
        } else if (this.type == 7) {
            template.addString();
        } else if (this.type == 9) {
            long l = this.getLongValue();
            if (l < 128L && l >= -128L) {
                template.addByte();
            } else if (l < 32768L && l >= -32768L) {
                template.addShort();
            } else if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                template.addInt();
            } else {
                template.addLong();
            }
        } else if (this.type == 10) {
            template.addDouble();
        }
    }

    protected static LazyNode readFromBuffer(byte[] raw) {
        ByteBuffer buf = ByteBuffer.wrap(raw);
        return LazyNode.readFromBuffer(buf);
    }

    protected static LazyNode readFromBuffer(ByteBuffer buf) {
        byte type = buf.get();
        if (type == 11) {
            return null;
        }
        int startIndex = buf.getInt();
        int endIndex = buf.getInt();
        LazyNode node = new LazyNode(type, startIndex);
        node.endIndex = endIndex;
        if (type == 0 || type == 1) {
            LazyNode child;
            node.child = child = LazyNode.readFromBuffer(buf);
            node.lastChild = child;
            child = LazyNode.readFromBuffer(buf);
            while (child != null) {
                node.lastChild.next = child;
                node.lastChild = child;
                child = LazyNode.readFromBuffer(buf);
            }
        } else if (type == 2) {
            LazyNode child;
            node.child = child = LazyNode.readFromBuffer(buf);
            node.lastChild = child;
        }
        return node;
    }

    protected void writeToBuffer(ByteBuffer buf) {
        buf.put(this.type);
        buf.putInt(this.startIndex);
        buf.putInt(this.endIndex);
        if (this.type == 0 || this.type == 1) {
            LazyNode n = this.child;
            while (n != null) {
                n.writeToBuffer(buf);
                n = n.next;
            }
            buf.put((byte)11);
        } else if (this.type == 2) {
            this.child.writeToBuffer(buf);
        }
    }

    protected int getBufferSize() {
        int size = 9;
        if (this.type == 0 || this.type == 1) {
            LazyNode n = this.child;
            while (n != null) {
                size += n.getBufferSize();
                n = n.next;
            }
            ++size;
        } else if (this.type == 2) {
            size += this.child.getBufferSize();
        }
        return size;
    }

    private final class StringIterator
    implements Iterator<String> {
        private LazyNode next;

        protected StringIterator(LazyNode token) {
            this.next = token.child;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Can't remove from token");
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.hasNext()) {
                String value = this.next.getStringValue();
                this.next = this.next.next;
                return value;
            }
            throw new NoSuchElementException();
        }
    }
}

