/*
 * Decompiled with CFR 0.152.
 */
package me.doubledutch.lazyjson;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import me.doubledutch.lazyjson.LazyArray;
import me.doubledutch.lazyjson.LazyException;
import me.doubledutch.lazyjson.LazyNode;
import me.doubledutch.lazyjson.LazyObject;
import me.doubledutch.lazyjson.LazyType;
import me.doubledutch.lazyjson.compressor.DictionaryCache;
import me.doubledutch.lazyjson.compressor.Template;

public abstract class LazyElement {
    protected LazyNode root;
    protected LazyElement parent;
    private int length = -1;

    protected LazyElement(LazyNode root) {
        this.root = root;
    }

    protected LazyElement() throws LazyException {
    }

    protected LazyNode appendAndSetDirtyString(byte type, String value) throws LazyException {
        StringBuilder dirtyBuf = this.root.getDirtyBuf();
        LazyNode child = new LazyNode(type, dirtyBuf.length());
        dirtyBuf.append(value);
        child.endIndex = dirtyBuf.length();
        child.dirty = true;
        child.dirtyBuf = dirtyBuf;
        return child;
    }

    public Template extractTemplate() {
        Template t = new Template();
        this.root.addSegments(t);
        t.compact();
        return t;
    }

    public abstract LazyType getType();

    public void writeTemplateValues(ByteBuffer buf, DictionaryCache dict) throws BufferOverflowException {
        this.root.writeSegmentValues(buf, dict);
    }

    public static LazyElement parse(String str) throws LazyException {
        for (int index = 0; index < str.length(); ++index) {
            char ch = str.charAt(index);
            if (ch == '[') {
                return new LazyArray(str);
            }
            if (ch != '{') continue;
            return new LazyObject(str);
        }
        throw new LazyException("The given string is not a JSON object or array");
    }

    protected static boolean shouldQuoteString(String str) {
        if (str == null) {
            return false;
        }
        boolean found = false;
        int length = str.length();
        char[] cbuf = new char[length];
        str.getChars(0, length, cbuf, 0);
        for (int i = 0; i < length; ++i) {
            char c = cbuf[i];
            if (c != '\\' && c != '\"' && c != '\b' && c != '\t' && c != '\n' && c != '\f' && c != '\r') continue;
            found = true;
        }
        return found;
    }

    protected static String quoteString(String str) {
        StringBuffer buf = new StringBuffer();
        int length = str.length();
        char[] cbuf = new char[length];
        str.getChars(0, length, cbuf, 0);
        block9: for (int i = 0; i < length; ++i) {
            char c = cbuf[i];
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append(c);
                    continue block9;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static LazyElement readFromTemplate(Template t, ByteBuffer buf, DictionaryCache dict) throws LazyException {
        String str = t.read(buf, dict);
        return LazyElement.parse(str);
    }

    public int length() {
        if (this.root.child == null) {
            return 0;
        }
        if (this.length > -1) {
            return this.length;
        }
        this.length = this.root.getChildCount();
        return this.length;
    }

    protected abstract String serializeElementToString();

    public String toString() {
        if (this.root.isDirty()) {
            return this.serializeElementToString();
        }
        return new String(this.root.cbuf, this.root.startIndex, this.root.endIndex - this.root.startIndex);
    }

    public int getSourceLength() {
        return this.root.endIndex - this.root.startIndex;
    }

    public byte[] toByteArray() {
        int size = this.root.getBufferSize();
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.root.writeToBuffer(buf);
        return buf.array();
    }

    public abstract int hashCode();

    private boolean equalObjects(LazyObject o1, LazyObject o2) {
        if (o1.length() != o2.length()) {
            return false;
        }
        for (String key : o1.keySet()) {
            if (!o2.has(key)) {
                return false;
            }
            LazyType t1 = o1.getType(key);
            if (t1 != o2.getType(key)) {
                return false;
            }
            switch (t1) {
                case STRING: {
                    if (o1.getString(key).equals(o2.getString(key))) break;
                    return false;
                }
                case INTEGER: {
                    if (o1.getLong(key) == o2.getLong(key)) break;
                    return false;
                }
                case FLOAT: {
                    if (o1.getDouble(key) == o2.getDouble(key)) break;
                    return false;
                }
                case BOOLEAN: {
                    if (o1.getBoolean(key) == o2.getBoolean(key)) break;
                    return false;
                }
                case OBJECT: {
                    if (o1.getJSONObject(key).equals(o2.getJSONObject(key))) break;
                    return false;
                }
                case ARRAY: {
                    if (o1.getJSONArray(key).equals(o2.getJSONArray(key))) break;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean equalArrays(LazyArray a1, LazyArray a2) {
        if (a1.length() != a2.length()) {
            return false;
        }
        block8: for (int i = 0; i < this.length(); ++i) {
            LazyType t1 = a1.getType(i);
            if (t1 != a2.getType(i)) {
                return false;
            }
            switch (t1) {
                case STRING: {
                    if (a1.getString(i).equals(a2.getString(i))) continue block8;
                    return false;
                }
                case INTEGER: {
                    if (a1.getLong(i) == a2.getLong(i)) continue block8;
                    return false;
                }
                case FLOAT: {
                    if (a1.getDouble(i) == a2.getDouble(i)) continue block8;
                    return false;
                }
                case BOOLEAN: {
                    if (a1.getBoolean(i) == a2.getBoolean(i)) continue block8;
                    return false;
                }
                case OBJECT: {
                    if (a1.getJSONObject(i).equals(a2.getJSONObject(i))) continue block8;
                    return false;
                }
                case ARRAY: {
                    if (a1.getJSONArray(i).equals(a2.getJSONArray(i))) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LazyElement)) {
            return false;
        }
        LazyElement el = (LazyElement)obj;
        if (el.getType() != this.getType()) {
            return false;
        }
        if (this.getType() == LazyType.OBJECT) {
            return this.equalObjects((LazyObject)this, (LazyObject)el);
        }
        return this.equalArrays((LazyArray)this, (LazyArray)el);
    }
}

