/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.utils;

import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import android.view.ViewGroup;
import me.dkzwm.widget.srl.ILifecycleObserver;
import me.dkzwm.widget.srl.SmoothRefreshLayout;
import me.dkzwm.widget.srl.extra.IRefreshView;
import me.dkzwm.widget.srl.utils.ScrollCompat;

public class QuickConfigAppBarUtil
implements ILifecycleObserver,
AppBarLayout.OnOffsetChangedListener,
SmoothRefreshLayout.OnHeaderEdgeDetectCallBack,
SmoothRefreshLayout.OnFooterEdgeDetectCallBack {
    private int mMinOffset;
    private int mOffset = -1;
    private boolean mFullyExpanded;
    private SmoothRefreshLayout mRefreshLayout;

    public void onAttached(SmoothRefreshLayout layout) {
        this.mRefreshLayout = layout;
        CoordinatorLayout coordinatorLayout = this.findCoordinatorLayout((ViewGroup)layout);
        if (coordinatorLayout == null) {
            return;
        }
        AppBarLayout appBarLayout = this.findAppBarLayout((ViewGroup)coordinatorLayout);
        if (appBarLayout == null) {
            return;
        }
        appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
        layout.setOnHeaderEdgeDetectCallBack((SmoothRefreshLayout.OnHeaderEdgeDetectCallBack)this);
        layout.setOnFooterEdgeDetectCallBack((SmoothRefreshLayout.OnFooterEdgeDetectCallBack)this);
    }

    public void onDetached(SmoothRefreshLayout layout) {
        layout.setOnFooterEdgeDetectCallBack(null);
        layout.setOnHeaderEdgeDetectCallBack(null);
        this.mRefreshLayout = null;
        CoordinatorLayout coordinatorLayout = this.findCoordinatorLayout((ViewGroup)layout);
        if (coordinatorLayout == null) {
            return;
        }
        AppBarLayout appBarLayout = this.findAppBarLayout((ViewGroup)coordinatorLayout);
        if (appBarLayout == null) {
            return;
        }
        appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this);
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        this.mOffset = verticalOffset;
        this.mFullyExpanded = appBarLayout.getHeight() - appBarLayout.getBottom() == 0;
        this.mMinOffset = Math.min(this.mOffset, this.mMinOffset);
    }

    private CoordinatorLayout findCoordinatorLayout(ViewGroup group) {
        CoordinatorLayout layout = null;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!(group.getChildAt(i) instanceof CoordinatorLayout)) continue;
            layout = (CoordinatorLayout)group.getChildAt(i);
            break;
        }
        return layout;
    }

    private AppBarLayout findAppBarLayout(ViewGroup group) {
        AppBarLayout layout = null;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!(group.getChildAt(i) instanceof AppBarLayout)) continue;
            layout = (AppBarLayout)group.getChildAt(i);
            break;
        }
        return layout;
    }

    public boolean isNotYetInEdgeCannotMoveHeader(SmoothRefreshLayout parent, @Nullable View child, @Nullable IRefreshView header) {
        View targetView = parent.getScrollTargetView();
        if (targetView == null) {
            targetView = child;
        }
        return !this.mFullyExpanded || ScrollCompat.canChildScrollUp((View)targetView);
    }

    public boolean isNotYetInEdgeCannotMoveFooter(SmoothRefreshLayout parent, @Nullable View child, @Nullable IRefreshView footer) {
        View targetView = parent.getScrollTargetView();
        if (targetView == null) {
            targetView = child;
        }
        return this.mMinOffset != this.mOffset || ScrollCompat.canChildScrollDown((View)targetView);
    }
}

