/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.srl.extra;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import me.dkzwm.widget.srl.ext.classic.R;
import me.dkzwm.widget.srl.utils.PixelUtl;

public class ClassicConfig {
    private static final String SP_NAME = "sr_classic_last_update_time";
    private static final SimpleDateFormat sDataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    private ClassicConfig() {
    }

    public static void updateTime(@NonNull Context context, String key, long time) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SP_NAME, 0);
        if (!TextUtils.isEmpty((CharSequence)key)) {
            sharedPreferences.edit().putLong(key, time).apply();
        }
    }

    static String getLastUpdateTime(@NonNull Context context, long mLastUpdateTime, @NonNull String key) {
        if (mLastUpdateTime == -1L && !TextUtils.isEmpty((CharSequence)key)) {
            mLastUpdateTime = context.getSharedPreferences(SP_NAME, 0).getLong(key, -1L);
        }
        if (mLastUpdateTime == -1L) {
            return null;
        }
        long diffTime = new Date().getTime() - mLastUpdateTime;
        int seconds = (int)(diffTime / 1000L);
        if (diffTime < 0L) {
            return null;
        }
        if (seconds <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(context.getString(R.string.sr_last_update));
        if (seconds < 60) {
            sb.append(seconds);
            sb.append(context.getString(R.string.sr_seconds_ago));
        } else {
            int minutes = seconds / 60;
            if (minutes > 60) {
                int hours = minutes / 60;
                if (hours > 24) {
                    Date date = new Date(mLastUpdateTime);
                    sb.append(sDataFormat.format(date));
                } else {
                    sb.append(hours);
                    sb.append(context.getString(R.string.sr_hours_ago));
                }
            } else {
                sb.append(minutes);
                sb.append(context.getString(R.string.sr_minutes_ago));
            }
        }
        return sb.toString();
    }

    static void createClassicViews(RelativeLayout layout) {
        TextView textViewTitle = new TextView(layout.getContext());
        textViewTitle.setId(R.id.sr_classic_title);
        textViewTitle.setTextSize(12.0f);
        textViewTitle.setTextColor(Color.parseColor((String)"#333333"));
        TextView textViewLastUpdate = new TextView(layout.getContext());
        textViewLastUpdate.setId(R.id.sr_classic_last_update);
        textViewLastUpdate.setTextSize(10.0f);
        textViewLastUpdate.setTextColor(Color.parseColor((String)"#969696"));
        textViewLastUpdate.setVisibility(8);
        LinearLayout textContainer = new LinearLayout(layout.getContext());
        textContainer.setOrientation(1);
        textContainer.setGravity(1);
        textContainer.setId(R.id.sr_classic_text_container);
        LinearLayout.LayoutParams textViewTitleLP = new LinearLayout.LayoutParams(-2, -2);
        textContainer.addView((View)textViewTitle, (ViewGroup.LayoutParams)textViewTitleLP);
        LinearLayout.LayoutParams textViewLastUpdateLP = new LinearLayout.LayoutParams(-2, -2);
        textContainer.addView((View)textViewLastUpdate, (ViewGroup.LayoutParams)textViewLastUpdateLP);
        RelativeLayout.LayoutParams textContainerLP = new RelativeLayout.LayoutParams(-2, -2);
        textContainerLP.addRule(13);
        layout.addView((View)textContainer, (ViewGroup.LayoutParams)textContainerLP);
        ImageView imageViewArrow = new ImageView(layout.getContext());
        imageViewArrow.setId(R.id.sr_classic_arrow);
        RelativeLayout.LayoutParams imageViewArrowLP = new RelativeLayout.LayoutParams(-2, -2);
        int dp6 = PixelUtl.dp2px((Context)layout.getContext(), (float)6.0f);
        imageViewArrowLP.setMargins(dp6, dp6, dp6, dp6);
        imageViewArrowLP.addRule(0, R.id.sr_classic_text_container);
        imageViewArrowLP.addRule(15);
        layout.addView((View)imageViewArrow, (ViewGroup.LayoutParams)imageViewArrowLP);
        ProgressBar progressBar = new ProgressBar(layout.getContext(), null, 16843400);
        progressBar.setId(R.id.sr_classic_progress);
        RelativeLayout.LayoutParams progressBarLP = new RelativeLayout.LayoutParams(-2, -2);
        progressBarLP.setMargins(dp6, dp6, dp6, dp6);
        progressBarLP.addRule(0, R.id.sr_classic_text_container);
        progressBarLP.addRule(15);
        layout.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarLP);
    }
}

