/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.expiration;

import java.io.IOException;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ExpirationRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method) || HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadUri = servletResponse.getHeader("Location");
        if (StringUtils.isBlank((CharSequence)uploadUri)) {
            uploadUri = servletRequest.getRequestURI();
        }
        Long expirationPeriod = uploadStorageService.getUploadExpirationPeriod();
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
        if (expirationPeriod != null && expirationPeriod > 0L && uploadInfo != null) {
            uploadInfo.updateExpiration(expirationPeriod);
            uploadStorageService.update(uploadInfo);
            servletResponse.setDateHeader("Upload-Expires", uploadInfo.getExpirationTimestamp());
        }
    }

    @Override
    public boolean isErrorHandler() {
        return true;
    }
}

