/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.concatenation;

import java.io.IOException;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadInfo;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.upload.UploadType;
import me.desair.tus.server.util.AbstractRequestHandler;
import me.desair.tus.server.util.TusServletRequest;
import me.desair.tus.server.util.TusServletResponse;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class ConcatenationPostRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadUri = servletResponse.getHeader("Location");
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
        if (uploadInfo != null) {
            String uploadConcatValue = servletRequest.getHeader("Upload-Concat");
            if (StringUtils.equalsIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"partial")) {
                uploadInfo.setUploadType(UploadType.PARTIAL);
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final")) {
                uploadInfo.setLength(null);
                uploadInfo.setUploadType(UploadType.CONCATENATED);
                uploadInfo.setConcatenationPartIds(Utils.parseConcatenationIDsFromHeader(uploadConcatValue));
                uploadStorageService.getUploadConcatenationService().merge(uploadInfo);
            } else {
                uploadInfo.setUploadType(UploadType.REGULAR);
            }
            uploadInfo.setUploadConcatHeaderValue(uploadConcatValue);
            uploadStorageService.update(uploadInfo);
        }
    }
}

