/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.creation.validation;

import javax.servlet.http.HttpServletRequest;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.exception.InvalidUploadLengthException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import me.desair.tus.server.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class UploadDeferLengthValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        String uploadConcatValue;
        boolean uploadLength = false;
        boolean deferredLength = false;
        boolean concatenatedUpload = false;
        if (StringUtils.isNumeric((CharSequence)Utils.getHeader(request, "Upload-Length"))) {
            uploadLength = true;
        }
        if (Utils.getHeader(request, "Upload-Defer-Length").equals("1")) {
            deferredLength = true;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)(uploadConcatValue = request.getHeader("Upload-Concat")), (CharSequence)"final")) {
            concatenatedUpload = true;
        }
        if (!(concatenatedUpload || uploadLength || deferredLength)) {
            throw new InvalidUploadLengthException("No valid value was found in headers Upload-Length and Upload-Defer-Length");
        }
        if (uploadLength && deferredLength) {
            throw new InvalidUploadLengthException("A POST request cannot contain both Upload-Length and Upload-Defer-Length headers.");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

