/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments;

import org.simpleyaml.configuration.comments.CommentType;
import org.simpleyaml.configuration.comments.Commentable;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.file.YamlConfigurationOptions;

public class YamlCommentMapper
implements Commentable {
    public static final String COMMENT_PREFIX = "# ";
    protected KeyTree keyTree;

    public YamlCommentMapper(YamlConfigurationOptions options) {
        this.keyTree = new KeyTree(options);
    }

    @Override
    public void setComment(String path, String comment, CommentType type) {
        KeyTree.Node node = this.getNode(path);
        if (node == null) {
            node = this.keyTree.add(path);
        }
        if (comment == null || comment.isEmpty()) {
            this.setComment(node, null, type);
        } else if (comment.matches("\n+")) {
            this.setComment(node, comment, type);
        } else {
            comment = COMMENT_PREFIX + comment;
            comment = comment.replaceAll("[ \\t]*\n", "\n# ");
            if (type == CommentType.BLOCK) {
                node.setComment(this.indent(comment, node.getIndentation()));
            } else {
                node.setSideComment(" " + comment);
            }
        }
    }

    @Override
    public String getComment(String path, CommentType type) {
        String comment;
        KeyTree.Node node = this.getNode(path);
        if (node == null) {
            return null;
        }
        String string = comment = type == CommentType.BLOCK ? node.getComment() : node.getSideComment();
        if (comment != null) {
            comment = comment.replaceAll("[ \\t]*#+[ \\t]*", "").trim();
        }
        return comment;
    }

    protected KeyTree.Node getNode(String path) {
        return this.keyTree.get(path);
    }

    private void setComment(KeyTree.Node node, String comment, CommentType type) {
        if (type == CommentType.BLOCK) {
            node.setComment(comment);
        } else {
            node.setSideComment(comment);
        }
    }

    private String indent(String s, int n) {
        String padding = this.padding(n);
        String[] lines = s.split("\n");
        StringBuilder builder = new StringBuilder(s.length() + n * lines.length);
        for (String line : lines) {
            builder.append(padding).append(line).append('\n');
        }
        return builder.toString();
    }

    private String padding(int n) {
        StringBuilder builder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            builder.append(' ');
        }
        return builder.toString();
    }
}

