/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments;

import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.comments.YamlCommentMapper;
import org.simpleyaml.configuration.comments.YamlCommentReader;
import org.simpleyaml.configuration.file.YamlConfigurationOptions;

public class YamlCommentDumper
extends YamlCommentReader {
    private final YamlCommentMapper yamlCommentMapper;
    private StringBuilder builder;

    public YamlCommentDumper(YamlConfigurationOptions options, YamlCommentMapper yamlCommentMapper, Reader reader) {
        super(options, reader);
        this.yamlCommentMapper = yamlCommentMapper;
    }

    public String dump() throws IOException {
        if (this.yamlCommentMapper == null) {
            return this.reader.lines().collect(Collectors.joining("\n"));
        }
        this.builder = new StringBuilder();
        while (this.nextLine()) {
            if (this.isComment()) continue;
            String path = this.track().getPath();
            KeyTree.Node node = this.getNode(path);
            this.append(node, KeyTree.Node::getComment);
            this.builder.append(this.currentLine);
            this.append(node, KeyTree.Node::getSideComment);
            this.builder.append('\n');
        }
        this.append(this.getNode(null), KeyTree.Node::getComment);
        this.reader.close();
        return this.builder.toString();
    }

    @Override
    protected KeyTree.Node getNode(String path) {
        return this.yamlCommentMapper.getNode(path);
    }

    private void append(KeyTree.Node node, Function<KeyTree.Node, String> getter) {
        String s;
        if (node != null && (s = getter.apply(node)) != null) {
            this.builder.append(s);
        }
    }
}

