package ltd.dolink.arch.adapter;


import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView.Adapter;
import androidx.viewbinding.ViewBinding;

import java.util.List;
import java.util.Objects;

import ltd.dolink.arch.Effect;
import ltd.dolink.arch.Intent;

public abstract class CellAdapter extends Adapter<CellViewHolder<CellState, Effect, Intent, ViewBinding>> {
    @NonNull
    private final CellBinder cellBinder;

    protected CellAdapter() {
        this.cellBinder = initializeCellBinder();
        Objects.requireNonNull(cellBinder);
    }

    @NonNull
    public CellBinder getCellBinder() {
        return cellBinder;
    }

    protected abstract CellBinder initializeCellBinder();

    @Override
    public int getItemCount() {
        return cellBinder.getItemCount();
    }

    public CellState getItem(int position) {
        return cellBinder.getItem(position);
    }

    @Override
    public int getItemViewType(int position) {
        return getItem(position).getStateType();
    }

    @NonNull
    @Override
    public CellViewHolder<CellState, Effect, Intent, ViewBinding> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        CellViewHolder<CellState, Effect, Intent, ViewBinding> viewHolder = cellBinder.createViewHolder(parent, viewType);
        viewHolder.setAdapter(this);
        return viewHolder;
    }

    @Override
    public void onViewAttachedToWindow(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewAttachedToWindow();
    }

    @Override
    public void onViewDetachedFromWindow(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewDetachedFromWindow();
    }

    @Override
    public void onViewRecycled(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        holder.onViewRecycled();
    }


    @Override
    public boolean onFailedToRecycleView(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder) {
        return holder.onFailedToRecycleView();
    }

    @Override
    public void onBindViewHolder(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder, int position) {
        holder.setState(getItem(position));
    }

    @Override
    public void onBindViewHolder(@NonNull CellViewHolder<CellState, Effect, Intent, ViewBinding> holder, int position, @NonNull List<Object> payloads) {
        holder.setState(getItem(position), payloads);
    }

}
