/*
 * Decompiled with CFR 0.152.
 */
package ltd.dolink.arch.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewbinding.ViewBinding;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ltd.dolink.arch.adapter.CellState;
import ltd.dolink.arch.adapter.CellViewHolder;
import ltd.dolink.arch.viewbinding.ViewBindingFactory;

public abstract class CellBinder {
    private final Map<Integer, ViewHolderFactoryBoundViewBinding> mapper = new HashMap<Integer, ViewHolderFactoryBoundViewBinding>();

    public abstract CellState getItem(int var1);

    public abstract int getItemCount();

    public <VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull Class<VB> viewBindingClass, @NonNull Class<VH> viewHolderClass) {
        Objects.requireNonNull(stateClass);
        Objects.requireNonNull(viewBindingClass);
        Objects.requireNonNull(viewHolderClass);
        this.link(cellType, stateClass, ViewBindingFactory.of(viewBindingClass), new CellViewHolder.DefaultFactory(viewHolderClass));
    }

    public <VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull Class<VB> viewBindingClass, @NonNull CellViewHolder.Factory<VB, STATE, VH> viewHolderFactory) {
        Objects.requireNonNull(stateClass);
        Objects.requireNonNull(viewBindingClass);
        Objects.requireNonNull(viewHolderFactory);
        this.link(cellType, stateClass, ViewBindingFactory.of(viewBindingClass), viewHolderFactory);
    }

    public <VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull ViewBindingFactory<VB> viewBindingFactory, @NonNull Class<VH> viewHolderClass) {
        Objects.requireNonNull(stateClass);
        Objects.requireNonNull(viewBindingFactory);
        Objects.requireNonNull(viewHolderClass);
        this.link(cellType, stateClass, viewBindingFactory, new CellViewHolder.DefaultFactory(viewHolderClass));
    }

    public <VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> void link(int cellType, @NonNull Class<STATE> stateClass, @NonNull ViewBindingFactory<VB> viewBindingFactory, @NonNull CellViewHolder.Factory<VB, STATE, VH> viewHolderFactory) {
        Objects.requireNonNull(stateClass);
        Objects.requireNonNull(viewBindingFactory);
        Objects.requireNonNull(viewHolderFactory);
        this.mapper.put(cellType, new ViewHolderFactoryBoundViewBinding<VB, STATE, VH>(viewBindingFactory, viewHolderFactory));
    }

    protected <VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>> VH createViewHolder(@NonNull ViewGroup parent, int cellType) {
        Objects.requireNonNull(parent);
        ViewHolderFactoryBoundViewBinding viewHolderFactory = this.mapper.get(cellType);
        ViewBinding viewBinding = viewHolderFactory.viewBindingFactory.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        return viewHolderFactory.create(viewBinding);
    }

    class ViewHolderFactoryBoundViewBinding<VB extends ViewBinding, STATE extends CellState, VH extends CellViewHolder<VB, STATE>>
    implements CellViewHolder.Factory<VB, STATE, VH> {
        private final ViewBindingFactory<VB> viewBindingFactory;
        private final CellViewHolder.Factory<VB, STATE, VH> viewHolderFactory;

        ViewHolderFactoryBoundViewBinding(@NonNull ViewBindingFactory<VB> viewBindingFactory, CellViewHolder.Factory<VB, STATE, VH> viewHolderFactory) {
            Objects.requireNonNull(viewBindingFactory);
            Objects.requireNonNull(viewHolderFactory);
            this.viewBindingFactory = viewBindingFactory;
            this.viewHolderFactory = viewHolderFactory;
        }

        @Override
        public VH create(@NonNull VB viewBinding) {
            return this.viewHolderFactory.create(viewBinding);
        }
    }

    public static class ArrayBinder<STATE extends CellState>
    extends CellBinder {
        @NonNull
        private final STATE[] data;

        public ArrayBinder(@NonNull STATE[] data) {
            Objects.requireNonNull(data);
            this.data = data;
        }

        @NonNull
        public STATE[] getData() {
            return this.data;
        }

        public STATE getItem(int position) {
            return this.data[position];
        }

        @Override
        public int getItemCount() {
            return this.data.length;
        }
    }

    public static class ListCellBinder<STATE extends CellState>
    extends CellBinder {
        @NonNull
        private final List<STATE> data;

        public ListCellBinder(@NonNull List<STATE> data) {
            Objects.requireNonNull(data);
            this.data = data;
        }

        @NonNull
        public List<STATE> getData() {
            return this.data;
        }

        public STATE getItem(int position) {
            return (STATE)((CellState)this.data.get(position));
        }

        @Override
        public int getItemCount() {
            return this.data.size();
        }
    }
}

