/*
 * Decompiled with CFR 0.152.
 */
package lt.neworld.spanner;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.style.DrawableMarginSpan;
import android.text.style.IconMarginSpan;
import android.text.style.ParagraphStyle;
import kotlin.Metadata;
import lt.neworld.spanner.SpanBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\f"}, d2={"Llt/neworld/spanner/ImageSpanBuilder;", "Llt/neworld/spanner/SpanBuilder;", "drawable", "Landroid/graphics/drawable/Drawable;", "bitmap", "Landroid/graphics/Bitmap;", "pad", "", "(Landroid/graphics/drawable/Drawable;Landroid/graphics/Bitmap;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "build", "", "lib_release"})
public final class ImageSpanBuilder
implements SpanBuilder {
    private final Drawable drawable;
    private final Bitmap bitmap;
    private final Integer pad;

    @Override
    @NotNull
    public Object build() {
        ParagraphStyle paragraphStyle;
        if (this.drawable != null && this.pad != null) {
            paragraphStyle = (ParagraphStyle)new DrawableMarginSpan(this.drawable, this.pad.intValue());
        } else if (this.drawable != null) {
            paragraphStyle = (ParagraphStyle)new DrawableMarginSpan(this.drawable);
        } else {
            IconMarginSpan iconMarginSpan;
            if (this.bitmap != null && this.pad != null) {
                iconMarginSpan = new IconMarginSpan(this.bitmap, this.pad.intValue());
            } else if (this.bitmap != null) {
                iconMarginSpan = new IconMarginSpan(this.bitmap);
            } else {
                throw (Throwable)new RuntimeException("drawable or bitmap must be not null");
            }
            paragraphStyle = (ParagraphStyle)iconMarginSpan;
        }
        return paragraphStyle;
    }

    public ImageSpanBuilder(@Nullable Drawable drawable, @Nullable Bitmap bitmap, @Nullable Integer pad) {
        this.drawable = drawable;
        this.bitmap = bitmap;
        this.pad = pad;
    }
}

