/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simboot;

import java.util.List;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import love.forte.simboot.SimbootEntrance;
import love.forte.simbot.SimbotIllegalStateException;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"loadEntranceInstance", "Llove/forte/simboot/SimbootEntrance;", "loadEntranceInstanceByServiceLoader", "loadEntranceInstanceSpecified", "specifiedPath", "", "simboot-api"})
public final class SimbootAppKt {
    private static final SimbootEntrance loadEntranceInstance() {
        String specified = System.getProperty("simboot.entrance");
        return specified != null ? SimbootAppKt.loadEntranceInstanceSpecified(specified) : SimbootAppKt.loadEntranceInstanceByServiceLoader();
    }

    private static final SimbootEntrance loadEntranceInstanceSpecified(String specifiedPath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader loader = classLoader;
        Class<?> loadedClass = loader.loadClass(specifiedPath);
        Object obj = loadedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type love.forte.simboot.SimbootEntrance");
        }
        return (SimbootEntrance)obj;
    }

    private static final SimbootEntrance loadEntranceInstanceByServiceLoader() {
        ServiceLoader<SimbootEntrance> serviceLoader = ServiceLoader.load(SimbootEntrance.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"serviceLoader");
        List list2 = CollectionsKt.toList((Iterable)serviceLoader);
        if (list2.isEmpty()) {
            String message = "No service was found.\n\nPlease check if there is at least one META-INF/services/love.forte.simboot.SimBootEntrance file in classPath,\nOr use the -Dsimboot.entrance to specify a specific simboot entrance service.\n";
            throw new SimbotIllegalStateException(message);
        }
        if (list2.size() > 1) {
            StringBuilder stringBuilder;
            StringBuilder $this$loadEntranceInstanceByServiceLoader_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$loadEntranceInstanceByServiceLoader_u24lambda_u2d0.append("There is more than one entrance service instance\n\n");
            $this$loadEntranceInstanceByServiceLoader_u24lambda_u2d0.append("These services are: \n");
            for (SimbootEntrance instance : list2) {
                $this$loadEntranceInstanceByServiceLoader_u24lambda_u2d0.append("\t-\t").append(instance.getClass().getName()).append("\n");
            }
            $this$loadEntranceInstanceByServiceLoader_u24lambda_u2d0.append("Please use -Dsimboot.entrance to specify a simboot entrance service");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String message = string;
            throw new SimbotIllegalStateException(message);
        }
        Object object = CollectionsKt.first((List)list2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list.first()");
        return (SimbootEntrance)object;
    }

    public static final /* synthetic */ SimbootEntrance access$loadEntranceInstance() {
        return SimbootAppKt.loadEntranceInstance();
    }
}

