/*
 * Decompiled with CFR 0.152.
 */
package hms.webrtc;

import androidx.annotation.Nullable;
import hms.webrtc.Logging;
import hms.webrtc.VideoCodecInfo;
import hms.webrtc.VideoDecoder;
import hms.webrtc.VideoDecoderFactory;
import hms.webrtc.WrappedNativeVideoDecoder;
import java.util.List;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "SoftwareVideoDecoderFactory";
    private final long nativeFactory = SoftwareVideoDecoderFactory.nativeCreateFactory();

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo info) {
        final long nativeDecoder = SoftwareVideoDecoderFactory.nativeCreateDecoder(this.nativeFactory, info);
        if (nativeDecoder == 0L) {
            Logging.w(TAG, "Trying to create decoder for unsupported format. " + info);
            return null;
        }
        return new WrappedNativeVideoDecoder(){

            @Override
            public long createNativeVideoDecoder() {
                return nativeDecoder;
            }
        };
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.nativeGetSupportedCodecs(this.nativeFactory).toArray(new VideoCodecInfo[0]);
    }

    private static native long nativeCreateFactory();

    private static native long nativeCreateDecoder(long var0, VideoCodecInfo var2);

    private static native List<VideoCodecInfo> nativeGetSupportedCodecs(long var0);
}

