/*
 * Decompiled with CFR 0.152.
 */
package hms.webrtc;

import androidx.annotation.Nullable;
import hms.webrtc.SimulcastVideoEncoder;
import hms.webrtc.VideoCodecInfo;
import hms.webrtc.VideoEncoder;
import hms.webrtc.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.Arrays;

public class SimulcastVideoEncoderFactory
implements VideoEncoderFactory {
    VideoEncoderFactory primary;
    VideoEncoderFactory fallback;

    public SimulcastVideoEncoderFactory(VideoEncoderFactory primary, VideoEncoderFactory fallback) {
        this.primary = primary;
        this.fallback = fallback;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        return new SimulcastVideoEncoder(this.primary, this.fallback, info);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.addAll(Arrays.asList(this.primary.getSupportedCodecs()));
        if (this.fallback != null) {
            codecs.addAll(Arrays.asList(this.fallback.getSupportedCodecs()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

