/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.video.utils.matrix;

import android.graphics.Matrix;
import android.graphics.PointF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import live.hms.videoview.ZoomPanManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u0017H\u0002J,\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0002J\u001d\u0010'\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Llive/hms/video/video/utils/matrix/MatrixManager;", "", "zoomPanManager", "Llive/hms/videoview/ZoomPanManager;", "callback", "Llive/hms/video/video/utils/matrix/MatrixManager$Callback;", "<init>", "(Llive/hms/videoview/ZoomPanManager;Llive/hms/video/video/utils/matrix/MatrixManager$Callback;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "containerWidth", "", "containerHeight", "scaleMatrix", "Landroid/graphics/Matrix;", "outputMatrix", "boundaryFixMatrix", "totalWidth", "value", "", "setContainerSize", "", "width", "height", "forceReset", "", "setContainerSize$videoview_release", "limitToBoundary", "applyScaleWithLimit", "currentScale", "scaleFactor", "maxZoom", "minZoom", "applyScale", "currentFocusPoint", "Landroid/graphics/PointF;", "scaleMultiplier", "onZoom", "onZoom$videoview_release", "onPan", "distanceX", "distanceY", "onPan$videoview_release", "reset", "reset$videoview_release", "Callback", "videoview_release"})
public final class MatrixManager {
    @NotNull
    private final ZoomPanManager zoomPanManager;
    @NotNull
    private final Callback callback;
    @NotNull
    private final String TAG;
    private float containerWidth;
    private float containerHeight;
    @NotNull
    private final Matrix scaleMatrix;
    @NotNull
    private final Matrix outputMatrix;
    @NotNull
    private final Matrix boundaryFixMatrix;
    private final float totalWidth;
    @NotNull
    private final float[] value;

    public MatrixManager(@NotNull ZoomPanManager zoomPanManager2, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)zoomPanManager2, (String)"zoomPanManager");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.zoomPanManager = zoomPanManager2;
        this.callback = callback;
        this.TAG = "MatrixManager";
        this.scaleMatrix = new Matrix();
        this.outputMatrix = new Matrix();
        this.boundaryFixMatrix = new Matrix();
        this.totalWidth = 1.0f;
        this.value = new float[9];
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    public final void setContainerSize$videoview_release(float width, float height, boolean forceReset) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (!(width == this.containerWidth) || !(height == this.containerHeight) || forceReset) {
            this.containerWidth = width;
            this.containerHeight = height;
        }
    }

    private final void limitToBoundary() {
        float remainingUpperLimit;
        this.outputMatrix.getValues(this.value);
        float translateX = this.value[2];
        float translateY = this.value[5];
        float scale = 1.0f / this.value[0];
        this.boundaryFixMatrix.reset();
        boolean isFixRequired = false;
        if (translateX < 0.0f) {
            this.boundaryFixMatrix.postTranslate(-translateX, 0.0f);
            isFixRequired = true;
        }
        if (translateY < 0.0f) {
            this.boundaryFixMatrix.postTranslate(0.0f, -translateY);
            isFixRequired = true;
        }
        if (translateX > (remainingUpperLimit = this.totalWidth - this.totalWidth / scale)) {
            this.boundaryFixMatrix.postTranslate(-(translateX - remainingUpperLimit), 0.0f);
            isFixRequired = true;
        }
        if (translateY > remainingUpperLimit) {
            this.boundaryFixMatrix.postTranslate(0.0f, -(translateY - remainingUpperLimit));
            isFixRequired = true;
        }
        if (isFixRequired) {
            this.outputMatrix.postConcat(this.boundaryFixMatrix);
        }
        this.outputMatrix.getValues(this.value);
        this.callback.onMatrixUpdate(this.outputMatrix);
    }

    private final float applyScaleWithLimit(float currentScale, float scaleFactor, float maxZoom, float minZoom) {
        float factor = scaleFactor;
        if (currentScale * factor > maxZoom) {
            factor = maxZoom / currentScale;
        }
        if (currentScale * factor < minZoom) {
            factor = minZoom / currentScale;
        }
        return factor;
    }

    static /* synthetic */ float applyScaleWithLimit$default(MatrixManager matrixManager, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = matrixManager.zoomPanManager.getCurrentZoom$videoview_release();
        }
        if ((n & 8) != 0) {
            f4 = ZoomPanManager.Companion.getMIN_ZOOM();
        }
        return matrixManager.applyScaleWithLimit(f, f2, f3, f4);
    }

    private final void applyScale(PointF currentFocusPoint, float scaleMultiplier) {
        Matrix matrix;
        float openGlx = currentFocusPoint.x / this.containerWidth;
        float openGly = 1.0f - currentFocusPoint.y / this.containerHeight;
        this.outputMatrix.getValues(this.value);
        float currentScale = 1.0f / this.value[0];
        float newScale = MatrixManager.applyScaleWithLimit$default(this, currentScale, scaleMultiplier, 0.0f, 0.0f, 12, null);
        float transformedScale = 1.0f / newScale;
        Matrix $this$applyScale_u24lambda_u240 = matrix = this.scaleMatrix;
        boolean bl = false;
        $this$applyScale_u24lambda_u240.reset();
        $this$applyScale_u24lambda_u240.preTranslate(openGlx, openGly);
        $this$applyScale_u24lambda_u240.preScale(transformedScale, transformedScale);
        $this$applyScale_u24lambda_u240.preTranslate(-openGlx, -openGly);
        this.outputMatrix.preConcat(this.scaleMatrix);
        this.limitToBoundary();
    }

    public final void onZoom$videoview_release(@NotNull PointF currentFocusPoint, float scaleMultiplier) {
        Intrinsics.checkNotNullParameter((Object)currentFocusPoint, (String)"currentFocusPoint");
        if (this.containerWidth == 0.0f || this.containerHeight == 0.0f) {
            return;
        }
        this.applyScale(currentFocusPoint, scaleMultiplier);
    }

    public final void onPan$videoview_release(float distanceX, float distanceY) {
        if (this.containerWidth == 0.0f || this.containerHeight == 0.0f) {
            return;
        }
        float panYOpenGlBy = RangesKt.coerceIn((float)(distanceY / this.containerHeight), (float)-1.0f, (float)1.0f);
        float panXOpenGlBy = RangesKt.coerceIn((float)(distanceX / this.containerWidth), (float)-1.0f, (float)1.0f);
        this.outputMatrix.preTranslate(panXOpenGlBy, panYOpenGlBy);
        this.limitToBoundary();
    }

    public final void reset$videoview_release() {
        this.outputMatrix.reset();
        this.callback.onMatrixUpdate(this.outputMatrix);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Llive/hms/video/video/utils/matrix/MatrixManager$Callback;", "", "onMatrixUpdate", "", "matrix", "Landroid/graphics/Matrix;", "videoview_release"})
    public static interface Callback {
        public void onMatrixUpdate(@NotNull Matrix var1);
    }
}

