/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import hms.webrtc.EglRenderer;
import hms.webrtc.RendererCommon;
import hms.webrtc.SurfaceViewRenderer;
import hms.webrtc.VideoSink;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.HmsVideoFrameListener;
import live.hms.video.utils.SharedEglContext;
import live.hms.videoview.HMSVideoView;
import live.hms.videoview.VideoViewStateChangeListener;
import live.hms.videoview.ZoomPanManager;
import live.hms.videoview.common.VideoTrackManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u0004\u0018\u00010!J0\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0014J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0017J\u0006\u0010+\u001a\u00020\u001bJ\u0010\u0010,\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010.J&\u0010/\u001a\u00020\u001b2\u0014\u00100\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000102\u0012\u0004\u0012\u00020\u001b012\b\b\u0002\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u0017J\u0010\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\nH\u0016J\b\u00109\u001a\u00020\u001bH\u0014R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006:"}, d2={"Llive/hms/videoview/HMSVideoView;", "Lhms/webrtc/SurfaceViewRenderer;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentScalingType", "Lhms/webrtc/RendererCommon$ScalingType;", "videoTrackManager", "Llive/hms/videoview/common/VideoTrackManager;", "getVideoTrackManager", "()Llive/hms/videoview/common/VideoTrackManager;", "videoTrackManager$delegate", "Lkotlin/Lazy;", "zoomPanManager", "Llive/hms/videoview/ZoomPanManager;", "getZoomPanManager", "()Llive/hms/videoview/ZoomPanManager;", "zoomPanManager$delegate", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "onMeasure", "", "widthSpec", "", "heightSpec", "addTrack", "track", "Llive/hms/video/media/tracks/HMSVideoTrack;", "getTrack", "onLayout", "changed", "left", "top", "right", "bottom", "disableAutoSimulcastLayerSelect", "isDisabled", "removeTrack", "addVideoViewStateChangeListener", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "captureBitmap", "onBitmap", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "scale", "", "enableZoomAndPan", "isEnabled", "setScalingType", "scalingType", "onDetachedFromWindow", "videoview_release"})
public final class HMSVideoView
extends SurfaceViewRenderer {
    @Nullable
    private RendererCommon.ScalingType currentScalingType;
    @NotNull
    private final Lazy videoTrackManager$delegate;
    @NotNull
    private final Lazy zoomPanManager$delegate;

    public HMSVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.videoTrackManager$delegate = LazyKt.lazy(() -> HMSVideoView.videoTrackManager_delegate$lambda$4(this));
        this.zoomPanManager$delegate = LazyKt.lazy(() -> HMSVideoView.zoomPanManager_delegate$lambda$5(this));
    }

    public HMSVideoView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.videoTrackManager$delegate = LazyKt.lazy(() -> HMSVideoView.videoTrackManager_delegate$lambda$4(this));
        this.zoomPanManager$delegate = LazyKt.lazy(() -> HMSVideoView.zoomPanManager_delegate$lambda$5(this));
    }

    private final VideoTrackManager getVideoTrackManager() {
        Lazy lazy = this.videoTrackManager$delegate;
        return (VideoTrackManager)lazy.getValue();
    }

    private final ZoomPanManager getZoomPanManager() {
        Lazy lazy = this.zoomPanManager$delegate;
        return (ZoomPanManager)lazy.getValue();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.getZoomPanManager().shouldInterceptGesture$videoview_release(event) || super.onTouchEvent(event);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        super.onMeasure(widthSpec, heightSpec);
        this.getZoomPanManager().setContainerSize$videoview_release(this.getWidth(), this.getHeight());
    }

    public final void addTrack(@NotNull HMSVideoTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        if (track instanceof HMSRemoteVideoTrack) {
            Log.i((String)"HMSVIDEOVIEW", (String)("TRACK%%TRACK ADDED trackID: " + track.getTrackId() + " ssrc:" + ((HMSRemoteVideoTrack)track).getSsrc() + ' '));
        }
        VideoTrackManager.addTrack$default(this.getVideoTrackManager(), track, false, 2, null);
    }

    @Nullable
    public final HMSVideoTrack getTrack() {
        return this.getVideoTrackManager().getCurrentTrack();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.getVideoTrackManager().onSizeChanged$videoview_release(Math.abs(left - right), Math.abs(top - bottom));
    }

    public final void disableAutoSimulcastLayerSelect(boolean isDisabled) {
        this.getVideoTrackManager().disableAutoSimulcastLayerSelect$videoview_release(isDisabled);
    }

    public final void removeTrack() {
        HMSVideoTrack track = this.getTrack();
        if (track instanceof HMSRemoteVideoTrack) {
            Log.i((String)"HMSVIDEOVIEW", (String)("TRACK%%TRACK remove trackID: " + ((HMSRemoteVideoTrack)track).getTrackId() + " ssrc:" + ((HMSRemoteVideoTrack)track).getSsrc() + ' '));
        }
        this.getVideoTrackManager().removeTrack$videoview_release();
    }

    public final void addVideoViewStateChangeListener(@Nullable VideoViewStateChangeListener videoViewStateChangeListener) {
        this.getVideoTrackManager().setVideoViewStateChangeListener$videoview_release(videoViewStateChangeListener);
    }

    public final void captureBitmap(@NotNull Function1<? super Bitmap, Unit> onBitmap, float scale) {
        Intrinsics.checkNotNullParameter(onBitmap, (String)"onBitmap");
        HMSVideoTrack currentVideoTrack = this.getVideoTrackManager().getCurrentTrack();
        if (currentVideoTrack instanceof HMSLocalVideoTrack) {
            ((HMSLocalVideoTrack)currentVideoTrack).captureImageAtMaxPublishResolution(new HmsVideoFrameListener(onBitmap){
                final /* synthetic */ Function1<Bitmap, Unit> $onBitmap;
                {
                    this.$onBitmap = $onBitmap;
                }

                public void onFrameCaptured(Bitmap bitmap) {
                    Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                    this.$onBitmap.invoke((Object)bitmap);
                }
            });
        } else {
            this.addFrameListener(new EglRenderer.FrameListener(onBitmap, this){
                final /* synthetic */ Function1<Bitmap, Unit> $onBitmap;
                final /* synthetic */ HMSVideoView this$0;
                {
                    this.$onBitmap = $onBitmap;
                    this.this$0 = $receiver;
                }

                public void onFrame(Bitmap bitmap) {
                    this.$onBitmap.invoke((Object)bitmap);
                    new Handler(Looper.getMainLooper()).post(() -> captureBitmap.2.onFrame$lambda$0(this.this$0, this));
                }

                private static final void onFrame$lambda$0(HMSVideoView this$0, captureBitmap.2 this$1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                    this$0.removeFrameListener(this$1);
                }
            }, scale);
        }
    }

    public static /* synthetic */ void captureBitmap$default(HMSVideoView hMSVideoView, Function1 function1, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        hMSVideoView.captureBitmap((Function1<? super Bitmap, Unit>)function1, f);
    }

    public final void enableZoomAndPan(boolean isEnabled) {
        this.setFpsReduction(60.0f);
        this.getZoomPanManager().enableZoomAndPan$videoview_release(isEnabled);
    }

    public void setScalingType(@NotNull RendererCommon.ScalingType scalingType) {
        Intrinsics.checkNotNullParameter((Object)scalingType, (String)"scalingType");
        if (scalingType != this.currentScalingType) {
            super.setScalingType(scalingType);
            this.currentScalingType = scalingType;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeTrack();
    }

    private static final VideoSink videoTrackManager_delegate$lambda$4$lambda$0(HMSVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return (VideoSink)this$0;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$1(HMSVideoView this$0, RendererCommon.RendererEvents it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.init(SharedEglContext.INSTANCE.getContext(), it);
        return Unit.INSTANCE;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$2(HMSVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.release();
        return Unit.INSTANCE;
    }

    private static final Unit videoTrackManager_delegate$lambda$4$lambda$3(HMSVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.clearFrame();
        return Unit.INSTANCE;
    }

    private static final VideoTrackManager videoTrackManager_delegate$lambda$4(HMSVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return new VideoTrackManager(() -> HMSVideoView.videoTrackManager_delegate$lambda$4$lambda$0(this$0), arg_0 -> HMSVideoView.videoTrackManager_delegate$lambda$4$lambda$1(this$0, arg_0), () -> HMSVideoView.videoTrackManager_delegate$lambda$4$lambda$2(this$0), () -> HMSVideoView.videoTrackManager_delegate$lambda$4$lambda$3(this$0), false, 16, null);
    }

    private static final ZoomPanManager zoomPanManager_delegate$lambda$5(HMSVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return new ZoomPanManager(context, new ZoomPanManager.ZoomPanCallBack(this$0){
            final /* synthetic */ HMSVideoView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onMatrixUpdate(Matrix translationMatrix) {
                Intrinsics.checkNotNullParameter((Object)translationMatrix, (String)"translationMatrix");
                this.this$0.setTranslationMatrix(translationMatrix);
            }
        });
    }
}

