/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview.common;

import android.os.Handler;
import android.os.Looper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSSimulcastLayerDefinition;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.videoview.ResolutionChangeListener;
import live.hms.videoview.VideoViewStateChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RendererCommon;
import org.webrtc.VideoSink;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010#\u001a\u00020\u000bJ\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0015\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u0004\u0018\u00010\u0013J\b\u0010*\u001a\u00020\u0007H\u0016J \u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011H\u0016J\u001d\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020\u0007H\u0002J\b\u00106\u001a\u00020\u0007H\u0002J\u0017\u00107\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u001a\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u000bH\u0002J\u001e\u0010>\u001a\u0004\u0018\u00010;*\u00020?2\u0006\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020\u0011H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Llive/hms/videoview/common/VideoTrackManager;", "Lorg/webrtc/RendererCommon$RendererEvents;", "attachedVideoSink", "Lkotlin/Function0;", "Lorg/webrtc/VideoSink;", "initRenderer", "Lkotlin/Function1;", "", "releaseRenderer", "clearFrame", "enableAutoSimulcast", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Z)V", "getAttachedVideoSink", "()Lkotlin/jvm/functions/Function0;", "getClearFrame", "currentHeight", "", "currentTrack", "Llive/hms/video/media/tracks/HMSVideoTrack;", "currentWidth", "getEnableAutoSimulcast", "()Z", "getInitRenderer", "()Lkotlin/jvm/functions/Function1;", "isAutoSimulcastEnabled", "isInitialised", "pendingTrackUpdate", "getReleaseRenderer", "resolutionChangeListener", "Llive/hms/videoview/ResolutionChangeListener;", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "addTrack", "track", "enableBlackFrame", "bind", "disableAutoSimulcastLayerSelect", "isDisabled", "disableAutoSimulcastLayerSelect$videoview_release", "dispatchAutoSimulcastLayerUpdate", "getCurrentTrack", "onFirstFrameRendered", "onFrameResolutionChanged", "videoWidth", "videoHeight", "rotation", "onSizeChanged", "changedWidth", "changedHeight", "onSizeChanged$videoview_release", "removeTrack", "removeTrack$videoview_release", "safeInit", "safeRelease", "setVideoViewStateChangeListener", "setVideoViewStateChangeListener$videoview_release", "unbind", "updateSimulcastLayer", "Llive/hms/video/media/settings/HMSLayer;", "remoteVideoTrack", "dispatchLayerInfoToSfu", "pickTheClosestLayerBasedOnResolution", "Llive/hms/video/media/tracks/HMSRemoteVideoTrack;", "width", "height", "videoview_release"})
public final class VideoTrackManager
implements RendererCommon.RendererEvents {
    @NotNull
    private final Function0<VideoSink> attachedVideoSink;
    @NotNull
    private final Function1<RendererCommon.RendererEvents, Unit> initRenderer;
    @NotNull
    private final Function0<Unit> releaseRenderer;
    @NotNull
    private final Function0<Unit> clearFrame;
    private final boolean enableAutoSimulcast;
    @Nullable
    private HMSVideoTrack currentTrack;
    @Nullable
    private VideoViewStateChangeListener videoViewStateChangeListener;
    @Nullable
    private ResolutionChangeListener resolutionChangeListener;
    private int currentWidth;
    private int currentHeight;
    private boolean isAutoSimulcastEnabled;
    private boolean pendingTrackUpdate;
    private boolean isInitialised;

    public VideoTrackManager(@NotNull Function0<? extends VideoSink> attachedVideoSink, @NotNull Function1<? super RendererCommon.RendererEvents, Unit> initRenderer, @NotNull Function0<Unit> releaseRenderer, @NotNull Function0<Unit> clearFrame, boolean enableAutoSimulcast) {
        Intrinsics.checkNotNullParameter(attachedVideoSink, (String)"attachedVideoSink");
        Intrinsics.checkNotNullParameter(initRenderer, (String)"initRenderer");
        Intrinsics.checkNotNullParameter(releaseRenderer, (String)"releaseRenderer");
        Intrinsics.checkNotNullParameter(clearFrame, (String)"clearFrame");
        this.attachedVideoSink = attachedVideoSink;
        this.initRenderer = initRenderer;
        this.releaseRenderer = releaseRenderer;
        this.clearFrame = clearFrame;
        this.enableAutoSimulcast = enableAutoSimulcast;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.isAutoSimulcastEnabled = this.enableAutoSimulcast;
    }

    public /* synthetic */ VideoTrackManager(Function0 function0, Function1 function1, Function0 function02, Function0 function03, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this((Function0<? extends VideoSink>)function0, (Function1<? super RendererCommon.RendererEvents, Unit>)function1, (Function0<Unit>)function02, (Function0<Unit>)function03, bl);
    }

    @NotNull
    public final Function0<VideoSink> getAttachedVideoSink() {
        return this.attachedVideoSink;
    }

    @NotNull
    public final Function1<RendererCommon.RendererEvents, Unit> getInitRenderer() {
        return this.initRenderer;
    }

    @NotNull
    public final Function0<Unit> getReleaseRenderer() {
        return this.releaseRenderer;
    }

    @NotNull
    public final Function0<Unit> getClearFrame() {
        return this.clearFrame;
    }

    public final boolean getEnableAutoSimulcast() {
        return this.enableAutoSimulcast;
    }

    public final void addTrack(@Nullable HMSVideoTrack track, boolean enableBlackFrame) {
        HMSVideoTrack it;
        boolean bl;
        boolean bl2;
        HMSVideoTrack hMSVideoTrack;
        HMSVideoTrack hMSVideoTrack2;
        this.safeInit();
        if (track instanceof HMSRemoteVideoTrack && this.currentTrack instanceof HMSRemoteVideoTrack && ((hMSVideoTrack2 = this.currentTrack) == null ? null : hMSVideoTrack2.getTrackId()) == ((HMSRemoteVideoTrack)track).getTrackId()) {
            hMSVideoTrack = this.currentTrack;
            HMSRemoteVideoTrack hMSRemoteVideoTrack = hMSVideoTrack2 = hMSVideoTrack instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack : null;
            if (hMSVideoTrack2 == null ? false : hMSVideoTrack2.getSsrc() == ((HMSRemoteVideoTrack)track).getSsrc()) {
                return;
            }
        }
        if (track instanceof HMSLocalVideoTrack && this.currentTrack instanceof HMSLocalVideoTrack && ((hMSVideoTrack2 = this.currentTrack) == null ? null : hMSVideoTrack2.getTrackId()) == ((HMSLocalVideoTrack)track).getTrackId()) {
            return;
        }
        if (this.currentTrack != null && (hMSVideoTrack2 = this.currentTrack) != null) {
            hMSVideoTrack = hMSVideoTrack2;
            bl2 = false;
            bl = false;
            it = hMSVideoTrack;
            boolean bl3 = false;
            this.unbind(it);
            if (enableBlackFrame) {
                this.getClearFrame().invoke();
            }
        }
        if ((hMSVideoTrack2 = track) != null) {
            hMSVideoTrack = hMSVideoTrack2;
            bl2 = false;
            bl = false;
            it = hMSVideoTrack;
            boolean bl4 = false;
            this.bind(it);
        }
    }

    public static /* synthetic */ void addTrack$default(VideoTrackManager videoTrackManager2, HMSVideoTrack hMSVideoTrack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        videoTrackManager2.addTrack(hMSVideoTrack, bl);
    }

    @Nullable
    public final HMSVideoTrack getCurrentTrack() {
        return this.currentTrack;
    }

    private final void bind(HMSVideoTrack track) {
        HMSLayer optimalLayer = this.updateSimulcastLayer(track, false);
        HMSVideoTrack hMSVideoTrack = track;
        if (hMSVideoTrack instanceof HMSRemoteVideoTrack) {
            HMSLayer hMSLayer;
            ((HMSRemoteVideoTrack)track).addSinkInternal((VideoSink)this.attachedVideoSink.invoke(), (hMSLayer = optimalLayer) == null ? ((HMSRemoteVideoTrack)track).getLayer() : hMSLayer);
        } else if (hMSVideoTrack instanceof HMSLocalVideoTrack) {
            HMSVideoTrack.addSink$default((HMSVideoTrack)track, (VideoSink)((VideoSink)this.attachedVideoSink.invoke()), null, (int)2, null);
        }
        this.currentTrack = track;
    }

    private final void unbind(HMSVideoTrack track) {
        track.removeSink((VideoSink)this.attachedVideoSink.invoke());
        this.currentTrack = null;
    }

    private final void safeInit() {
        if (!this.isInitialised) {
            this.initRenderer.invoke((Object)this);
            this.isInitialised = true;
        }
    }

    private final void safeRelease() {
        if (this.isInitialised) {
            this.releaseRenderer.invoke();
            this.isInitialised = false;
        }
    }

    public final void removeTrack$videoview_release() {
        if (this.currentTrack == null) {
            this.safeRelease();
            return;
        }
        HMSVideoTrack hMSVideoTrack = this.currentTrack;
        if (hMSVideoTrack != null) {
            HMSVideoTrack hMSVideoTrack2 = hMSVideoTrack;
            boolean bl = false;
            boolean bl2 = false;
            HMSVideoTrack it = hMSVideoTrack2;
            boolean bl3 = false;
            this.unbind(it);
        }
        this.safeRelease();
    }

    public final void setVideoViewStateChangeListener$videoview_release(@Nullable VideoViewStateChangeListener videoViewStateChangeListener) {
        this.videoViewStateChangeListener = videoViewStateChangeListener;
    }

    public void onFirstFrameRendered() {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFirstFrameRendered$lambda-3(this));
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFrameResolutionChanged$lambda-4(this, videoWidth, videoHeight));
    }

    public final void onSizeChanged$videoview_release(int changedWidth, int changedHeight) {
        if (this.currentWidth != changedWidth || this.currentHeight != changedHeight) {
            this.currentWidth = changedWidth;
            this.currentHeight = changedHeight;
            this.dispatchAutoSimulcastLayerUpdate();
        }
    }

    private final void dispatchAutoSimulcastLayerUpdate() {
        if (!this.isAutoSimulcastEnabled || this.pendingTrackUpdate) {
            return;
        }
        if (this.currentTrack == null) {
            this.pendingTrackUpdate = true;
        } else if (this.currentTrack instanceof HMSRemoteVideoTrack) {
            HMSRemoteVideoTrack hMSRemoteVideoTrack;
            this.pendingTrackUpdate = true;
            HMSVideoTrack hMSVideoTrack = this.currentTrack;
            HMSRemoteVideoTrack hMSRemoteVideoTrack2 = hMSRemoteVideoTrack = hMSVideoTrack instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack : null;
            if (hMSRemoteVideoTrack != null) {
                hMSVideoTrack = hMSRemoteVideoTrack;
                boolean bl = false;
                boolean bl2 = false;
                HMSVideoTrack it = hMSVideoTrack;
                boolean bl3 = false;
                this.updateSimulcastLayer(it, true);
            }
        }
    }

    private final HMSLayer updateSimulcastLayer(HMSVideoTrack remoteVideoTrack, boolean dispatchLayerInfoToSfu) {
        HMSLayer preferredLayer = null;
        if (this.pendingTrackUpdate && this.isAutoSimulcastEnabled && remoteVideoTrack instanceof HMSRemoteVideoTrack) {
            preferredLayer = this.pickTheClosestLayerBasedOnResolution((HMSRemoteVideoTrack)remoteVideoTrack, this.currentWidth, this.currentHeight);
            if (preferredLayer != null && dispatchLayerInfoToSfu) {
                HMSRemoteVideoTrack.setLayer$default((HMSRemoteVideoTrack)((HMSRemoteVideoTrack)remoteVideoTrack), (HMSLayer)preferredLayer, null, (int)2, null);
            }
            this.pendingTrackUpdate = false;
        }
        return preferredLayer;
    }

    private final HMSLayer pickTheClosestLayerBasedOnResolution(HMSRemoteVideoTrack $this$pickTheClosestLayerBasedOnResolution, int width, int height) {
        Collection collection = $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HMSSimulcastLayerDefinition selectedLayer = (HMSSimulcastLayerDefinition)$this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().get($this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().size() - 1);
        int min = Integer.MAX_VALUE;
        for (HMSSimulcastLayerDefinition layer : $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition()) {
            int videoViewSurfaceArea = width * height;
            int layerSurfaceArea = layer.getResolution().getWidth() * layer.getResolution().getHeight();
            int n = videoViewSurfaceArea - layerSurfaceArea;
            boolean bl3 = false;
            int diff = Math.abs(n);
            if (diff >= min) continue;
            selectedLayer = layer;
            min = diff;
        }
        return selectedLayer.getLayer();
    }

    public final void disableAutoSimulcastLayerSelect$videoview_release(boolean isDisabled) {
        this.isAutoSimulcastEnabled = !isDisabled;
        this.dispatchAutoSimulcastLayerUpdate();
    }

    private static final void onFirstFrameRendered$lambda-3(VideoTrackManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
        if (videoViewStateChangeListener != null) {
            videoViewStateChangeListener.onFirstFrameRendered();
        }
    }

    private static final void onFrameResolutionChanged$lambda-4(VideoTrackManager this$0, int $videoWidth, int $videoHeight) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
        if (videoViewStateChangeListener != null) {
            videoViewStateChangeListener.onResolutionChange($videoWidth, $videoHeight);
        }
    }
}

