/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview;

import android.os.Handler;
import android.os.Looper;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.settings.HMSLayer;
import live.hms.video.media.settings.HMSSimulcastLayerDefinition;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.utils.SharedEglContext;
import live.hms.videoview.ResolutionChangeListener;
import live.hms.videoview.VideoViewStateChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoSink;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\bJ\b\u0010\u001b\u001a\u00020\u0013H\u0016J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u001d\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002J\u0015\u0010(\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u001e\u0010/\u001a\u0004\u0018\u00010,*\u0002002\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Llive/hms/videoview/VideoTrackManager;", "Lorg/webrtc/RendererCommon$RendererEvents;", "surfaceViewRenderer", "Lorg/webrtc/SurfaceViewRenderer;", "(Lorg/webrtc/SurfaceViewRenderer;)V", "currentHeight", "", "currentTrack", "Llive/hms/video/media/tracks/HMSVideoTrack;", "currentWidth", "isAutoSimulcastEnabled", "", "isInitialised", "pendingTrackUpdate", "resolutionChangeListener", "Llive/hms/videoview/ResolutionChangeListener;", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "addTrack", "", "track", "bind", "disableAutoSimulcastLayerSelect", "isDisabled", "disableAutoSimulcastLayerSelect$videoview_release", "dispatchAutoSimulcastLayerUpdate", "getCurrentTrack", "onFirstFrameRendered", "onFrameResolutionChanged", "videoWidth", "videoHeight", "rotation", "onSizeChanged", "changedWidth", "changedHeight", "onSizeChanged$videoview_release", "removeTrack", "removeTrack$videoview_release", "safeInit", "safeRelease", "setVideoViewStateChangeListener", "setVideoViewStateChangeListener$videoview_release", "unbind", "updateSimulcastLayer", "Llive/hms/video/media/settings/HMSLayer;", "remoteVideoTrack", "dispatchLayerInfoToSfu", "pickTheClosestLayerBasedOnResolution", "Llive/hms/video/media/tracks/HMSRemoteVideoTrack;", "width", "height", "videoview_release"})
public final class VideoTrackManager
implements RendererCommon.RendererEvents {
    @NotNull
    private final SurfaceViewRenderer surfaceViewRenderer;
    @Nullable
    private HMSVideoTrack currentTrack;
    @Nullable
    private VideoViewStateChangeListener videoViewStateChangeListener;
    @Nullable
    private ResolutionChangeListener resolutionChangeListener;
    private int currentWidth;
    private int currentHeight;
    private boolean isAutoSimulcastEnabled;
    private boolean pendingTrackUpdate;
    private boolean isInitialised;

    public VideoTrackManager(@NotNull SurfaceViewRenderer surfaceViewRenderer) {
        Intrinsics.checkNotNullParameter((Object)surfaceViewRenderer, (String)"surfaceViewRenderer");
        this.surfaceViewRenderer = surfaceViewRenderer;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.isAutoSimulcastEnabled = true;
    }

    public final void addTrack(@NotNull HMSVideoTrack track) {
        HMSVideoTrack hMSVideoTrack;
        HMSVideoTrack hMSVideoTrack2;
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.safeInit();
        if (track instanceof HMSRemoteVideoTrack && this.currentTrack instanceof HMSRemoteVideoTrack && ((hMSVideoTrack2 = this.currentTrack) == null ? null : hMSVideoTrack2.getTrackId()) == track.getTrackId() && ((hMSVideoTrack2 = (hMSVideoTrack = this.currentTrack) instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack : null) == null ? null : Long.valueOf(hMSVideoTrack2.getSsrc())) == Long.valueOf(((HMSRemoteVideoTrack)track).getSsrc())) {
            return;
        }
        if (track instanceof HMSLocalVideoTrack && this.currentTrack instanceof HMSLocalVideoTrack && ((hMSVideoTrack2 = this.currentTrack) == null ? null : hMSVideoTrack2.getTrackId()) == track.getTrackId()) {
            return;
        }
        if (this.currentTrack != null && (hMSVideoTrack2 = this.currentTrack) != null) {
            hMSVideoTrack = hMSVideoTrack2;
            boolean bl = false;
            boolean bl2 = false;
            HMSVideoTrack it = hMSVideoTrack;
            boolean bl3 = false;
            this.unbind(it);
        }
        this.bind(track);
    }

    @Nullable
    public final HMSVideoTrack getCurrentTrack() {
        return this.currentTrack;
    }

    private final void bind(HMSVideoTrack track) {
        HMSLayer optimalLayer = this.updateSimulcastLayer(track, false);
        HMSVideoTrack hMSVideoTrack = track;
        if (hMSVideoTrack instanceof HMSRemoteVideoTrack) {
            HMSLayer hMSLayer = optimalLayer;
            ((HMSRemoteVideoTrack)track).addSinkInternal((VideoSink)this.surfaceViewRenderer, hMSLayer == null ? ((HMSRemoteVideoTrack)track).getLayer() : hMSLayer);
        } else if (hMSVideoTrack instanceof HMSLocalVideoTrack) {
            HMSVideoTrack.addSink$default((HMSVideoTrack)track, (VideoSink)((VideoSink)this.surfaceViewRenderer), null, (int)2, null);
        }
        this.currentTrack = track;
    }

    private final void unbind(HMSVideoTrack track) {
        track.removeSink((VideoSink)this.surfaceViewRenderer);
        this.currentTrack = null;
    }

    private final void safeInit() {
        if (!this.isInitialised) {
            this.surfaceViewRenderer.init(SharedEglContext.INSTANCE.getContext(), (RendererCommon.RendererEvents)this);
            this.isInitialised = true;
        }
    }

    private final void safeRelease() {
        if (this.isInitialised) {
            this.surfaceViewRenderer.release();
            this.isInitialised = false;
        }
    }

    public final void removeTrack$videoview_release() {
        if (this.currentTrack == null) {
            this.safeRelease();
            return;
        }
        HMSVideoTrack hMSVideoTrack = this.currentTrack;
        if (hMSVideoTrack != null) {
            HMSVideoTrack hMSVideoTrack2 = hMSVideoTrack;
            boolean bl = false;
            boolean bl2 = false;
            HMSVideoTrack it = hMSVideoTrack2;
            boolean bl3 = false;
            this.unbind(it);
        }
        this.safeRelease();
    }

    public final void setVideoViewStateChangeListener$videoview_release(@NotNull VideoViewStateChangeListener videoViewStateChangeListener) {
        Intrinsics.checkNotNullParameter((Object)videoViewStateChangeListener, (String)"videoViewStateChangeListener");
        this.videoViewStateChangeListener = videoViewStateChangeListener;
    }

    public void onFirstFrameRendered() {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFirstFrameRendered$lambda-2(this));
    }

    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        new Handler(Looper.getMainLooper()).post(() -> VideoTrackManager.onFrameResolutionChanged$lambda-3(this, videoWidth, videoHeight));
    }

    public final void onSizeChanged$videoview_release(int changedWidth, int changedHeight) {
        if (this.currentWidth != changedWidth || this.currentHeight != changedHeight) {
            this.currentWidth = changedWidth;
            this.currentHeight = changedHeight;
            this.dispatchAutoSimulcastLayerUpdate();
        }
    }

    private final void dispatchAutoSimulcastLayerUpdate() {
        if (!this.isAutoSimulcastEnabled || this.pendingTrackUpdate) {
            return;
        }
        if (this.currentTrack == null) {
            this.pendingTrackUpdate = true;
        } else if (this.currentTrack instanceof HMSRemoteVideoTrack) {
            HMSRemoteVideoTrack hMSRemoteVideoTrack;
            this.pendingTrackUpdate = true;
            HMSVideoTrack hMSVideoTrack = this.currentTrack;
            HMSRemoteVideoTrack hMSRemoteVideoTrack2 = hMSRemoteVideoTrack = hMSVideoTrack instanceof HMSRemoteVideoTrack ? (HMSRemoteVideoTrack)hMSVideoTrack : null;
            if (hMSRemoteVideoTrack != null) {
                hMSVideoTrack = hMSRemoteVideoTrack;
                boolean bl = false;
                boolean bl2 = false;
                HMSVideoTrack it = hMSVideoTrack;
                boolean bl3 = false;
                this.updateSimulcastLayer(it, true);
            }
        }
    }

    private final HMSLayer updateSimulcastLayer(HMSVideoTrack remoteVideoTrack, boolean dispatchLayerInfoToSfu) {
        HMSLayer preferredLayer = null;
        if (this.pendingTrackUpdate && this.isAutoSimulcastEnabled && remoteVideoTrack instanceof HMSRemoteVideoTrack) {
            preferredLayer = this.pickTheClosestLayerBasedOnResolution((HMSRemoteVideoTrack)remoteVideoTrack, this.currentWidth, this.currentHeight);
            if (preferredLayer != null && dispatchLayerInfoToSfu) {
                HMSRemoteVideoTrack.setLayer$default((HMSRemoteVideoTrack)((HMSRemoteVideoTrack)remoteVideoTrack), (HMSLayer)preferredLayer, null, (int)2, null);
            }
            this.pendingTrackUpdate = false;
        }
        return preferredLayer;
    }

    private final HMSLayer pickTheClosestLayerBasedOnResolution(HMSRemoteVideoTrack $this$pickTheClosestLayerBasedOnResolution, int width, int height) {
        Collection collection = $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        HMSSimulcastLayerDefinition approximateLayer = (HMSSimulcastLayerDefinition)$this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().get($this$pickTheClosestLayerBasedOnResolution.getLayerDefinition().size() - 1);
        for (HMSSimulcastLayerDefinition layer : $this$pickTheClosestLayerBasedOnResolution.getLayerDefinition()) {
            if (width < layer.getResolution().getWidth() || height < layer.getResolution().getHeight()) continue;
            approximateLayer = layer;
            break;
        }
        return approximateLayer.getLayer();
    }

    public final void disableAutoSimulcastLayerSelect$videoview_release(boolean isDisabled) {
        this.isAutoSimulcastEnabled = !isDisabled;
        this.dispatchAutoSimulcastLayerUpdate();
    }

    private static final void onFirstFrameRendered$lambda-2(VideoTrackManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
        if (videoViewStateChangeListener != null) {
            videoViewStateChangeListener.onFirstFrameRendered();
        }
    }

    private static final void onFrameResolutionChanged$lambda-3(VideoTrackManager this$0, int $videoWidth, int $videoHeight) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VideoViewStateChangeListener videoViewStateChangeListener = this$0.videoViewStateChangeListener;
        if (videoViewStateChangeListener != null) {
            videoViewStateChangeListener.onResolutionChange($videoWidth, $videoHeight);
        }
    }
}

