/*
 * Decompiled with CFR 0.152.
 */
package live.hms.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSRemoteVideoTrack;
import live.hms.video.media.tracks.HMSVideoTrack;
import live.hms.video.sdk.HmsVideoFrameListener;
import live.hms.videoview.HMSVideoView;
import live.hms.videoview.VideoTrackManager;
import live.hms.videoview.VideoViewStateChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglRenderer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u00020\u00112\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00110\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u0013J0\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0014J\u0006\u0010(\u001a\u00020\u0011J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\tH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Llive/hms/videoview/HMSVideoView;", "Lorg/webrtc/SurfaceViewRenderer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentScalingType", "Lorg/webrtc/RendererCommon$ScalingType;", "videoTrackManager", "Llive/hms/videoview/VideoTrackManager;", "getVideoTrackManager", "()Llive/hms/videoview/VideoTrackManager;", "videoTrackManager$delegate", "Lkotlin/Lazy;", "addTrack", "", "track", "Llive/hms/video/media/tracks/HMSVideoTrack;", "addVideoViewStateChangeListener", "videoViewStateChangeListener", "Llive/hms/videoview/VideoViewStateChangeListener;", "captureBitmap", "onBitmap", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "scale", "", "disableAutoSimulcastLayerSelect", "isDisabled", "", "getTrack", "onLayout", "changed", "left", "", "top", "right", "bottom", "removeTrack", "setScalingType", "scalingType", "videoview_release"})
public final class HMSVideoView
extends SurfaceViewRenderer {
    @Nullable
    private RendererCommon.ScalingType currentScalingType;
    @NotNull
    private final Lazy videoTrackManager$delegate;

    public HMSVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.videoTrackManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoTrackManager>(this){
            final /* synthetic */ HMSVideoView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VideoTrackManager invoke() {
                return new VideoTrackManager(this.this$0);
            }
        }));
    }

    public HMSVideoView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.videoTrackManager$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
    }

    private final VideoTrackManager getVideoTrackManager() {
        Lazy lazy = this.videoTrackManager$delegate;
        boolean bl = false;
        return (VideoTrackManager)lazy.getValue();
    }

    public final void addTrack(@NotNull HMSVideoTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        if (track instanceof HMSRemoteVideoTrack) {
            Log.i((String)"HMSVIDEOVIEW", (String)("TRACK%%TRACK ADDED trackID: " + track.getTrackId() + " ssrc:" + ((HMSRemoteVideoTrack)track).getSsrc() + ' '));
        }
        this.getVideoTrackManager().addTrack(track);
    }

    @Nullable
    public final HMSVideoTrack getTrack() {
        return this.getVideoTrackManager().getCurrentTrack();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.getVideoTrackManager().onSizeChanged$videoview_release(Math.abs(left - right), Math.abs(top - bottom));
    }

    public final void disableAutoSimulcastLayerSelect(boolean isDisabled) {
        this.getVideoTrackManager().disableAutoSimulcastLayerSelect$videoview_release(isDisabled);
    }

    public final void removeTrack() {
        HMSVideoTrack track = this.getTrack();
        if (track instanceof HMSRemoteVideoTrack) {
            Log.i((String)"HMSVIDEOVIEW", (String)("TRACK%%TRACK remove trackID: " + ((HMSRemoteVideoTrack)track).getTrackId() + " ssrc:" + ((HMSRemoteVideoTrack)track).getSsrc() + ' '));
        }
        this.getVideoTrackManager().removeTrack$videoview_release();
    }

    public final void addVideoViewStateChangeListener(@NotNull VideoViewStateChangeListener videoViewStateChangeListener) {
        Intrinsics.checkNotNullParameter((Object)videoViewStateChangeListener, (String)"videoViewStateChangeListener");
        this.getVideoTrackManager().setVideoViewStateChangeListener$videoview_release(videoViewStateChangeListener);
    }

    public final void captureBitmap(@NotNull Function1<? super Bitmap, Unit> onBitmap, float scale) {
        Intrinsics.checkNotNullParameter(onBitmap, (String)"onBitmap");
        HMSVideoTrack currentVideoTrack = this.getVideoTrackManager().getCurrentTrack();
        if (currentVideoTrack instanceof HMSLocalVideoTrack) {
            ((HMSLocalVideoTrack)currentVideoTrack).captureImageAtMaxPublishResolution(new HmsVideoFrameListener(onBitmap){
                final /* synthetic */ Function1<Bitmap, Unit> $onBitmap;
                {
                    this.$onBitmap = $onBitmap;
                }

                public void onFrameCaptured(@NotNull Bitmap bitmap) {
                    Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                    this.$onBitmap.invoke((Object)bitmap);
                }
            });
        } else {
            this.addFrameListener(new EglRenderer.FrameListener(onBitmap, this){
                final /* synthetic */ Function1<Bitmap, Unit> $onBitmap;
                final /* synthetic */ HMSVideoView this$0;
                {
                    this.$onBitmap = $onBitmap;
                    this.this$0 = $receiver;
                }

                public void onFrame(@Nullable Bitmap bitmap) {
                    this.$onBitmap.invoke((Object)bitmap);
                    new Handler(Looper.getMainLooper()).post(() -> captureBitmap.2.onFrame$lambda-0(this.this$0, this));
                }

                private static final void onFrame$lambda-0(HMSVideoView this$0, captureBitmap.2 this$1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                    this$0.removeFrameListener(this$1);
                }
            }, scale);
        }
    }

    public static /* synthetic */ void captureBitmap$default(HMSVideoView hMSVideoView, Function1 function1, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        hMSVideoView.captureBitmap((Function1<? super Bitmap, Unit>)function1, f);
    }

    public void setScalingType(@NotNull RendererCommon.ScalingType scalingType) {
        Intrinsics.checkNotNullParameter((Object)scalingType, (String)"scalingType");
        if (scalingType != this.currentScalingType) {
            super.setScalingType(scalingType);
            this.currentScalingType = scalingType;
        }
    }
}

